/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.player;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Display;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.song.models.Measure;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class PlaySongAction extends Action {
    public static final String NAME = "PLAY_SONG";

    private Player player;

    public PlaySongAction(TablatureEditor tablatureEditor) {
        super(NAME,true, tablatureEditor);
        this.player = getEditor().getSongManager().getPlayer();
    }

    public boolean doAction(TypedEvent e) {
    	if(!player.isRunning()){
    		if(checkSoundbank()){
    			player.play();
    			redrawTablaturePlayMode();
    		}
    	}else{
    		Measure measure = getSongManager().getTrackManager().getMeasureAt(getSongManager().getFirstTrack(),player.getTickPosition());    	    
    		player.pause();
    		if(measure != null){
    			player.setTickPosition(measure.getStartWidthRepetitions(),measure.getStartWidthRepetitions() - measure.getStart());
    		}
    		getEditor().getTablature().getCaret().goToTickPosition();
    	    redrawTablatureStopMode();
    	}
        return true;
    }   
    
    private boolean checkSoundbank(){
    	if(player.getSoundbank() == null){
    		String title = TuxGuitar.getProperty("soundbank.error");    	
    		String message = TuxGuitar.getProperty("soundbank.error.unavailable");
    		new MessageDialog(title,message,SWT.ICON_ERROR | SWT.OK).show(getEditor().getTablature().getShell());
    		return false;
    	}
    	return true;
    }
    
    protected void redrawTablaturePlayMode() {
        final Display display = TuxGuitar.instance().getDisplay();
        final Runnable playing = new Runnable() {
            public void run() {
            	if(getEditor().getSongManager().getPlayer().isRunning()){
            		TuxGuitar.instance().redrawPayingMode();
            	}
            }
        };
        final Runnable finish = new Runnable() {
            public void run() {
                update();
                redraw();
            }
        };
        new Thread(new Runnable() {
            public void run() {
                while (player.isRunning()) {
                    if(!display.isDisposed()){
                        display.syncExec(playing);    
                        sleep(80);
                    }
                }
                if(!display.isDisposed()){
                    display.syncExec(finish);
                }
            }
        }).start();
    }

    private void redrawTablatureStopMode(){
        new SyncThread(new Runnable() {
            public void run() {
                if(!TuxGuitar.isDisposed()){
                redraw();
                }
            }
        }).start();   
    }    
    
    private void sleep(long time){
    	try {
			Thread.sleep(time);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
    }
    
}