/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.insert;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeCloseRepeat;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CloseRepeatAction extends Action{
    public static final String NAME = "CLOSE_REPEAT";
    
    public CloseRepeatAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        MeasureCoords measureCoords = getEditor().getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = getEditor().getTablature().getCaret().getSongCoords();        
        showCloseRepeatDialog(getEditor().getTablature().getShell(), measureCoords, songCoords);
        return true;
    }

    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        redraw();
    }        
    
    public void showCloseRepeatDialog(Shell shell, final MeasureCoords measureCoords, final SongCoords songCoords) {
        if (measureCoords != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("repetitions"));
            
            
            int currentNumberOfRepetitions = measureCoords.getMeasure().getNumberOfRepetitions();
            if (currentNumberOfRepetitions < 1) {
                currentNumberOfRepetitions = 1;
            }

            Composite composite = new Composite(dialog,SWT.NONE);
            composite.setLayout(new GridLayout(2,false));
            composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
            
            Label numberOfRepetitionsLabel = new Label(composite, SWT.NULL);
            numberOfRepetitionsLabel.setText(TuxGuitar.getProperty("repeat.number-of-repetitions"));

            final Spinner numberOfRepetitions = new Spinner(composite, SWT.BORDER);
            numberOfRepetitions.setLayoutData(new GridData(50,13));                 
            numberOfRepetitions.setMinimum(0);
            numberOfRepetitions.setMaximum(100);
            numberOfRepetitions.setSelection(currentNumberOfRepetitions);
            numberOfRepetitions.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));
            
            //----------------------BUTTONS--------------------------------
            Composite buttons = new Composite(dialog, SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));
            buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
            
            GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
            data.minimumWidth = 80;
            data.minimumHeight = 25;            
            
            final Button buttonOK = new Button(buttons, SWT.PUSH);            
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(data);
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                	closeRepeat(measureCoords, songCoords, numberOfRepetitions.getSelection());
                    dialog.dispose();
                }
            });                        
            Button buttonCancel = new Button(buttons, SWT.PUSH);            
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData(data);
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);

    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }
        }

    }

    private void closeRepeat(MeasureCoords measureCoords, SongCoords songCoords, int numberOfRepetitions) {
        //comienza el undoable
    	UndoableChangeCloseRepeat undoable = UndoableChangeCloseRepeat.startUndo(); 
    	
        numberOfRepetitions = Math.abs(numberOfRepetitions);
        getSongManager().changeCloseRepeat(measureCoords.getMeasure().getStart(), numberOfRepetitions);
        updateTablature();
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo(numberOfRepetitions));
    }    

}
