/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.FileNotFoundException;
import java.io.IOException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.UnsupportedFormatException;
import org.herac.tuxguitar.io.gp.GPFormatException;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class OpenFileAction extends Action {
    public static final String NAME = "OPEN_FILE";
    
    private String fileName;
    
    public OpenFileAction(TablatureEditor tablatureEditor) {
        super(NAME,true, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
    	getEditor().getSongManager().getPlayer().reset();
    	Shell parent = getEditor().getTablature().getShell();    	
    	if(e.widget.getData() instanceof String){
    		fileName = (String)e.widget.getData();
    	}else{
    		fileName = FileChooser.instance().open(parent,FileChooser.OPEN_FORMAT,TuxGuitar.instance().getFileHistory().getFileName());
    	}
        if (fileName != null) {
            getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
            new Thread(new Runnable() {
                public void run() {
                    try {
                        getEditor().getSongManager().open(fileName);
                    } catch (FileNotFoundException e) {
                        showErrorMessage(fileName);
                        e.printStackTrace();
                    } catch (GPFormatException e) {
                        showErrorMessage(fileName);
                        e.printStackTrace();
                    } catch (IOException e) {
                        showErrorMessage(fileName);
                        e.printStackTrace();
                    } catch (UnsupportedFormatException e) {
                    	showErrorMessage(fileName);
						e.printStackTrace();
					}
  
                    
                    
                    new SyncThread(new Runnable() {
                        public void run() {
                            if(!TuxGuitar.isDisposed()){
                            	TuxGuitar.instance().getFileHistory().setFile(fileName);
                            	TuxGuitar.instance().getTablatureEditor().resetDefaults();
                            	TuxGuitar.instance().getMixer().update();
                            	TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();
                            	redraw();
                            	getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
                            }
                        }
                    }).start();

                }
            }).start();

        }

        return true;
    }
    
    
    private void showErrorMessage(final String fileName){
        new SyncThread( new Runnable() {
            public void run() {
                if(!TuxGuitar.isDisposed()){
                getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);                
                String name = "Error Message";
                String message = "Cannot Open file: " + fileName;
                new MessageDialog(name,message,SWT.ICON_ERROR | SWT.OK).show(getEditor().getTablature().getShell());
                }
            }
        }).start();        
    }

}