/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.IOException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.importer.MidiImporter;
import org.herac.tuxguitar.song.models.Song;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ImportMidiAction extends Action {
    public static final String NAME = "IMPORT_MIDI";

    public ImportMidiAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
    	getEditor().getSongManager().getPlayer().reset();
    	Shell parent = getEditor().getTablature().getShell();
        
        final String fileName = FileChooser.instance().open(parent,FileChooser.IMPORT_MIDI_FORMAT,TuxGuitar.instance().getFileHistory().getFileName());
        if (fileName != null) {
            getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
            new Thread(new Runnable() {
                public void run() {                    
                	try {
						Song song = new MidiImporter().importSong(fileName);
						TuxGuitar.instance().getSongManager().setSong(song);
					} catch (IOException e) {
						e.printStackTrace();
					} catch (Exception e) {
						e.printStackTrace();
					} catch (Error e) {
						e.printStackTrace();
					}            
					
                    new SyncThread(new Runnable() {
                        public void run() {
                            if(!TuxGuitar.isDisposed()){
                            	getEditor().resetDefaults();
                            	TuxGuitar.instance().getMixer().update();
                            	TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();
                            	redraw();
                            	getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
                            }
                        }
                    }).start();

                }
            }).start();

        }

        return true;
    }
    
    
    private void showErrorMessage(final String fileName){
        new SyncThread( new Runnable() {
            public void run() {
                if(!TuxGuitar.isDisposed()){
                getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);                
                String name = "Error Message";
                String message = "Cannot Open file: " + fileName;
                new MessageDialog(name,message,SWT.ICON_ERROR | SWT.OK).show(getEditor().getTablature().getShell());
                }
            }
        }).start();        
    }

}