/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.gui.util.PDFWriter;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ExportPDFAction extends Action {
	public static final String NAME = "EXPORT_PDF";

	public ExportPDFAction(TablatureEditor tablatureEditor) {
		super(NAME,tablatureEditor);
	}

	public boolean doAction(TypedEvent e) {
		String defaultFileName = chengeFormat(TuxGuitar.instance().getFileHistory().getFileName(),getDefaultExtension());
		
		Shell parent = getEditor().getTablature().getShell();
		String selectedName = FileChooser.instance().save(parent,FileChooser.EXPORT_PDF_FORMAT,defaultFileName);
		if (selectedName != null) {
			boolean canWrite = true;
			if (!isSuportedFormat(selectedName)) {
				selectedName += getDefaultExtension();
			}
			final String fileName = selectedName;

			File file = new File(fileName);
			if (file.exists()) {
				ConfirmDialog confirm = new ConfirmDialog(getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"));

				if (!confirm.confirm()) {
					canWrite = false;
				}
			}

			if (canWrite) {
				getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
				new Thread(new Runnable() {
					public void run() {						
						new SyncThread(new Runnable() {
							public void run() {
								try {
									writeFile(new FileOutputStream(fileName));
								} catch (FileNotFoundException e) {
									e.printStackTrace();
								}								
							    if(!TuxGuitar.isDisposed()){
							    	getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
							    }
							}
						}).start();
					}
				}).start();
			}
		}

		return true;
	}	


	
	private String getDefaultFileName(String fileName) {
		String defaultFileName = "untitled";
		String defaultExtencion = getDefaultExtension();
		if (fileName == null) {
			fileName = defaultFileName + defaultExtencion;
		} else if (!isSuportedFormat(fileName)) {
			fileName = chengeFormat(fileName, defaultExtencion);
		}

		return fileName;
	}

	private boolean isSuportedFormat(String fileName) {
		return (fileName.endsWith(getDefaultExtension()));
	}

	private String chengeFormat(String fileName, String format) {
		return removeExtension(fileName) + format;
	}

	private String removeExtension(String fileName) {
		int index = fileName.lastIndexOf('.');
		return fileName.substring(0, index);
	}

	private String getDefaultExtension() {
		return ".pdf";
	}
	
	private void writeFile(OutputStream out){
    	try{
    		PDFWriter.write(out,makePrintDocument());   	
    	}catch(OutOfMemoryError error){
    		showErrorMessage(error);
    		return;
    	}
	}
	
	public PrintDocument makePrintDocument(){	
		Tablature tablature = new Tablature(getEditor().getTablature(),SWT.NONE);
        tablature.setSongManager(getEditor().getSongManager());
        
        PrinterViewLayout layout = new PrinterViewLayout(tablature,getEditor().getSongManager(),false,false);
        tablature.initDefaults(layout);			
        tablature.updateTablature();	
        tablature.getCaret().update(getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber());
        
        PrintDocument doc = layout.makeDocument(new Rectangle(0,0,550,800));        
        tablature.dispose();        
		return doc;
	}

    private void showErrorMessage(final Error error){
        new SyncThread( new Runnable() {
            public void run() {
                if(!TuxGuitar.isDisposed()){                              
                	String name = error.getClass().getName();
                	String message = error.getMessage();
                	new MessageDialog(name,message,SWT.ICON_ERROR | SWT.OK).show(getEditor().getTablature().getShell());
                }
            }
        }).start();        
    }

}
