/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ExportMidiAction extends Action {
	public static final String NAME = "EXPORT_MIDI";

	public ExportMidiAction(TablatureEditor tablatureEditor) {
		super(NAME,tablatureEditor);
	}

	public boolean doAction(TypedEvent e) {
		String defaultFileName = chengeFormat(TuxGuitar.instance().getFileHistory().getFileName(),getDefaultExtension());
		
		Shell parent = getEditor().getTablature().getShell();
		String[] filterNames = null;
		String[] filterExtensions = new String[] { "*.mid" };
		String selectedName = FileChooser.instance().save(parent,FileChooser.EXPORT_MIDI_FORMAT, defaultFileName);
		if (selectedName != null) {
			boolean canWrite = true;
			if (!isSuportedFormat(selectedName)) {
				selectedName += getDefaultExtension();
			}
			final String fileName = selectedName;

			File file = new File(fileName);
			if (file.exists()) {
				ConfirmDialog confirm = new ConfirmDialog(getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"));

				if (!confirm.confirm()) {
					canWrite = false;
				}
			}

			if (canWrite) {
				getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
				new Thread(new Runnable() {
					public void run() {						
						try {
							getEditor().getSongManager().getPlayer().write(new FileOutputStream(fileName));
						} catch (FileNotFoundException e) {
							e.printStackTrace();
						}
						new SyncThread(new Runnable() {
							public void run() {
							    if(!TuxGuitar.isDisposed()){
							    	getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
							    }
							}
						}).start();
					}
				}).start();
			}
		}

		return true;
	}	

	private String getDefaultFileName(String fileName) {
		String defaultFileName = "untitled";
		String defaultExtencion = getDefaultExtension();
		if (fileName == null) {
			fileName = defaultFileName + defaultExtencion;
		} else if (!isSuportedFormat(fileName)) {
			fileName = chengeFormat(fileName, defaultExtencion);
		}

		return fileName;
	}

	private boolean isSuportedFormat(String fileName) {
		return (fileName.endsWith(".mid"));
	}

	private String chengeFormat(String fileName, String format) {
		return removeExtension(fileName) + format;
	}

	private String removeExtension(String fileName) {
		int index = fileName.lastIndexOf('.');
		return fileName.substring(0, index);
	}

	private String getDefaultExtension() {
		return ".mid";
	}

}
