/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeKeySignature;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeKeySignatureAction extends Action{
    public static final String NAME = "CHANGE_KEY_SIGNATURE";
    
    public ChangeKeySignatureAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell()); 
        return true;
    }

    
    public void showDialog(Shell shell) {
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
   
            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("composition.keysignature"));

            //-------key Signature-------------------------------------
            Composite keySignature = new Composite(dialog, SWT.NONE);
            keySignature.setLayout(new GridLayout(2,false));
            keySignature.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));   
            
            Label numeratorLabel = new Label(keySignature, SWT.NULL);
            numeratorLabel.setText(TuxGuitar.getProperty("composition.keysignature"));
            
            final Combo keySignatures = new Combo(keySignature, SWT.NULL);
            
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.natural"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.sharp-1"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.sharp-2"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.sharp-3"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.sharp-4"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.sharp-5"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.sharp-6"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.sharp-7"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.flat-1"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.flat-2"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.flat-3"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.flat-4"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.flat-5"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.flat-6"));
            keySignatures.add(TuxGuitar.getProperty("composition.keysignature.flat-7"));
            keySignatures.select(measure.getMeasure().getKeySignature());
            keySignatures.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));
            //--------------------To End Checkbox-------------------------------
            Composite check = new Composite(dialog, SWT.NONE);
            check.setLayout(new GridLayout());
            check.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));   
            
            final Button toEnd = new Button(check, SWT.CHECK);
            toEnd.setText(TuxGuitar.getProperty("composition.keysignature.to-the-end"));
            toEnd.setSelection(true);
            //------------------BUTTONS--------------------------            
            Composite buttons = new Composite(dialog, SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));
            buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
            
            GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
            data.minimumWidth = 80;
            data.minimumHeight = 25;      
            
            final Button buttonOK = new Button(buttons, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(data);
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    boolean toEndValue = toEnd.getSelection();                    
                    setKeySignature(keySignatures.getSelectionIndex(),toEndValue);
                    
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData(data);
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
            
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }
        }
    }
    
    
    private void setKeySignature(int keySignature,boolean toEnd){    	
        //comienza el undoable
    	UndoableChangeKeySignature undoable = UndoableChangeKeySignature.startUndo(); 
    	
        Measure measure = getEditor().getTablature().getCaret().getMeasureCoords().getMeasure();
        SongTrack track = getEditor().getTablature().getCaret().getSongTrackCoords().getTrack();        
        getSongManager().getTrackManager().changeKeySignature(track,measure.getStart(),keySignature,toEnd);
        
        //actualizo la tablatura
        updateTablature();
        redraw();                
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo(keySignature,toEnd));
        
    }    

}
