/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeClef;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeClefAction extends Action{
    public static final String NAME = "CHANGE_CLEF";
    
    public ChangeClefAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell()); 
        return true;
    }

    
    public void showDialog(Shell shell) {
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
   
            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("composition.clef"));

            //-------clef-------------------------------------
            Composite clef = new Composite(dialog, SWT.NONE);
            clef.setLayout(new GridLayout(2,false));
            clef.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));   
            
            Label numeratorLabel = new Label(clef, SWT.NULL);
            numeratorLabel.setText(TuxGuitar.getProperty("composition.clef"));
            
            final Combo clefs = new Combo(clef, SWT.NULL);
            
            clefs.add(TuxGuitar.getProperty("composition.clef.treble"));
            clefs.add(TuxGuitar.getProperty("composition.clef.bass"));
            clefs.add(TuxGuitar.getProperty("composition.clef.tenor"));
            clefs.add(TuxGuitar.getProperty("composition.clef.alto"));
            clefs.select(measure.getMeasure().getClef() - 1);
            clefs.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));
            
            //--------------------To End Checkbox-------------------------------
            Composite check = new Composite(dialog, SWT.NONE);
            check.setLayout(new GridLayout());
            check.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));             
                        
            final Button toEnd = new Button(check, SWT.CHECK);
            toEnd.setText(TuxGuitar.getProperty("composition.clef.to-the-end"));
            toEnd.setSelection(true);
            //------------------BUTTONS--------------------------            
            Composite buttons = new Composite(dialog, SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));
            buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
            
            GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
            data.minimumWidth = 80;
            data.minimumHeight = 25;    
            
            final Button buttonOK = new Button(buttons, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(data);
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    boolean toEndValue = toEnd.getSelection();                    
                    setClef((clefs.getSelectionIndex() + 1),toEndValue);
                    
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData(data);
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
            
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }
        }
    }
    
    
    private void setClef(int clef,boolean toEnd){    	
        //comienza el undoable
    	UndoableChangeClef undoable = UndoableChangeClef.startUndo(); 
    	
        Measure measure = getEditor().getTablature().getCaret().getMeasureCoords().getMeasure();
        SongTrack track = getEditor().getTablature().getCaret().getSongTrackCoords().getTrack();
        getSongManager().getTrackManager().changeClef(track,measure.getStart(),clef,toEnd);
        
        //actualizo la tablatura
        updateTablature();
        redraw();                
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo(clef,toEnd));
        
    }    

}
