/*
 * Created on 25-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui;

import java.io.File;
import java.io.IOException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionContainer;
import org.herac.tuxguitar.gui.config.PropertyNames;
import org.herac.tuxguitar.gui.config.SystemConfigManager;
import org.herac.tuxguitar.gui.fretboard.FretBoard;
import org.herac.tuxguitar.gui.helper.FileHistory;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.items.ItemContainerManager;
import org.herac.tuxguitar.gui.keybindings.KeyBindingManager;
import org.herac.tuxguitar.gui.language.LanguageManager;
import org.herac.tuxguitar.gui.mixer.SongMixer;
import org.herac.tuxguitar.gui.plugins.PluginManager;
import org.herac.tuxguitar.gui.table.SongTableInfo;
import org.herac.tuxguitar.gui.transport.SongTransport;
import org.herac.tuxguitar.gui.util.ArgumentParser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.UnsupportedFormatException;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.song.managers.SongManager;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TuxGuitar {
	private static final String appConfigDomain = ".tuxguitar";
	private static final String appConfigDomainEnvVar = "TUXGUITAR_CONFIG_HOME";
	
	private static TuxGuitar instance;

	private Display display;

	private Shell shell;

	private SongManager songManager;

	private LanguageManager languageManager;

	private SystemConfigManager configManager;
	
	private KeyBindingManager keyBindingManager;
	
	private Composite sashComposite;
	
	private Sash sash;
	
	private TablatureEditor tablatureEditor;

	private SongTableViewer tableViewer;
	
	private SongMixer songMixer;
	
	private SongTransport songTransport;
	
	private FretBoardEditor fretBoardEditor;
	
	private ActionContainer actionContainer;

	private ItemContainerManager itemContainerManager;

	private FileHistory fileHistory;

	private PluginManager pluginManager;
	
	public static void main(String[] args) {
		TuxGuitar.instance().displayGUI(args);
	}

	public TuxGuitar() {					
	}

	public static TuxGuitar instance() {
		if (instance == null) {
			synchronized (TuxGuitar.class) {
				instance = new TuxGuitar();
			}
		}

		return instance;
	}
	
	private void initLanguage() {
		this.languageManager = new LanguageManager();
		this.languageManager.setLanguage(getConfig().getStringConfigValue(PropertyNames.LANGUAGE));
	}

	public void displayGUI(String[] args) {
		
		//checkeo los argumentos
		ArgumentParser argumentParser = new ArgumentParser(args);
		if(argumentParser.printAndExit()){
			return;
		}		
	    this.initConfigManager();
		this.initLanguage();
		this.display = new Display();

		Shell splashShell = getSplashShell(display);
		splashShell.open();

		this.shell = new Shell(display);		
		this.shell.setLayout(new FormLayout());
		
		this.shell.setText(getProperty("tuxguitar.title"));
		this.shell.setImage(SystemImages.TUXGUITAR_ICON);
				
		this.songManager = new SongManager();
		this.pluginManager = new PluginManager();
		if(argumentParser.getFile() != null){
			try {
				this.songManager.open(argumentParser.getFile().getPath());
			} catch (GPFormatException e) {
				e.printStackTrace();
				this.songManager.newSong();
			} catch (IOException e) {
				e.printStackTrace();
				this.songManager.newSong();
			} catch (UnsupportedFormatException e) {
				e.printStackTrace();
				this.songManager.newSong();
			}
		}
		this.checkSoundbank();
		this.fileHistory = new FileHistory();
		this.tablatureEditor = new TablatureEditor(this.songManager);
		this.tableViewer = new SongTableViewer(this.tablatureEditor);
		this.fretBoardEditor = new FretBoardEditor(this.tablatureEditor);
		this.songMixer = new SongMixer();
		this.songTransport = new SongTransport();
		
		
		this.initActions();
		this.adjustKeyBindings();
		this.initItems();		
		this.createComposites(shell);

		boolean maximized = getConfig().getBooleanConfigValue(PropertyNames.MAXIMIZED);
		this.shell.setMaximized(maximized);
		if(!maximized){
			int width = getConfig().getIntConfigValue(PropertyNames.WIDTH); 
			int height = getConfig().getIntConfigValue(PropertyNames.HEIGHT);
			if(width > 0 && height > 0){
				this.shell.setSize(width,height);
			}
		}
		this.tablatureEditor.getTablature().setFocus();
		this.shell.setMinimumSize(640,480);
				
		splashShell.close();
		splashShell.dispose();
		
		this.shell.open();
		this.setDefaults();
		this.updateItems();		
		
		this.pluginManager.initPLugins();
		
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
				
		songManager.getPlayer().close();
		this.pluginManager.closePLugins();
		dispose();
		if(!getDisplay().isDisposed()){
		    display.dispose();
		}
		System.exit(0);
	}

	private Shell getSplashShell(Display display) {
		Shell shell = new Shell(display, SWT.NO_TRIM | SWT.NO_BACKGROUND);
		final Image image = SystemImages.TUXGUITAR_SPLASH;
		int width = image.getBounds().width;
		int height = image.getBounds().height;
		int x = ((display.getBounds().width - display.getBounds().x) / 2) - (width / 2);
		int y = ((display.getBounds().height - display.getBounds().y) / 2) - (height / 2);
		shell.setBounds(x, y, width, height);
		shell.setImage(SystemImages.TUXGUITAR_ICON);
		shell.setText(getProperty("tuxguitar.title"));
		shell.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				e.gc.drawImage(image, 0, 0);
			}
		});
		return shell;
	}


	public void createComposites(Composite composite) {
		this.sashComposite = new Composite(composite,SWT.NONE);
		this.sashComposite.setLayout(new FormLayout());
		FormData data = new FormData();
		data.left = new FormAttachment(0, 0); 
		data.right = new FormAttachment(100, 0); 
		data.top = new FormAttachment(this.itemContainerManager.getCoolbar(),5);
		data.bottom = new FormAttachment(100,0);
		sashComposite.setLayoutData(data);
				
		this.sash = new Sash(sashComposite, SWT.HORIZONTAL | SWT.SEPARATOR);
	    data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(75,0);		
		sash.setLayoutData(data);
	    
	    this.tablatureEditor.showTablature(sashComposite); 
	    data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0,0);
		data.bottom = new FormAttachment(sash, 0);
		this.tablatureEditor.getTablature().setLayoutData(data);	    
	    
	    
	    this.tableViewer.showMixer(sashComposite);
	    data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(sash,10);
		data.bottom = new FormAttachment(100,00);
		this.tableViewer.getTableInfo().setLayoutData(data);		  
	    
	    
	    sash.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent event) {
	            
	            int height = sashComposite.getBounds().height;
	            int sashNumerator = (event.y * 100 / height);
	            ((FormData) sash.getLayoutData()).top = new FormAttachment(sashNumerator,0);
	        }
	      });
	    sash.addMouseListener(new MouseAdapter() {
            public void mouseUp(MouseEvent e) {
                sash.getParent().layout();
            }
        });
	    
	    this.fretBoardEditor.showFretBoard(composite);
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(sashComposite,0);
		data.bottom = new FormAttachment(100,0);
		this.fretBoardEditor.getFretBoard().setLayoutData(data);
	}
	
	public void checkSoundbank(){
		boolean customSoundbank = getConfig().getBooleanConfigValue(PropertyNames.SOUNDBANK_CUSTOM);
		if(customSoundbank){
			if(!getSongManager().getPlayer().loadSoundbank(new File(getConfig().getStringConfigValue(PropertyNames.SOUNDBANK_CUSTOM_PATH)))){
	    		String title = TuxGuitar.getProperty("soundbank.error");    	
	    		String message = TuxGuitar.getProperty("soundbank.error.custom");
	    		new MessageDialog(title,message,SWT.ICON_ERROR | SWT.OK).show(shell);
			}
		}
	}
	
	public void setDefaults(){	    
	    showFretBoard(getConfig().getBooleanConfigValue(PropertyNames.SHOW_FRETBOARD));		
		if(getConfig().getBooleanConfigValue(PropertyNames.SHOW_MIXER)){
			new SyncThread(new Runnable() {			
				public void run() {
					getMixer().show();
				}			
			}).start();
			
		}	    	
		if(getConfig().getBooleanConfigValue(PropertyNames.SHOW_TRANSPORT)){
			new SyncThread(new Runnable() {			
				public void run() {
					getTransport().show();
				}			
			}).start();						
		}	  		
	}
	
	public void showFretBoard(boolean show){
	    if(show){
	        showFretBoard();
	    }else{
	        hideFretBoard();
	    }
	}
	
	public void showFretBoard(){
		this.fretBoardEditor.getFretBoard().setVisible(true);
		this.updateSashNumerator();
		this.fretBoardEditor.getFretBoard().getParent().layout();	
	}
	
	public void hideFretBoard(){
		this.fretBoardEditor.getFretBoard().setVisible(false);
		((FormData)this.sashComposite.getLayoutData()).bottom.numerator = 100;
		shell.setMinimumSize(640,480);
		
		this.fretBoardEditor.getFretBoard().setVisible(false);
		this.updateSashNumerator();
		this.fretBoardEditor.getFretBoard().getParent().layout();
	}
	
	public void updateSashNumerator(){
	    FormData data = ((FormData)this.sashComposite.getLayoutData());	    
	    if(this.fretBoardEditor.getFretBoard().isVisible()){	    
	        int sashNumerator = 100 - (this.fretBoardEditor.getFretBoard().getHeight() * 100 / (this.shell.getBounds().height));
	    	
	        if(sashNumerator < 0){
	            sashNumerator = 0;
	        }
	        data.bottom.numerator = sashNumerator;
	        shell.setMinimumSize(730,520);
	    }else{
			((FormData)this.sashComposite.getLayoutData()).bottom.numerator = 100;
			shell.setMinimumSize(640,480);
	    }
	}

	public TablatureEditor getTablatureEditor(){
	    return this.tablatureEditor;
	}
	
	public FretBoardEditor getFretBoardEditor(){
		return this.fretBoardEditor;
	}		
	
	private void initItems() {
		this.itemContainerManager = new ItemContainerManager(this.tablatureEditor);
		this.itemContainerManager.createMenu(this.shell);
		this.itemContainerManager.createPopupMenu(this.shell);
		this.itemContainerManager.createToolbar(this.shell);
	}

	private void initActions() {
		this.actionContainer = new ActionContainer(this.tablatureEditor);
		this.actionContainer.initActions();
	}
	
	private void initConfigManager(){
		this.configManager = new SystemConfigManager();	
		this.configManager.init();
	}
	
	private void adjustKeyBindings() {
		this.keyBindingManager = new KeyBindingManager();
		this.keyBindingManager.init();
	}
	
	public SongManager getSongManager(){
		return this.songManager;
	}
	
	public SongMixer getMixer(){
		return this.songMixer;
	}
	
	public SongTransport getTransport(){
		return this.songTransport;
	}	
	
	public SongTableViewer getTableViewer(){
		return this.tableViewer;
	}
	
	public PluginManager getPluginManager(){
		return this.pluginManager;
	}
	
	public void updateItems(){
		getItemContainerManager().updateItems();
		getTransport().updateItems();
	}		
	
	public void reloadConfig(){		
		//reload language
		String language = getConfig().getStringConfigValue(PropertyNames.LANGUAGE);
		if(language != null && language.length() > 0){
			getLanguageManager().setLanguage(language);
		}		
		//reload tablature
		getTablatureEditor().reloadConfig();		
		//reload display composites
		setDefaults();		
		//reload properties
		loadProperties();
	}
	
	public void redraw(){
	    if(!getDisplay().isDisposed()){	    	
	    	this.tablatureEditor.getTablature().redraw();	    	
	        this.fretBoardEditor.getFretBoard().redraw();
	        this.tableViewer.getTableInfo().redraw();	        
	    }
	}
	
	public void redrawPayingMode(){
	    if(!getDisplay().isDisposed()){
	        this.tablatureEditor.getTablature().redraw();
	        this.fretBoardEditor.getFretBoard().redrawPlayingMode();
	        this.tableViewer.getTableInfo().redrawPlayingMode();
	        this.songTransport.redraw();
	    }
	}
	
	public void fireUpdate(){
		this.tablatureEditor.getTablature().updateTablature();
		this.tableViewer.getTableInfo().fireUpdate();
	}
	
	public void loadProperties(){
	    this.itemContainerManager.loadProperties();         
	    this.tableViewer.getTableInfo().loadProperties();
	    this.fretBoardEditor.getFretBoard().loadProperties();
	    this.songMixer.loadProperties();
	    this.songTransport.loadProperties();
	}
	
	public Display getDisplay(){
	    return this.display;
	}
	
	public Action getAction(String name) {
		return this.actionContainer.getAction(name);
	}

	public ItemContainerManager getItemContainerManager() {
		return itemContainerManager;
	}

	public ActionContainer getActionContainer() {
		return this.actionContainer;
	}

	public LanguageManager getLanguageManager() {
		return this.languageManager;
	}

	public static String getProperty(String key) {
		return TuxGuitar.instance().languageManager.getProperty(key);
	}
   
	public SystemConfigManager getConfig(){
	    return this.configManager;
	}

	public KeyBindingManager getkeyBindingManager(){
		return this.keyBindingManager;
	}

	public FileHistory getFileHistory(){
		return this.fileHistory;
	}
	
	public static boolean isDisposed(){
	    return TuxGuitar.instance().getDisplay().isDisposed();
	}

    private void dispose(){    	
    	SystemImages.disposeImages();
    	getTablatureEditor().getTablature().dispose();
    	SongTableInfo.disposeColors();
    	FretBoard.disposeColors();
    }
    
    public void showErrorMessage(Throwable throwable){
    	throwable.printStackTrace();
    	String title = getProperty("error");
    	String message = throwable.getMessage();
    	new MessageDialog(title,message,SWT.ICON_ERROR).show(shell);
    }
}