/*
 * Decompiled with CFR 0.152.
 */
package net.sf.janel.ant;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.sf.janel.ant.Quantize;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JanelTask
extends Task {
    static byte[] icon1Header = new byte[]{0, 0, 1, 0, 1, 0, 16, 16, 16, 0, 1, 0, 4, 0, 40, 1, 0, 0, 22, 0, 0, 0};
    static byte[] icon2Header = new byte[]{0, 0, 1, 0, 1, 0, 32, 32, 16, 0, 1, 0, 4, 0, -24, 2, 0, 0, 22, 0, 0, 0};
    protected boolean console = false;
    protected File exe;
    protected File smallIcon;
    protected File bigIcon;
    protected static char[] HEX = "0123456789ABCDEF".toCharArray();
    protected static JanelVersion[] JANEL_VERSIONS = new JanelVersion[]{new JanelVersion("JanelConsole 2.5.0", "32CD08978A7EA221A21A692961FA7BFD", 173064L, 296, 172320L, 744), new JanelVersion("JanelWindows 2.5.0", "764EE7D8DA3D800F724BA6723130038D", 173064L, 296, 172320L, 744)};

    protected static byte[] renderIcon(File file, boolean bl) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = bl ? 32 : 16;
        String string = file.getName().substring(file.getName().lastIndexOf(46) + 1);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string);
        ImageReader imageReader = iterator.next();
        if (imageReader == null) {
            throw new IOException("Unsupported image format: " + file.getName());
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        imageReader.setInput(imageInputStream, false);
        imageReader.read(0);
        int n6 = imageReader.getWidth(0);
        int n7 = imageReader.getHeight(0);
        Image image = imageReader.read(0);
        if (n6 != n5 || n7 != n5) {
            image = image.getScaledInstance(n5, n5, 4);
        }
        int[][] nArray = JanelTask.getPixels(image, n5, n5);
        int[][] nArray2 = new int[n5][n5];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n5; ++j) {
                nArray2[j][i] = nArray[j][i] >> 24 & 0xFF;
            }
        }
        int[] nArray3 = Quantize.quantizeImage(nArray, 16);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(JanelTask.createRawHader(n5, n5, 4));
        for (n4 = 0; n4 < 16; ++n4) {
            n3 = n4 < nArray3.length ? nArray3[n4] : 0;
            n2 = n3 >> 16 & 0xFF;
            n = n3 >> 8 & 0xFF;
            int n8 = n3 >> 0 & 0xFF;
            byteArrayOutputStream.write(n8);
            byteArrayOutputStream.write(n);
            byteArrayOutputStream.write(n2);
            byteArrayOutputStream.write(0);
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            for (n3 = 0; n3 < n5; n3 += 2) {
                byteArrayOutputStream.write(nArray[n3 + 1][n4] + (nArray[n3][n4] << 4));
            }
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            for (n3 = 0; n3 < n5; n3 += 8) {
                n2 = 0;
                for (n = 0; n < 8; ++n) {
                    n2 <<= 1;
                    if (nArray2[n3 + n][n4] >= 128) continue;
                    n2 |= 1;
                }
                byteArrayOutputStream.write(n2);
            }
            if (bl) continue;
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    protected static byte[] createRawHader(int n, int n2, int n3) {
        byte[] byArray = new byte[40];
        int n4 = 0;
        n4 = JanelTask.put(byArray, n4, 40L);
        n4 = JanelTask.put(byArray, n4, (long)n);
        n4 = JanelTask.put(byArray, n4, (long)n2 * 2L);
        n4 = JanelTask.put(byArray, n4, 1);
        n4 = JanelTask.put(byArray, n4, n3);
        n4 = JanelTask.put(byArray, n4, 0L);
        n4 = JanelTask.put(byArray, n4, 192L);
        n4 = JanelTask.put(byArray, n4, 0L);
        n4 = JanelTask.put(byArray, n4, 0L);
        n4 = JanelTask.put(byArray, n4, 0L);
        n4 = JanelTask.put(byArray, n4, 0L);
        return byArray;
    }

    protected static int put(byte[] byArray, int n, long l) {
        for (int i = 0; i < 4; ++i) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>= 8;
            ++n;
        }
        return n;
    }

    protected static int put(byte[] byArray, int n, int n2) {
        for (int i = 0; i < 2; ++i) {
            byArray[n] = (byte)(n2 & 0xFF);
            n2 >>= 8;
            ++n;
        }
        return n;
    }

    protected static int put(byte[] byArray, int n, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[n] = byArray2[i];
            ++n;
        }
        return n;
    }

    protected static int[][] getPixels(Image image, int n, int n2) throws IOException {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            if (!pixelGrabber.grabPixels()) {
                throw new IOException("Grabber returned false: " + pixelGrabber.status());
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        int[][] nArray2 = new int[n][n2];
        int n3 = n;
        while (n3-- > 0) {
            int n4 = n2;
            while (n4-- > 0) {
                nArray2[n3][n4] = nArray[n4 * n + n3];
            }
        }
        return nArray2;
    }

    public void setExeType(String string) {
        if (string.equalsIgnoreCase("console")) {
            this.console = true;
        } else if (string.equalsIgnoreCase("windows")) {
            this.console = false;
        } else {
            throw new IllegalArgumentException("Invalid exeType: " + string + " (expected: 'console' or 'windows')");
        }
    }

    public void setExe(File file) {
        this.exe = file;
    }

    public void setSmallIcon(File file) {
        this.smallIcon = file;
    }

    public void setBigIcon(File file) {
        this.bigIcon = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block34: {
            this.log("creating " + this.exe + " (" + (this.console ? "console" : "windows") + ")");
            try {
                Object object;
                String string = this.console ? "JanelConsole.exe" : "JanelWindows.exe";
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
                if (inputStream == null) {
                    throw new BuildException("Resource not found: " + string);
                }
                FileOutputStream fileOutputStream = null;
                try {
                    int n;
                    fileOutputStream = new FileOutputStream(this.exe);
                    object = new byte[65535];
                    while ((n = inputStream.read((byte[])object)) > -1) {
                        fileOutputStream.write((byte[])object, 0, n);
                    }
                }
                catch (IOException iOException) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.exe.delete();
                    throw iOException;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (this.smallIcon == null && this.bigIcon == null) break block34;
                this.log("replacing janel icons");
                object = new RandomAccessFile(this.exe, "rw");
                try {
                    byte[] byArray;
                    Object object2;
                    byte[] byArray2 = JanelTask.getMD5((RandomAccessFile)object);
                    JanelVersion janelVersion = null;
                    for (int i = 0; i < JANEL_VERSIONS.length; ++i) {
                        object2 = JANEL_VERSIONS[i];
                        if (!Arrays.equals(((JanelVersion)object2).md5, byArray2)) continue;
                        janelVersion = object2;
                        break;
                    }
                    if (janelVersion == null) {
                        throw new BuildException("Invalid MD5 of Janel-EXE. Unable to change icons. (MD5 was " + JanelTask.toHex(byArray2) + ").");
                    }
                    if (this.smallIcon != null) {
                        byte[] byArray3;
                        if (this.smallIcon.getName().endsWith(".ico")) {
                            this.log("* checking small (16x16) icon");
                            object2 = new RandomAccessFile(this.smallIcon, "r");
                            if (((RandomAccessFile)object2).length() != (long)(janelVersion.icon1Size + 22)) {
                                throw new BuildException("Invalid icon size. Expected: " + (janelVersion.icon1Size + 22) + " bytes");
                            }
                            byArray = new byte[22];
                            ((RandomAccessFile)object2).read(byArray);
                            if (!Arrays.equals(byArray, icon1Header)) {
                                throw new IOException("Invalid icon format.");
                            }
                            byArray3 = new byte[janelVersion.icon1Size];
                            ((RandomAccessFile)object2).read(byArray3);
                            ((RandomAccessFile)object2).close();
                        } else {
                            this.log("* trying to create an icon from the image");
                            byArray3 = JanelTask.renderIcon(this.smallIcon, false);
                            if (byArray3.length != janelVersion.icon1Size) {
                                throw new IOException("BUG: converted image has wrong size.");
                            }
                        }
                        this.log("* replacing small (16x16) icon");
                        ((RandomAccessFile)object).seek(janelVersion.icon1Offset);
                        ((RandomAccessFile)object).write(byArray3);
                    }
                    if (this.bigIcon != null) {
                        byte[] byArray4;
                        if (this.bigIcon.getName().endsWith(".ico")) {
                            this.log("* checking big (32x32) icon");
                            object2 = new RandomAccessFile(this.bigIcon, "r");
                            if (((RandomAccessFile)object2).length() != (long)(janelVersion.icon2Size + 22)) {
                                throw new BuildException("Invalid icon size. Expected: " + (janelVersion.icon2Size + 22) + " bytes");
                            }
                            byArray = new byte[22];
                            ((RandomAccessFile)object2).read(byArray);
                            if (!Arrays.equals(byArray, icon2Header)) {
                                throw new IOException("Invalid icon format.");
                            }
                            byArray4 = new byte[janelVersion.icon2Size];
                            ((RandomAccessFile)object2).read(byArray4);
                            ((RandomAccessFile)object2).close();
                        } else {
                            this.log("* trying to create an icon from the image");
                            byArray4 = JanelTask.renderIcon(this.bigIcon, true);
                            if (byArray4.length != janelVersion.icon2Size) {
                                throw new IOException("BUG: converted image has wrong size.");
                            }
                        }
                        this.log("* replacing big (32x32) icon");
                        ((RandomAccessFile)object).seek(janelVersion.icon2Offset);
                        ((RandomAccessFile)object).write(byArray4);
                    }
                }
                finally {
                    ((RandomAccessFile)object).close();
                }
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
    }

    protected static byte[] getMD5(RandomAccessFile randomAccessFile) throws BuildException {
        try {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            randomAccessFile.seek(0L);
            byte[] byArray = new byte[4096];
            while ((n = randomAccessFile.read(byArray)) > -1) {
                messageDigest.update(byArray, 0, n);
            }
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new BuildException("unable to calculate executable md5", (Throwable)exception);
        }
    }

    protected static String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(HEX[byArray[i] >> 4 & 0xF]);
            stringBuilder.append(HEX[byArray[i] & 0xF]);
        }
        return stringBuilder.toString();
    }

    protected static class JanelVersion {
        protected String version;
        protected byte[] md5;
        protected long icon1Offset;
        protected int icon1Size;
        protected long icon2Offset;
        protected int icon2Size;

        public JanelVersion(String string, String string2, long l, int n, long l2, int n2) {
            this.version = string;
            this.md5 = new byte[string2.length() / 2];
            for (int i = 0; i < this.md5.length; ++i) {
                int n3 = i * 2;
                this.md5[i] = (byte)Integer.parseInt(string2.substring(n3, n3 + 2), 16);
            }
            this.icon1Offset = l;
            this.icon1Size = n;
            this.icon2Offset = l2;
            this.icon2Size = n2;
        }
    }
}

