/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.tg_player;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.tg_player.BeatIterator;
import org.herac.tuxguitar.play.models.tg_player.ChannelControl;
import org.herac.tuxguitar.play.models.tg_player.NotePlayer;
import org.herac.tuxguitar.play.models.tg_player.ReceiverImpl;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

public final class SongPlayer
implements Player {
    private SongManager manager;
    private Receiver receiver;
    private ChannelControl channelControl;
    private NotePlayer notePlayer;
    private BeatIterator beatIterator;
    private boolean running;
    private boolean paused;

    public SongPlayer(SongManager songManager) {
        this.manager = songManager;
    }

    public void loadTestReceiver() {
        this.receiver = new ReceiverImpl();
    }

    public void loadDefaultReceiver() {
        try {
            this.receiver = MidiSystem.getReceiver();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void loadImplReceiver() {
        this.receiver = new ReceiverImpl();
    }

    private synchronized void playNotes(NotePlayer notePlayer) {
        notePlayer.checkNotes();
        SongPlayer.sleep(10L);
    }

    public static void sleep(long l) {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() < l2 + l) {
            try {
                Thread.sleep(l / 3L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static long getTime(int n, long l) {
        long l2 = 1000L * l / 1000L;
        return (long)(60.0 / (double)n * (double)l2);
    }

    public void init() {
        this.loadDefaultReceiver();
        this.channelControl = new ChannelControl(this.receiver);
        this.notePlayer = new NotePlayer(this.receiver);
        this.beatIterator = new BeatIterator(this.notePlayer);
    }

    public void close() {
        if (this.receiver != null) {
            this.receiver.close();
        }
    }

    public void play() {
        new Thread(new Runnable(){

            public void run() {
                SongPlayer.this.play(SongPlayer.this.manager.getSong());
            }
        }).start();
    }

    private void play(Song song) {
        this.setRunning(true);
        this.channelControl.update(song);
        this.beatIterator.nextBeat(song);
        long l = this.beatIterator.getNextTickPosition();
        long l2 = this.beatIterator.getBeatDuration();
        long l3 = System.currentTimeMillis();
        while (l > 0L && this.isRunning()) {
            while (System.currentTimeMillis() < l3 + l2 && this.isRunning()) {
                this.playNotes(this.notePlayer);
            }
            this.beatIterator.nextBeat(song);
            l = this.beatIterator.getNextTickPosition();
            l2 = this.beatIterator.getBeatDuration();
            l3 = System.currentTimeMillis();
        }
        if (this.isRunning()) {
            while (System.currentTimeMillis() < l3 + l2) {
                this.playNotes(this.notePlayer);
            }
        }
        this.notePlayer.stopAll();
        this.setRunning(false);
    }

    public void stop() {
        this.setRunning(false);
    }

    public void pause() {
        this.stop();
        this.setPaused(true);
    }

    public void reset() {
        this.close();
        this.init();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public boolean isRealTimeSequencer() {
        return true;
    }

    public void playBeat(SongTrack songTrack, List list) {
    }

    public void updateChannels() {
    }

    public void updateChannel(SongChannel songChannel) {
    }

    public void setTickPosition(long l) {
        this.beatIterator.setTickPosition(l);
    }

    public void setTickPosition(long l, long l2) {
        this.setTickPosition(l);
    }

    public long getTickPosition() {
        return this.beatIterator.getTickPosition();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public Soundbank getSoundbank() {
        return null;
    }

    public boolean loadSoundbank(File file) {
        return false;
    }

    public boolean loadDefaultSoundbank() {
        return false;
    }

    public void write(OutputStream outputStream) {
    }

    public void setSynthesizer(Synthesizer synthesizer) {
    }
}

