/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.tg_player;

import org.herac.tuxguitar.play.models.tg_player.SongPlayer;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongTrack;

public class ChannelNote {
    private SongTrack track;
    private Measure measure;
    private Note note;
    private boolean playing;
    private long durationInMillis;
    private long startInMillis;

    public ChannelNote(SongTrack songTrack, Measure measure, Note note) {
        this.track = songTrack;
        this.measure = measure;
        this.note = note;
    }

    public void setPlaying() {
        this.playing = true;
        this.durationInMillis = SongPlayer.getTime(this.measure.getTempo().getValue(), this.note.getDuration().getTime());
        this.startInMillis = System.currentTimeMillis();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    public Note getNote() {
        return this.note;
    }

    public void setNote(Note note) {
        this.note = note;
    }

    public SongTrack getTrack() {
        return this.track;
    }

    public void setTrack(SongTrack songTrack) {
        this.track = songTrack;
    }

    public boolean shouldStop() {
        return this.isPlaying() && System.currentTimeMillis() > this.startInMillis + this.durationInMillis;
    }
}

