/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.exporter;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.swt.graphics.Point;

public class ASCIIOutputStream {
    private PrintWriter writer;
    private int x;
    private int y;

    public ASCIIOutputStream(PrintStream printStream) {
        this.writer = new PrintWriter(printStream);
    }

    public void drawNote(int n) {
        this.movePoint(this.x + (n >= 10 ? 2 : 1), this.y);
        this.writer.print(n);
    }

    public void drawStringSegments(int n) {
        this.movePoint(this.x + n, this.y);
        for (int i = 0; i < n; ++i) {
            this.writer.print("-");
        }
    }

    public void drawTuneSegment(String string, int n) {
        for (int i = string.length(); i < n; ++i) {
            this.drawSpace();
        }
        this.movePoint(this.x + string.length(), this.y);
        this.writer.print(string);
    }

    public void drawBarSegment() {
        this.movePoint(this.x + 1, this.y);
        this.writer.print("|");
    }

    public void nextLine() {
        this.movePoint(0, this.y + 1);
        this.writer.println("");
    }

    public void drawStringLine(String string) {
        this.movePoint(0, this.y + 1);
        this.writer.println(string);
    }

    public void drawSpace() {
        this.movePoint(this.x + 1, this.y);
        this.writer.print(" ");
    }

    private void movePoint(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Point getPosition() {
        return new Point(this.x, this.y);
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }
}

