/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableMoveTrackDown
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long trackNumber;

    private UndoableMoveTrackDown() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        SongManager songManager = TuxGuitar.instance().getSongManager();
        songManager.moveTrackDown(songManager.getTrack(this.trackNumber - 1L));
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        SongManager songManager = TuxGuitar.instance().getSongManager();
        songManager.moveTrackUp(songManager.getTrack(this.trackNumber));
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableMoveTrackDown startUndo() {
        UndoableMoveTrackDown undoableMoveTrackDown = new UndoableMoveTrackDown();
        undoableMoveTrackDown.doAction = 1;
        undoableMoveTrackDown.undoCaret = new UndoableCaretHelper();
        return undoableMoveTrackDown;
    }

    public UndoableMoveTrackDown endUndo(SongTrack songTrack) {
        this.redoCaret = new UndoableCaretHelper();
        this.trackNumber = songTrack.getNumber();
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

