/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.layout;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.layout.DefaultFontProperty;

public class TabFonts {
    private Font[] fonts;

    public TabFonts(DefaultFontProperty[] defaultFontPropertyArray) {
        this.fonts = new Font[defaultFontPropertyArray.length];
        for (int i = 0; i < defaultFontPropertyArray.length; ++i) {
            this.fonts[i] = this.loadFont(TuxGuitar.instance().getDisplay(), defaultFontPropertyArray[i]);
        }
    }

    public Font loadFont(Display display, DefaultFontProperty defaultFontProperty) {
        String string = TuxGuitar.instance().getConfig().getStringConfigValue(defaultFontProperty.getProperty() + "_NAME");
        int n = TuxGuitar.instance().getConfig().getIntConfigValue(defaultFontProperty.getProperty() + "_SIZE");
        int n2 = TuxGuitar.instance().getConfig().getIntConfigValue(defaultFontProperty.getProperty() + "_STYLE");
        if (string != null && string.length() > 0 && n > 0) {
            return new Font(display, string, n, n2);
        }
        return new Font(display, defaultFontProperty.getFontName(), defaultFontProperty.getFontSize(), defaultFontProperty.getFontStyle());
    }

    public void disposeFonts() {
        for (int i = 0; i < this.fonts.length; ++i) {
            this.fonts[i].dispose();
        }
    }

    public Font getFont(int n) {
        return this.fonts[n];
    }
}

