/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;

public class LinearViewLayout
extends ViewLayout {
    public LinearViewLayout(Tablature tablature, SongManager songManager, boolean bl, boolean bl2) {
        super(tablature, songManager, bl, bl2);
    }

    public void paintSong(GC gC, Rectangle rectangle, int n, int n2) {
        this.clearTrackPositions();
        if (this.isMultitrack()) {
            this.paintTracks(this.getTablature().getCaret().getSongCoords().getTrackCoords(), gC, rectangle, n, n2);
        } else {
            ArrayList<SongTrackCoords> arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
            this.paintTracks(arrayList, gC, rectangle, n, n2);
        }
    }

    public void paintTracks(List list, GC gC, Rectangle rectangle, int n, int n2) {
        int n3 = n2 + this.getDefaultFirstTrackSpan();
        int n4 = 0;
        for (int i = 0; i < list.size(); ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(i);
            this.setScoreSpan(DEFAULT_SCORE_SPAN);
            if (AUTO_SPACING_ENABLED && this.isScoreEnabled()) {
                int n5 = 0;
                int n6 = 50;
                for (int j = 0; j < songTrackCoords.getMeasuresCoords().size(); ++j) {
                    MeasureCoords measureCoords = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(j);
                    n5 = measureCoords.getMaxY() > n5 ? measureCoords.getMaxY() : n5;
                    n6 = measureCoords.getMinY() < n6 ? measureCoords.getMinY() : n6;
                }
                if (n6 < -30) {
                    n3 += Math.abs(n6) - 30;
                }
                if (n5 + MIN_SCORE_TAB_SPAN > this.getScoreSpan()) {
                    this.setScoreSpan(this.getScoreSpan() + (n5 + MIN_SCORE_TAB_SPAN - this.getScoreSpan()));
                }
            }
            songTrackCoords.paintTrack(this, gC, n, n3, rectangle);
            this.paintStrings(songTrackCoords, gC, n3, rectangle);
            int n7 = this.isScoreEnabled() ? DEFAULT_TRACK_SPAN + this.getScoreSpan() : DEFAULT_TRACK_SPAN;
            this.addTrackPosition((int)songTrackCoords.getTrack().getNumber(), n3, n7);
            n3 += n7;
            n4 += n7;
            songTrackCoords.setHeight(n7);
            songTrackCoords.setWidth(this.getWidth());
        }
        this.setHeight(n4 + 100);
    }

    public void paintMeasures(SongTrackCoords songTrackCoords, List list, GC gC, int n, int n2, Rectangle rectangle) {
        songTrackCoords.setPosY(n2);
        int n3 = songTrackCoords.getPosX();
        int n4 = songTrackCoords.getPosY();
        int n5 = 0;
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            MeasureCoords measureCoords = (MeasureCoords)list.get(i);
            measureCoords.setPosX(n3);
            measureCoords.setPosY(n4);
            measureCoords.setScoreSpan(this.isScoreEnabled() ? this.getScoreSpan() : 0);
            boolean bl2 = n3 + n + measureCoords.getWidth() > rectangle.x - 100 && n3 + n < rectangle.x + rectangle.width + measureCoords.getWidth() + 100;
            boolean bl3 = bl = n4 + measureCoords.getTabHeight() + measureCoords.getScoreSpan() > rectangle.y && n4 < rectangle.y + rectangle.height + 80;
            if (bl2 && bl) {
                this.paintMeasure(measureCoords, gC, n3 + n, n4, 0, rectangle);
            } else {
                measureCoords.setOutOfBounds(true);
            }
            n5 = n3 += measureCoords.getWidth();
        }
        this.setWidth(n5);
    }

    public void paintStrings(SongTrackCoords songTrackCoords, GC gC, int n, Rectangle rectangle) {
        int n2 = 20 - this.getTablature().getHorizontalBar().getSelection();
        int n3 = n2 = n2 < 0 ? 0 : n2;
        if (this.isScoreEnabled()) {
            for (int i = 1; i <= 5; ++i) {
                int n4 = n + i * this.getScoreLineSpan();
                gC.drawLine(n2, n4, n2 + rectangle.width, n4);
            }
            n += this.getScoreSpan();
        }
        for (InstrumentString instrumentString : songTrackCoords.getTrack().getStrings()) {
            int n5 = instrumentString.getNumber() * this.getStringSpan();
            gC.drawLine(n2, n + n5, n2 + rectangle.width, n + n5);
        }
    }

    public void followMeasure(MeasureCoords measureCoords, boolean bl) {
        this.getTablature().moveScrollHorizontalTo(measureCoords, 50, this.getTablature().getClientArea().width - 100, bl);
    }

    public SongTrackCoords getTrackAt(List arrayList, int n, int n2) {
        if (!this.isMultitrack()) {
            arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
        }
        SongTrackCoords songTrackCoords = null;
        int n3 = this.getDefaultFirstTrackSpan() + n2;
        for (int i = 0; i < arrayList.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)arrayList.get(i);
            int n4 = songTrackCoords2.getWidth();
            int n5 = songTrackCoords2.getHeight();
            if (n >= n3 && n <= n3 + n5) {
                songTrackCoords = songTrackCoords2;
            }
            if (this.isScoreEnabled()) {
                n3 += this.getScoreSpan();
            }
            n3 += DEFAULT_TRACK_SPAN;
        }
        return songTrackCoords;
    }
}

