/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.tab.DurationCoords;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.ScoreBeatHelper;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

public class NoteCoords
implements MeasureComponent {
    private static final int NATURAL = 0;
    private static final int SHARP = 1;
    private static final int FLAT = 2;
    private static final int[] SCORE_SHARP_NOTES = new int[]{0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6};
    private static final int[] SCORE_FLAT_NOTES = new int[]{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6};
    private static final int[][] KEY_SIGNATURES = new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 2}, {0, 0, 2, 0, 0, 0, 2}, {0, 0, 2, 0, 0, 2, 2}, {0, 2, 2, 0, 0, 2, 2}, {0, 2, 2, 0, 2, 2, 2}, {2, 2, 2, 0, 2, 2, 2}, {2, 2, 2, 2, 2, 2, 2}};
    private static final boolean[] NO_NATURAL_NOTES = new boolean[]{false, true, false, true, false, false, true, false, true, false, true, false};
    private static final int JOINED_TYPE_NONE_LEFT = 1;
    private static final int JOINED_TYPE_NONE_RIGHT = 2;
    private static final int JOINED_TYPE_LEFT = 3;
    private static final int JOINED_TYPE_RIGHT = 4;
    private boolean joinedGreaterThanQuarter;
    private Tablature tablature;
    private MeasureCoords meassureCoords;
    private Note note;
    private int realValue;
    private int posX;
    private int posY;
    private int lastFromX;
    private int lastFromY;
    private DurationCoords durationCoords;
    private int joinedType;
    private SongTrackCoords trackCoords;
    private ScoreBeatHelper scoreBeatHelper;
    private Image bendImage;
    private int pointX;
    private int pointY;
    private int scorePosY;

    public NoteCoords(Tablature tablature, SongTrackCoords songTrackCoords, MeasureCoords measureCoords, Note note, int n, int n2) {
        this.tablature = tablature;
        this.trackCoords = songTrackCoords;
        this.meassureCoords = measureCoords;
        this.note = note;
        this.posX = n;
        this.posY = n2;
        this.durationCoords = new DurationCoords();
        this.calculateRealValue();
    }

    public void update(ViewLayout viewLayout) {
        this.joinedType = 2;
        this.joinedGreaterThanQuarter = false;
        this.durationCoords.setNote1(this);
        this.durationCoords.setNote2(this);
        this.durationCoords.setEighthY(this.meassureCoords.getTabHeight() + 25);
        this.durationCoords.setSixteenthY(this.meassureCoords.getTabHeight() + 20);
        this.durationCoords.setThirtySecondY(this.meassureCoords.getTabHeight() + 15);
        this.durationCoords.setSixtyFourthY(this.meassureCoords.getTabHeight() + 10);
        boolean bl = false;
        boolean bl2 = false;
        MeasureComponent measureComponent = this.meassureCoords.getPreviousComponent(this);
        MeasureComponent measureComponent2 = this.meassureCoords.getNextComponent(this);
        NoteCoords noteCoords = null;
        NoteCoords noteCoords2 = null;
        if (measureComponent instanceof NoteCoords && this.meassureCoords.areInSameBeat(this, noteCoords = (NoteCoords)measureComponent)) {
            bl2 = true;
            if (noteCoords.getNote().getDuration().getValue() >= this.note.getDuration().getValue()) {
                this.durationCoords.setNote1(noteCoords);
                if (noteCoords2 == null || noteCoords2.getNote().getDuration().getValue() < this.note.getDuration().getValue()) {
                    this.durationCoords.setNote2(this);
                }
                bl = true;
                this.joinedType = 3;
            }
            if (noteCoords.getNote().getDuration().getValue() > 4) {
                this.joinedGreaterThanQuarter = true;
            }
        }
        if (measureComponent2 instanceof NoteCoords && this.meassureCoords.areInSameBeat(this, noteCoords2 = (NoteCoords)measureComponent2)) {
            if (noteCoords2.getNote().getDuration().getValue() >= this.note.getDuration().getValue()) {
                this.durationCoords.setNote2(noteCoords2);
                if (noteCoords == null || noteCoords.getNote().getDuration().getValue() < this.note.getDuration().getValue()) {
                    this.durationCoords.setNote1(this);
                }
                bl = true;
                this.joinedType = 4;
            }
            if (noteCoords2.getNote().getDuration().getValue() > 4) {
                this.joinedGreaterThanQuarter = true;
            }
        }
        if (!bl && bl2) {
            this.joinedType = 1;
        }
        this.scorePosY = this.scoreBeatHelper.getY1(viewLayout, this, this.meassureCoords.getMeasure().getKeySignature(), this.meassureCoords.getMeasure().getClef());
        this.updateUsedStrings();
        this.updateEffects();
    }

    private void updateUsedStrings() {
        if (this.note.getDuration().getValue() >= 4) {
            boolean[] blArray = new boolean[this.trackCoords.getTrack().getStrings().size()];
            List list = this.meassureCoords.getComponents(this.getStart());
            for (MeasureComponent measureComponent : list) {
                if (!(measureComponent instanceof NoteCoords)) continue;
                NoteCoords noteCoords = (NoteCoords)measureComponent;
                blArray[noteCoords.getNote().getString() - 1] = true;
            }
            this.durationCoords.setUsedStrings(blArray);
        }
    }

    private void updateEffects() {
        if (this.getNote().getEffect().hasEffects()) {
            this.bendImage = SystemImages.BEND_IMAGE;
        }
    }

    public void calculateRealValue() {
        this.realValue = this.getNote().getValue() + ((InstrumentString)this.trackCoords.getTrack().getStrings().get(this.getNote().getString() - 1)).getValue();
    }

    public void paint(ViewLayout viewLayout, GC gC, int n, int n2) {
        Object object;
        int n3 = n + this.getPosX() + this.getSpan();
        int n4 = n2 + this.getPosY();
        this.pointX = n3;
        if (viewLayout.isScoreEnabled()) {
            this.paintScoreDuration(viewLayout, gC, n, n2);
            n4 += viewLayout.getScoreSpan();
        }
        if (viewLayout.isPlayModeEnabled() && this.isPlaying()) {
            viewLayout.setPlayNoteColor(gC);
        } else {
            viewLayout.setTabNoteColor(gC);
        }
        if (this.getNote().isTiedNote()) {
            if (!viewLayout.isScoreEnabled()) {
                object = this.getNoteForTie();
                if (object != null && ((NoteCoords)object).isAtSameLine(n2)) {
                    int n5 = ((NoteCoords)object).getPointX();
                    int n6 = ((NoteCoords)object).getLastFromY() + ((NoteCoords)object).getPosY() + 10;
                    gC.drawArc(n5, n6, n3 - n5, -30, 225, 90);
                } else {
                    Point point = viewLayout.getNoteOrientation(gC, n3, n4, this.note);
                    gC.drawString("L", point.x, point.y);
                }
            }
        } else {
            object = viewLayout.getNoteOrientation(gC, n3, n4, this.note);
            String string = this.note.getEffect().isDeadNote() ? "X" : Integer.toString(this.getNote().getValue());
            gC.drawString(string, ((Point)object).x, ((Point)object).y);
        }
        if (viewLayout.isPlayModeEnabled() && this.isPlaying()) {
            int n7 = this.meassureCoords.getScoreSpan() > 0 ? this.meassureCoords.getScoreSpan() + 10 : 50;
            gC.drawString(">", n + this.getPosX() + this.getSpan() - 2, n2 + this.meassureCoords.getTabHeight() + n7);
            viewLayout.setTabNoteColor(gC);
        }
        if (viewLayout.isScoreEnabled()) {
            this.paintEffects(gC, n, n2 + viewLayout.getScoreSpan());
        } else {
            this.paintDuration(viewLayout, gC, n, n2);
            this.paintEffects(gC, n, n2);
        }
        this.lastFromX = n;
        this.lastFromY = n2;
    }

    private NoteCoords getNoteForTie() {
        Object object;
        Object object2;
        int n;
        List list = this.meassureCoords.getComponentsBeforeEnd(this.meassureCoords.getMeasure().getStart());
        for (n = list.size() - 1; n >= 0; --n) {
            object2 = (MeasureComponent)list.get(n);
            if (object2.getStart() >= this.getNote().getStart() || !(object2 instanceof NoteCoords) || ((NoteCoords)(object = (NoteCoords)object2)).getNote().getString() != this.getNote().getString()) continue;
            return object;
        }
        for (n = this.meassureCoords.getMeasure().getNumber() - 1; n >= 0; --n) {
            object2 = (MeasureCoords)this.trackCoords.getMeasuresCoords().get(n);
            object = ((MeasureCoords)object2).getComponentsBeforeEnd(((MeasureCoords)object2).getMeasure().getStart());
            for (int i = object.size() - 1; i >= 0; --i) {
                NoteCoords noteCoords;
                MeasureComponent measureComponent = (MeasureComponent)object.get(i);
                if (measureComponent.getStart() >= this.getNote().getStart() || !(measureComponent instanceof NoteCoords) || (noteCoords = (NoteCoords)measureComponent).getNote().getString() != this.getNote().getString()) continue;
                return noteCoords;
            }
        }
        return null;
    }

    private void paintDuration(ViewLayout viewLayout, GC gC, int n, int n2) {
        int n3 = n + this.getPosX() + this.getSpan();
        int n4 = n2 + this.meassureCoords.getTabHeight() + 25;
        this.paintVerticalLine(viewLayout, gC, n, n2);
        if (this.note.getDuration().getValue() >= 8) {
            this.paintJoindeds(gC, n, n2);
        }
        if (this.note.getDuration().isDotted() || this.note.getDuration().isDoubleDotted()) {
            this.paintDotted(gC, n, n2, this.note.getDuration().isDoubleDotted());
        }
        if (!this.note.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
            gC.drawString(Integer.toString(this.note.getDuration().getTupleto().getEnters()), n3 - 3, n4 + 10);
        }
    }

    private void paintVerticalLine(ViewLayout viewLayout, GC gC, int n, int n2) {
        int n3 = n + this.getPosX() + this.getSpan();
        int n4 = viewLayout.getStringSpan();
        if (this.note.getDuration().getValue() >= 4) {
            int n5;
            boolean[] blArray = this.durationCoords.getUsedStrings();
            for (n5 = this.getNote().getString() - 1; n5 < blArray.length; ++n5) {
                if (blArray[n5]) continue;
                int n6 = n2 + n4 * (n5 + 1);
                int n7 = n6 + n4 / 2;
                int n8 = n6 - n4 / 2;
                n7 = n7 - n8 < n4 ? n7 + 1 : n7;
                gC.drawLine(n3, n8, n3, n7);
            }
            n5 = n2 + this.meassureCoords.getTabHeight() + n4 / 2;
            gC.drawLine(n3, n5, n3, n5 + 19);
        } else if (this.note.getDuration().getValue() == 2) {
            int n9 = n2 + this.meassureCoords.getTabHeight() + n4 / 2 + 9;
            gC.drawLine(n3, n9, n3, n9 + 10);
        }
    }

    public void paintJoindeds(GC gC, int n, int n2) {
        gC.setLineWidth(2);
        int n3 = 0;
        int n4 = 0;
        if (this.joinedType == 2) {
            n3 = this.getPosX() + this.getSpan();
            n4 = this.getPosX() + this.getSpan() + 6;
        } else if (this.joinedType == 1) {
            n3 = this.getPosX() + this.getSpan() - 5;
            n4 = this.getPosX() + this.getSpan();
        } else {
            n3 = this.durationCoords.getNote1().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote1());
            n4 = this.durationCoords.getNote2().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote2());
        }
        int n5 = this.durationCoords.getEighthY();
        int n6 = this.durationCoords.getSixteenthY();
        int n7 = this.durationCoords.getThirtySecondY();
        int n8 = this.durationCoords.getSixtyFourthY();
        switch (this.note.getDuration().getValue()) {
            case 8: {
                gC.drawLine(n + n3, n2 + n5, n + n4, n2 + n5);
                break;
            }
            case 16: {
                gC.drawLine(n + n3, n2 + n5, n + n4, n2 + n5);
                gC.drawLine(n + n3, n2 + n6, n + n4, n2 + n6);
                break;
            }
            case 32: {
                gC.drawLine(n + n3, n2 + n5, n + n4, n2 + n5);
                gC.drawLine(n + n3, n2 + n6, n + n4, n2 + n6);
                gC.drawLine(n + n3, n2 + n7, n + n4, n2 + n7);
                break;
            }
            case 64: {
                gC.drawLine(n + n3, n2 + n5, n + n4, n2 + n5);
                gC.drawLine(n + n3, n2 + n6, n + n4, n2 + n6);
                gC.drawLine(n + n3, n2 + n7, n + n4, n2 + n7);
                gC.drawLine(n + n3, n2 + n8, n + n4, n2 + n8);
            }
        }
        gC.setLineWidth(1);
    }

    private void paintDotted(GC gC, int n, int n2, boolean bl) {
        int n3 = n + this.getPosX() + this.getSpan();
        int n4 = n2;
        switch (this.joinedType) {
            case 2: {
                n3 += 4;
                break;
            }
            case 1: {
                n3 -= 5;
                break;
            }
            case 3: {
                n3 -= 5;
                break;
            }
            case 4: {
                n3 += 4;
            }
        }
        switch (this.note.getDuration().getValue()) {
            case 8: {
                n4 += this.durationCoords.getEighthY() - 5;
                break;
            }
            case 16: {
                n4 += this.durationCoords.getSixteenthY() - 5;
                break;
            }
            case 32: {
                n4 += this.durationCoords.getThirtySecondY() - 5;
                break;
            }
            case 64: {
                n4 += this.durationCoords.getSixtyFourthY() - 5;
                break;
            }
            default: {
                n4 += this.meassureCoords.getTabHeight() + 22;
                n3 = n + this.getPosX() + 4 + this.getSpan();
            }
        }
        gC.drawOval(n3, n4, 1, 1);
        if (bl) {
            gC.drawOval(n3 + 3, n4, 1, 1);
        }
    }

    private void paintEffects(GC gC, int n, int n2) {
        int n3 = n + this.getPosX() + this.getSpan();
        int n4 = n2 + this.getPosY();
        NoteEffect noteEffect = this.getNote().getEffect();
        if (noteEffect.hasEffects()) {
            if (noteEffect.isVibrato()) {
                this.paintVibrato(gC, n, n2);
            }
            if (noteEffect.isBend()) {
                gC.drawImage(this.bendImage, this.posX + n + 5 + this.getSpan(), this.posY + n2 - 12);
            } else if (noteEffect.isSlide() || noteEffect.isHammer()) {
                int n5 = n;
                MeasureComponent measureComponent = this.meassureCoords.getNextNoteComponent(this, this.getNote().getString());
                if (noteEffect.isSlide()) {
                    if (measureComponent != null) {
                        NoteCoords noteCoords = (NoteCoords)measureComponent;
                        int n6 = noteCoords.getPosX() + n5 + this.meassureCoords.getSpanForComponent(noteCoords);
                        int n7 = n4;
                        if (noteCoords.getNote().getValue() < this.getNote().getValue()) {
                            n4 -= 3;
                            n7 += 3;
                        } else if (noteCoords.getNote().getValue() > this.getNote().getValue()) {
                            n4 += 3;
                            n7 -= 3;
                        } else {
                            n4 -= 3;
                            n7 -= 3;
                        }
                        gC.drawLine(n3 + 5, n4, n6 - 2, n7);
                    } else {
                        gC.drawLine(n3 + 5, n4 - 3, n3 + 20 - 2, n4 - 3);
                    }
                } else if (noteEffect.isHammer()) {
                    if (measureComponent != null) {
                        NoteCoords noteCoords = (NoteCoords)measureComponent;
                        int n8 = noteCoords.getPosX() + n5 + this.meassureCoords.getSpanForComponent(noteCoords);
                        gC.drawArc(n3 + 5, n4 - 5, n8 - 6 - (n3 + 5), 15, 45, 90);
                    } else {
                        gC.drawArc(n3 + 5, n4 - 5, 10, 15, 45, 90);
                    }
                }
            }
        }
    }

    private void paintVibrato(GC gC, int n, int n2) {
        int n3 = this.getWidth();
        int n4 = n2 - 2;
        int n5 = n2 + 2;
        gC.setLineWidth(2);
        for (int i = this.posX + n + this.getSpan(); i < this.posX + n + n3 + this.getSpan() - 5; i += 3) {
            gC.drawLine(i, n4, i + 3, n5);
            n5 = n4;
            n4 = n4 < n2 ? n2 + 2 : n2 - 2;
        }
        gC.setLineWidth(1);
    }

    private void paintScoreDuration(ViewLayout viewLayout, GC gC, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = this.meassureCoords.getMeasure().getKeySignature();
        int n7 = this.meassureCoords.getMeasure().getClef();
        int n8 = this.getRealValue();
        int n9 = viewLayout.getScoreLineSpan();
        int n10 = n + this.getPosX() + this.getSpan();
        int n11 = n2 + this.getScorePosY();
        if (n11 < n2 + n9) {
            gC.setForeground(this.tablature.getDisplay().getSystemColor(2));
            for (n5 = n2 + n9; n5 > n11; n5 -= n9) {
                gC.drawLine(n10 - 4, n5, n10 + 12, n5);
            }
        } else if (n11 > n2 + n9 * 5) {
            gC.setForeground(this.tablature.getDisplay().getSystemColor(2));
            for (n5 = n2 + n9 * 5; n5 < n11; n5 += n9) {
                gC.drawLine(n10 - 4, n5 + n9, n10 + 12, n5 + n9);
            }
        }
        int n12 = n5 = viewLayout.isPlayModeEnabled() && this.isPlaying() ? 1 : 0;
        if (n5 != 0) {
            viewLayout.setPlayNoteColor(gC);
        } else {
            viewLayout.setScoreNoteColor(gC);
        }
        if (this.getNote().isTiedNote()) {
            NoteCoords noteCoords = this.getNoteForTie();
            if (noteCoords != null && noteCoords.isAtSameLine(n2)) {
                n4 = noteCoords.getPointX();
                n3 = noteCoords.getLastFromY() + this.getScorePosY();
                gC.drawArc(n4 + 3, n3 - 3, n10 - n4, 35, 45, 90);
            } else {
                gC.drawArc(n10 - 10, n11 - 2, 10, 30, 45, 90);
            }
        }
        boolean bl = KEY_SIGNATURES[n6][SCORE_SHARP_NOTES[n8 % 12]] == 1;
        n4 = KEY_SIGNATURES[n6][SCORE_FLAT_NOTES[n8 % 12]] == 2 ? 1 : 0;
        n3 = NO_NATURAL_NOTES[n8 % 12];
        if (n6 <= 7) {
            if (n3 != 0 && !bl) {
                gC.drawImage(SystemImages.KEY_SHARP, n10 - 7, n11 - 1);
            }
            if (bl && n3 == 0) {
                gC.drawImage(SystemImages.KEY_NATURAL, n10 - 7, n11 - 3);
            }
        } else {
            if (n3 != 0 && n4 == 0) {
                gC.drawImage(SystemImages.KEY_FLAT, n10 - 7, n11 - 2);
            }
            if (n4 != 0 && n3 == 0) {
                gC.drawImage(SystemImages.KEY_NATURAL, n10 - 7, n11 - 3);
            }
        }
        int n13 = viewLayout.getScoreLineSpan() - 2;
        gC.drawOval(n10, n11 + 1, n13, n13);
        if (this.note.getDuration().getValue() >= 4) {
            gC.setBackground(gC.getForeground());
            gC.fillOval(n10, n11 + 1, n13, n13);
            gC.setBackground(this.tablature.getDisplay().getSystemColor(1));
        }
        if (n5 != 0) {
            viewLayout.setScoreNoteColor(gC);
        }
        if (this.note.getDuration().isDotted() || this.note.getDuration().isDoubleDotted()) {
            gC.setLineWidth(3);
            gC.drawOval(n10 + 13, n11 + 4, 1, 1);
            if (this.note.getDuration().isDoubleDotted()) {
                gC.drawOval(n10 + 18, n11 + 4, 1, 1);
            }
            gC.setLineWidth(1);
        }
        if (!this.note.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
            gC.drawString(Integer.toString(this.note.getDuration().getTupleto().getEnters()), n10 + 1, n2 + viewLayout.getScoreSpan() - 12);
        }
        if (this.note.getDuration().getValue() >= 2) {
            n11 += 5;
            if (this.scoreBeatHelper.getDirection() == 1) {
                n10 += n13 + 1;
                n += n13 + 1;
            }
            int n14 = n2 + this.scoreBeatHelper.getY2(viewLayout, this.getPosX() + this.getSpan(), n6, n7);
            gC.drawLine(n10, n11, n10, n14);
            if (this.note.getDuration().getValue() >= 8) {
                this.paintScoreJoindeds(viewLayout, gC, n, n2, n6, n7);
            }
        }
    }

    public void paintScoreJoindeds(ViewLayout viewLayout, GC gC, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = this.scoreBeatHelper.getDirection() == 2 ? 1 : -1;
        if (!(this.joinedType != 1 && this.joinedType != 2 || this.joinedGreaterThanQuarter)) {
            gC.setLineWidth(2);
            int n7 = n + this.getPosX() + this.getSpan();
            int n8 = n7 + 7;
            int n9 = n2 + this.scoreBeatHelper.getY2(viewLayout, this.getPosX() + this.getSpan(), n3, n4);
            switch (this.note.getDuration().getValue()) {
                case 8: {
                    gC.drawLine(n7, n9, n8, n9 - 6 * n5);
                    break;
                }
                case 16: {
                    gC.drawLine(n7, n9, n8, n9 - 6 * n5);
                    gC.drawLine(n7, n9 - 5 * n5, n8, n9 - 5 * n5 - 6 * n5);
                    break;
                }
                case 32: {
                    gC.drawLine(n7, n9, n8, n9 - 6 * n5);
                    gC.drawLine(n7, n9 - 5 * n5, n8, n9 - 5 * n5 - 6 * n5);
                    gC.drawLine(n7, n9 - 10 * n5, n8, n9 - 10 * n5 - 6 * n5);
                    break;
                }
                case 64: {
                    gC.drawLine(n7, n9, n8, n9 - 6 * n5);
                    gC.drawLine(n7, n9 - 5 * n5, n8, n9 - 5 * n5 - 6 * n5);
                    gC.drawLine(n7, n9 - 10 * n5, n8, n9 - 10 * n5 - 6 * n5);
                    gC.drawLine(n7, n9 - 15 * n5, n8, n9 - 15 * n5 - 6 * n5);
                }
            }
            gC.drawLine(n8, (n9 += n5) - 6 * n5, n8, n9 - 6 * n5 - 16 * n5);
            gC.setLineWidth(1);
        } else {
            gC.setLineWidth(3);
            int n10 = 0;
            int n11 = 0;
            if (this.joinedType == 2) {
                n10 = this.getPosX() + this.getSpan();
                n11 = this.getPosX() + this.getSpan() + 6;
            } else if (this.joinedType == 1) {
                n10 = this.getPosX() + this.getSpan() - 5;
                n11 = this.getPosX() + this.getSpan();
            } else {
                n10 = this.durationCoords.getNote1().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote1());
                n11 = this.durationCoords.getNote2().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote2());
            }
            int n12 = n2 + this.scoreBeatHelper.getY2(viewLayout, n10, n3, n4);
            int n13 = n2 + this.scoreBeatHelper.getY2(viewLayout, n11, n3, n4);
            switch (this.note.getDuration().getValue()) {
                case 8: {
                    gC.drawLine(n + n10, n12, n + n11, n13);
                    break;
                }
                case 16: {
                    gC.drawLine(n + n10, n12, n + n11, n13);
                    gC.drawLine(n + n10, n12 - 5 * n5, n + n11, n13 - 5 * n5);
                    break;
                }
                case 32: {
                    gC.drawLine(n + n10, n12, n + n11, n13);
                    gC.drawLine(n + n10, n12 - 5 * n5, n + n11, n13 - 5 * n5);
                    gC.drawLine(n + n10, n12 - 10 * n5, n + n11, n13 - 10 * n5);
                    break;
                }
                case 64: {
                    gC.drawLine(n + n10, n12, n + n11, n13);
                    gC.drawLine(n + n10, n12 - 5 * n5, n + n11, n13 - 5 * n5);
                    gC.drawLine(n + n10, n12 - 10 * n5, n + n11, n13 - 10 * n5);
                    gC.drawLine(n + n10, n12 - 15 * n5, n + n11, n13 - 15 * n5);
                }
            }
            gC.setLineWidth(1);
        }
    }

    private boolean isPlaying() {
        long l;
        return this.meassureCoords.isPlaying() && (l = this.tablature.getSongManager().getPlayer().getTickPosition()) >= this.getNote().getStart() && l < this.getNote().getStart() + this.getNote().getDuration().getTime();
    }

    private int getWidth() {
        double d = 1.0 / (double)this.getNote().getDuration().getValue() * 4.0;
        int n = (int)((double)this.meassureCoords.getQuarterSpan() * d);
        return n;
    }

    public void setStart(long l) {
        this.note.setStart(l);
    }

    public long getStart() {
        return this.note.getStart();
    }

    public void setDuration(Duration duration) {
        this.note.setDuration(duration);
    }

    public Duration getDuration() {
        return this.note.getDuration();
    }

    public Note getNote() {
        return this.note;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getLastFromX() {
        return this.lastFromX;
    }

    public int getLastFromY() {
        return this.lastFromY;
    }

    public boolean isAtSameLine(int n) {
        return !this.meassureCoords.isOutOfBounds() && this.getLastFromY() == n;
    }

    public int getSpan() {
        return this.meassureCoords.getSpanForComponent(this);
    }

    public int getPointX() {
        return this.pointX;
    }

    public int getPointY() {
        return this.pointY;
    }

    public int getRealValue() {
        return this.realValue;
    }

    public ScoreBeatHelper getScoreBeatHelper() {
        return this.scoreBeatHelper;
    }

    public void setScoreBeatHelper(ScoreBeatHelper scoreBeatHelper) {
        this.scoreBeatHelper = scoreBeatHelper;
    }

    public Component getComponent() {
        return this.getNote();
    }

    public int getScorePosY() {
        return this.scorePosY;
    }
}

