/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import java.io.File;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;

public class FileMenuItem
implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private MenuItem fileMenuItem;
    private Menu menu;
    private Menu importMenu;
    private Menu exportMenu;
    private Menu historyMenu;
    private MenuItem newSong;
    private MenuItem open;
    private MenuItem save;
    private MenuItem saveAs;
    private MenuItem importItem;
    private MenuItem importMidi;
    private MenuItem exportItem;
    private MenuItem exportMidi;
    private MenuItem exportPDF;
    private MenuItem exportASCII;
    private MenuItem printPreview;
    private MenuItem print;
    private MenuItem historyItem;
    private MenuItem[] historyFiles;
    private MenuItem exit;

    public FileMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.fileMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.newSong = new MenuItem(this.menu, 8);
        this.newSong.setImage(SystemImages.NEW_IMAGE);
        this.newSong.addSelectionListener(TuxGuitar.instance().getAction("NEW_FILE"));
        this.open = new MenuItem(this.menu, 8);
        this.open.setImage(SystemImages.OPEN_IMAGE);
        this.open.addSelectionListener(TuxGuitar.instance().getAction("OPEN_FILE"));
        new MenuItem(this.menu, 2);
        this.save = new MenuItem(this.menu, 8);
        this.save.setImage(SystemImages.SAVE_IMAGE);
        this.save.addSelectionListener(TuxGuitar.instance().getAction("SAVE_FILE"));
        this.saveAs = new MenuItem(this.menu, 8);
        this.saveAs.addSelectionListener(TuxGuitar.instance().getAction("SAVE_AS_FILE"));
        new MenuItem(this.menu, 2);
        this.importItem = new MenuItem(this.menu, 64);
        this.importMenu = new Menu(this.menu.getShell(), 4);
        this.importMidi = new MenuItem(this.importMenu, 8);
        this.importMidi.addSelectionListener(TuxGuitar.instance().getAction("IMPORT_MIDI"));
        this.exportItem = new MenuItem(this.menu, 64);
        this.exportMenu = new Menu(this.menu.getShell(), 4);
        this.exportMidi = new MenuItem(this.exportMenu, 8);
        this.exportMidi.addSelectionListener(TuxGuitar.instance().getAction("EXPORT_MIDI"));
        this.exportPDF = new MenuItem(this.exportMenu, 8);
        this.exportPDF.addSelectionListener(TuxGuitar.instance().getAction("EXPORT_PDF"));
        this.exportASCII = new MenuItem(this.exportMenu, 8);
        this.exportASCII.addSelectionListener(TuxGuitar.instance().getAction("EXPORT_ASCII"));
        new MenuItem(this.menu, 2);
        this.printPreview = new MenuItem(this.menu, 8);
        this.printPreview.addSelectionListener(TuxGuitar.instance().getAction("PRINT_PREVIEW"));
        this.print = new MenuItem(this.menu, 8);
        this.print.addSelectionListener(TuxGuitar.instance().getAction("PRINT"));
        new MenuItem(this.menu, 2);
        this.historyItem = new MenuItem(this.menu, 64);
        this.historyMenu = new Menu(this.menu.getShell(), 4);
        this.updateHistoryFiles();
        new MenuItem(this.menu, 2);
        this.exit = new MenuItem(this.menu, 8);
        this.exit.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileMenuItem.this.tablatureEditor.getTablature().dispose();
                FileMenuItem.this.tablatureEditor.getSongManager().getPlayer().close();
                System.exit(0);
            }
        });
        this.importItem.setMenu(this.importMenu);
        this.exportItem.setMenu(this.exportMenu);
        this.historyItem.setMenu(this.historyMenu);
        this.fileMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    private void disposeHistoryFiles() {
        for (int i = 0; i < this.historyFiles.length; ++i) {
            this.historyFiles[i].dispose();
        }
    }

    private void updateHistoryFiles() {
        List list = TuxGuitar.instance().getFileHistory().getPaths();
        this.historyFiles = new MenuItem[list.size()];
        for (int i = 0; i < this.historyFiles.length; ++i) {
            String string = (String)list.get(i);
            this.historyFiles[i] = new MenuItem(this.historyMenu, 8);
            this.historyFiles[i].setText(new File(string).getName());
            this.historyFiles[i].setData(string);
            this.historyFiles[i].addSelectionListener(TuxGuitar.instance().getAction("OPEN_FILE"));
        }
        this.historyItem.setEnabled(this.historyFiles.length > 0);
    }

    public void update() {
        if (TuxGuitar.instance().getFileHistory().hasPathChanges()) {
            this.disposeHistoryFiles();
            this.updateHistoryFiles();
            TuxGuitar.instance().getFileHistory().setPathChanges(false);
        }
    }

    public void loadProperties() {
        this.fileMenuItem.setText(TuxGuitar.getProperty("file"));
        this.newSong.setText(TuxGuitar.getProperty("file.new"));
        this.open.setText(TuxGuitar.getProperty("file.open"));
        this.save.setText(TuxGuitar.getProperty("file.save"));
        this.saveAs.setText(TuxGuitar.getProperty("file.save-as"));
        this.importItem.setText(TuxGuitar.getProperty("file.import"));
        this.importMidi.setText(TuxGuitar.getProperty("file.import-midi"));
        this.exportItem.setText(TuxGuitar.getProperty("file.export"));
        this.exportMidi.setText(TuxGuitar.getProperty("file.export-midi"));
        this.exportPDF.setText(TuxGuitar.getProperty("file.export-pdf"));
        this.exportASCII.setText(TuxGuitar.getProperty("file.export-ascii"));
        this.printPreview.setText(TuxGuitar.getProperty("file.print-preview"));
        this.print.setText(TuxGuitar.getProperty("file.print"));
        this.historyItem.setText(TuxGuitar.getProperty("file.history"));
        this.exit.setText(TuxGuitar.getProperty("file.exit"));
    }
}

