/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.component.UndoableComponentGeneric;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

public class ChangeNoteAction
extends Action {
    public static final String NAME = "CHANGE_NOTE";

    public ChangeNoteAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        if (typedEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)typedEvent;
            if (this.isNumber(keyEvent.character) && keyEvent.stateMask == 0) {
                boolean bl;
                int n = Integer.parseInt(Character.toString(keyEvent.character));
                int n2 = -1;
                TypedEvent typedEvent2 = this.getLastEvent();
                if (typedEvent2 instanceof KeyEvent) {
                    KeyEvent keyEvent2 = (KeyEvent)typedEvent2;
                    if (this.isNumber(keyEvent2.character)) {
                        n2 = Integer.parseInt(Character.toString(keyEvent2.character));
                    }
                }
                if (((bl = this.getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().isPercussionTrack()) || n2 == 1 || n2 == 2) && n2 >= 0) {
                    n = Integer.parseInt(n2 + "" + n);
                }
                this.addNote(n);
                this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
                this.redraw();
                return true;
            }
        }
        return false;
    }

    private boolean isNumber(char c) {
        return c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
    }

    private void addNote(int n) {
        Caret caret = this.getEditor().getTablature().getCaret();
        Duration duration = (Duration)caret.getDuration().clone();
        InstrumentString instrumentString = new InstrumentString(caret.getSelectedString().getNumber(), caret.getSelectedString().getValue());
        Note note = new Note(n, caret.getPosition(), duration, 64, instrumentString.getNumber(), false, new NoteEffect());
        UndoableComponentGeneric undoableComponentGeneric = UndoableComponentGeneric.startUndo();
        this.getSongManager().getMeasureManager().addNote(caret.getMeasureCoords().getMeasure(), note);
        this.getEditor().getUndoManager().addEdit(undoableComponentGeneric.endUndo());
        caret.getMeasureCoords().playBeat(note.getStart());
    }
}

