/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.mouse;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.InstrumentString;

public class SelectComponentAction
extends Action {
    public static final String NAME = "SELECT_COMPONENT";

    public SelectComponentAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Object object;
        int n = -1;
        int n2 = -1;
        if (typedEvent instanceof MouseEvent) {
            object = (MouseEvent)typedEvent;
            n = ((MouseEvent)object).x;
            n2 = ((MouseEvent)object).y;
        } else {
            object = TuxGuitar.instance().getTablatureEditor().getTablature().toControl(TuxGuitar.instance().getDisplay().getCursorLocation());
            n = ((Point)object).x;
            n2 = ((Point)object).y;
        }
        if (n >= 0 && n2 >= 0) {
            MeasureCoords measureCoords;
            object = this.getTrackCoords(n2);
            if (object != null && (measureCoords = this.getMeasureCoords((SongTrackCoords)object, n, n2)) != null) {
                MeasureComponent measureComponent = this.getMeasureComponent(measureCoords, n);
                InstrumentString instrumentString = this.getMeasureString(measureCoords, n2);
                if (measureComponent != null) {
                    this.getEditor().getTablature().getCaret().moveTo((SongTrackCoords)object, measureCoords, measureComponent);
                    if (instrumentString != null) {
                        this.getEditor().getTablature().getCaret().setStringNumber(instrumentString.getNumber());
                    }
                    this.redraw();
                }
            }
            return true;
        }
        return false;
    }

    private SongTrackCoords getTrackCoords(int n) {
        return this.getEditor().getTablature().getSongCoords().getTrackAt(n, -this.getEditor().getTablature().getVerticalBar().getSelection());
    }

    private MeasureCoords getMeasureCoords(SongTrackCoords songTrackCoords, int n, int n2) {
        return songTrackCoords.getMeasureAt(n, n2, -this.getEditor().getTablature().getHorizontalBar().getSelection(), -this.getEditor().getTablature().getVerticalBar().getSelection());
    }

    private MeasureComponent getMeasureComponent(MeasureCoords measureCoords, int n) {
        return measureCoords.getComponentAt(n);
    }

    private InstrumentString getMeasureString(MeasureCoords measureCoords, int n) {
        return measureCoords.getStringAt(n);
    }
}

