/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableRemoveMeasure;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

public class RemoveMeasureAction
extends Action {
    public static final String NAME = "REMOVE_MEASURE";

    public RemoveMeasureAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        this.redraw();
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        if (measureCoords != null) {
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("edit.delete"));
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(4, false));
            composite.setLayoutData(new GridData(4, 4, true, true));
            int n = this.getSongManager().countMeasures();
            GridData gridData = new GridData();
            gridData.widthHint = 26;
            gridData.verticalAlignment = 0x1000000;
            gridData.grabExcessVerticalSpace = true;
            Label label = new Label(composite, 0);
            label.setText(TuxGuitar.getProperty("edit.from"));
            final Spinner spinner = new Spinner(composite, 2048);
            spinner.setLayoutData(gridData);
            spinner.setMinimum(1);
            spinner.setMaximum(n);
            spinner.setSelection(measureCoords.getMeasure().getNumber());
            Label label2 = new Label(composite, 0);
            label2.setText(TuxGuitar.getProperty("edit.to"));
            final Spinner spinner2 = new Spinner(composite, 2048);
            spinner2.setLayoutData(gridData);
            spinner2.setMinimum(1);
            spinner2.setMaximum(n);
            spinner2.setSelection(measureCoords.getMeasure().getNumber());
            final int n2 = songTrackCoords.getMeasuresCoords().size();
            spinner.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = spinner.getSelection();
                    int n2 = spinner2.getSelection();
                    if (n < 1) {
                        spinner.setSelection(1);
                    } else if (n > n2) {
                        spinner.setSelection(n2);
                    }
                }
            });
            spinner2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n;
                    int n22 = spinner2.getSelection();
                    if (n22 < (n = spinner.getSelection())) {
                        spinner2.setSelection(n);
                    } else if (n22 > n2) {
                        spinner2.setSelection(n2);
                    }
                }
            });
            Composite composite2 = new Composite(shell2, 0);
            composite2.setLayout(new GridLayout(2, false));
            composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
            GridData gridData2 = new GridData(4, 4, true, true);
            gridData2.minimumWidth = 80;
            gridData2.minimumHeight = 25;
            Button button = new Button(composite2, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData(gridData2);
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RemoveMeasureAction.this.removeMeasures(spinner.getSelection(), spinner2.getSelection());
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite2, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.setLayoutData(gridData2);
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n3 = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n4 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n3, n4);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }
    }

    private void removeMeasures(int n, int n2) {
        if (n > 0 && n <= n2) {
            Caret caret = this.getEditor().getTablature().getCaret();
            Measure measure = this.getSongManager().getTrackManager().getMeasure(caret.getSongTrackCoords().getTrack(), n);
            Measure measure2 = this.getSongManager().getTrackManager().getMeasure(caret.getSongTrackCoords().getTrack(), n2);
            if (measure != null && measure2 != null) {
                if (this.getSongManager().getTrackManager().isFirstMeasure(measure) && this.getSongManager().getTrackManager().isLastMeasure(caret.getSongTrackCoords().getTrack(), measure2)) {
                    TuxGuitar.instance().getSongManager().newSong();
                    this.getEditor().resetDefaults();
                    TuxGuitar.instance().getMixer().update();
                    TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();
                    this.redraw();
                    return;
                }
                long l = measure.getStart();
                long l2 = measure2.getStart();
                UndoableRemoveMeasure undoableRemoveMeasure = new UndoableRemoveMeasure(l, l2);
                this.getSongManager().removeMeasures(l, l2);
                this.updateTablature();
                int n3 = this.getEditor().getSongManager().countMeasures();
                if (caret.getMeasureCoords().getMeasure().getNumber() > n3) {
                    SongTrack songTrack = this.getSongManager().getTrack(caret.getSongTrackCoords().getTrack().getNumber());
                    Measure measure3 = this.getSongManager().getTrackManager().getMeasure(songTrack, n3);
                    caret.update(songTrack.getNumber(), measure3.getStart(), 1);
                }
                this.getEditor().getUndoManager().addEdit(undoableRemoveMeasure.endUndo());
            }
        }
    }
}

