/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.UnsupportedFormatException;
import org.herac.tuxguitar.io.gp.GPFormatException;

public class OpenFileAction
extends Action {
    public static final String NAME = "OPEN_FILE";
    private String fileName;

    public OpenFileAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.getEditor().getSongManager().getPlayer().reset();
        Shell shell = this.getEditor().getTablature().getShell();
        this.fileName = typedEvent.widget.getData() instanceof String ? (String)typedEvent.widget.getData() : FileChooser.instance().open(shell, FileChooser.OPEN_FORMAT, TuxGuitar.instance().getFileHistory().getFileName());
        if (this.fileName != null) {
            this.getEditor().getTablature().changeCursor(1);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        OpenFileAction.this.getEditor().getSongManager().open(OpenFileAction.this.fileName);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        OpenFileAction.this.showErrorMessage(OpenFileAction.this.fileName);
                        fileNotFoundException.printStackTrace();
                    }
                    catch (GPFormatException gPFormatException) {
                        OpenFileAction.this.showErrorMessage(OpenFileAction.this.fileName);
                        gPFormatException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        OpenFileAction.this.showErrorMessage(OpenFileAction.this.fileName);
                        iOException.printStackTrace();
                    }
                    catch (UnsupportedFormatException unsupportedFormatException) {
                        OpenFileAction.this.showErrorMessage(OpenFileAction.this.fileName);
                        unsupportedFormatException.printStackTrace();
                    }
                    new SyncThread(new Runnable(){

                        public void run() {
                            if (!TuxGuitar.isDisposed()) {
                                TuxGuitar.instance().getFileHistory().setFile(OpenFileAction.this.fileName);
                                TuxGuitar.instance().getTablatureEditor().resetDefaults();
                                TuxGuitar.instance().getMixer().update();
                                TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();
                                OpenFileAction.this.redraw();
                                OpenFileAction.this.getEditor().getTablature().changeCursor(0);
                            }
                        }
                    }).start();
                }
            }).start();
        }
        return true;
    }

    private void showErrorMessage(final String string) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    OpenFileAction.this.getEditor().getTablature().changeCursor(0);
                    String string3 = "Error Message";
                    String string2 = "Cannot Open file: " + string;
                    new MessageDialog(string3, string2, 33).show(OpenFileAction.this.getEditor().getTablature().getShell());
                }
            }
        }).start();
    }
}

