/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.gui.util.PDFWriter;

public class ExportPDFAction
extends Action {
    public static final String NAME = "EXPORT_PDF";

    public ExportPDFAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        String string = this.chengeFormat(TuxGuitar.instance().getFileHistory().getFileName(), this.getDefaultExtension());
        Shell shell = this.getEditor().getTablature().getShell();
        String string2 = FileChooser.instance().save(shell, FileChooser.EXPORT_PDF_FORMAT, string);
        if (string2 != null) {
            ConfirmDialog confirmDialog;
            String string3;
            File file;
            boolean bl = true;
            if (!this.isSuportedFormat(string2)) {
                string2 = string2 + this.getDefaultExtension();
            }
            if ((file = new File(string3 = string2)).exists() && !(confirmDialog = new ConfirmDialog(this.getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"))).confirm()) {
                bl = false;
            }
            if (bl) {
                this.getEditor().getTablature().changeCursor(1);
                new Thread(new Runnable(){

                    public void run() {
                        new SyncThread(new Runnable(){

                            public void run() {
                                try {
                                    ExportPDFAction.this.writeFile(new FileOutputStream(string3));
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    fileNotFoundException.printStackTrace();
                                }
                                if (!TuxGuitar.isDisposed()) {
                                    ExportPDFAction.this.getEditor().getTablature().changeCursor(0);
                                }
                            }
                        }).start();
                    }
                }).start();
            }
        }
        return true;
    }

    private String getDefaultFileName(String string) {
        String string2 = "untitled";
        String string3 = this.getDefaultExtension();
        if (string == null) {
            string = string2 + string3;
        } else if (!this.isSuportedFormat(string)) {
            string = this.chengeFormat(string, string3);
        }
        return string;
    }

    private boolean isSuportedFormat(String string) {
        return string.endsWith(this.getDefaultExtension());
    }

    private String chengeFormat(String string, String string2) {
        return this.removeExtension(string) + string2;
    }

    private String removeExtension(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    private String getDefaultExtension() {
        return ".pdf";
    }

    private void writeFile(OutputStream outputStream) {
        try {
            PDFWriter.write(outputStream, this.makePrintDocument());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.showErrorMessage(outOfMemoryError);
            return;
        }
    }

    public PrintDocument makePrintDocument() {
        Tablature tablature = new Tablature(this.getEditor().getTablature(), 0);
        tablature.setSongManager(this.getEditor().getSongManager());
        PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, this.getEditor().getSongManager(), false, false);
        tablature.initDefaults(printerViewLayout);
        tablature.updateTablature();
        tablature.getCaret().update(this.getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber());
        PrintDocument printDocument = printerViewLayout.makeDocument(new Rectangle(0, 0, 550, 800));
        tablature.dispose();
        return printDocument;
    }

    private void showErrorMessage(final Error error) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    String string = error.getClass().getName();
                    String string2 = error.getMessage();
                    new MessageDialog(string, string2, 33).show(ExportPDFAction.this.getEditor().getTablature().getShell());
                }
            }
        }).start();
    }
}

