/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserCustomCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserListViewColumnDesc;
import org.eclipse.swt.internal.carbon.DataBrowserListViewHeaderDesc;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    TreeItem[] items;
    TreeColumn[] columns;
    GC paintGC;
    int clickCount;
    int columnCount;
    int column_id;
    int idCount;
    int anchorFirst;
    int anchorLast;
    int headerHeight;
    boolean ignoreRedraw;
    boolean ignoreSelect;
    boolean wasSelected;
    boolean ignoreExpand;
    boolean wasExpanded;
    Rectangle imageBounds;
    TreeItem showItem;
    int lastHittest;
    static final int CHECK_COLUMN_ID = 1024;
    static final int COLUMN_ID = 1025;
    static final int EXTRA_WIDTH = 30;
    static final int CHECK_COLUMN_WIDTH = 25;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(TreeItem[] items, GC gc) {
        int width = 0;
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            width = Math.max(width, item.calculateWidth(0, gc));
            if (item._getExpanded()) {
                width = Math.max(width, this.calculateWidth(item.getItems(), gc));
            }
            ++i;
        }
        return width;
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        GC currentGC = this.paintGC;
        if (currentGC == null) {
            GCData data = new GCData();
            data.paintEvent = theEvent;
            data.visibleRgn = visibleRgn;
            this.paintGC = GC.carbon_new(this, data);
        }
        int result = super.callPaintEventHandler(control, damageRgn, visibleRgn, theEvent, nextHandler);
        if (currentGC == null) {
            this.paintGC.dispose();
            this.paintGC = null;
        }
        return result;
    }

    boolean checkData(TreeItem item, boolean redraw) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            this.ignoreRedraw = true;
            this.sendEvent(36, event);
            this.ignoreRedraw = false;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (redraw && !this.setScrollWidth(item)) {
                item.redraw(0);
            }
        }
        return true;
    }

    static int checkStyle(int style) {
        style |= 0x300;
        return Tree.checkBits(style &= 0xEFFFFFFF, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        if (wHint == -1) {
            TreeItem[] items = this.getItems(null);
            GC gc = new GC(this);
            int columnCount = Math.max(this.columnCount, 1);
            int j = 0;
            while (j < columnCount) {
                int columnWidth = this.columnCount != 0 ? this.columns[j].getWidth() : 0;
                int i = 0;
                while (i < items.length) {
                    columnWidth = Math.max(columnWidth, items[i].calculateWidth(j, gc));
                    ++i;
                }
                width += columnWidth + 30;
                ++j;
            }
            gc.dispose();
            if ((this.style & 0x20) != 0) {
                width += 25;
            }
        } else {
            width = wHint;
        }
        if (width <= 0) {
            width = 64;
        }
        int height = 0;
        height = hHint == -1 ? this.getItemCount() * this.getItemHeight() + this.getHeaderHeight() : hHint;
        if (height <= 0) {
            height = 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new org.eclipse.swt.graphics.Point(rect.width, rect.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric(7, outMetric);
        border += outMetric[0];
        OS.GetThemeMetric(5, outMetric);
        Rect rect = new Rect();
        OS.GetDataBrowserScrollBarInset(this.handle, rect);
        return new Rectangle(x -= rect.left + (border += outMetric[0]), y -= rect.top + border, width += rect.left + rect.right + border + border, height += rect.top + rect.bottom + border + border);
    }

    void createHandle() {
        this.column_id = 1025;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateDataBrowserControl(window, null, 1819505782, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        if (!this.drawFocusRing()) {
            OS.SetControlData(this.handle, 0, 1651663986, 1, new byte[1]);
        }
        int selectionFlags = (this.style & 4) != 0 ? 66 : 8;
        OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags);
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        this.headerHeight = height[0];
        OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)0);
        OS.SetDataBrowserHasScrollBars(this.handle, (this.style & 0x100) != 0, (this.style & 0x200) != 0);
        int position = 0;
        if ((this.style & 0x20) != 0) {
            DataBrowserListViewColumnDesc checkColumn = new DataBrowserListViewColumnDesc();
            checkColumn.headerBtnDesc_version = 0;
            checkColumn.propertyDesc_propertyID = 1024;
            checkColumn.propertyDesc_propertyType = 1667785336;
            checkColumn.propertyDesc_propertyFlags = 1;
            checkColumn.headerBtnDesc_minimumWidth = (short)25;
            checkColumn.headerBtnDesc_maximumWidth = (short)25;
            checkColumn.headerBtnDesc_initialOrder = 1;
            OS.AddDataBrowserListViewColumn(this.handle, checkColumn, position++);
        }
        DataBrowserListViewColumnDesc column = new DataBrowserListViewColumnDesc();
        column.headerBtnDesc_version = 0;
        column.propertyDesc_propertyID = this.column_id;
        column.propertyDesc_propertyType = 0x3F3F3F3F;
        column.propertyDesc_propertyFlags = 327680;
        column.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
        column.headerBtnDesc_initialOrder = 1;
        OS.AddDataBrowserListViewColumn(this.handle, column, position);
        OS.SetDataBrowserListViewDisclosureColumn(this.handle, this.column_id, false);
        OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)0);
        int size = 50;
        Rect rect = new Rect();
        rect.right = rect.bottom = (short)size;
        OS.SetControlBounds(this.handle, rect);
        int bpl = size * 4;
        int[] gWorld = new int[1];
        int data = OS.NewPtr(bpl * size);
        OS.NewGWorldFromPtr(gWorld, 32, rect, 0, 0, 0, data, bpl);
        int[] curPort = new int[1];
        int[] curGWorld = new int[1];
        OS.GetGWorld(curPort, curGWorld);
        OS.SetGWorld(gWorld[0], curGWorld[0]);
        OS.DrawControlInCurrentPort(this.handle);
        OS.SetGWorld(curPort[0], curGWorld[0]);
        OS.DisposeGWorld(gWorld[0]);
        OS.DisposePtr(data);
        rect.bottom = 0;
        rect.right = 0;
        OS.SetControlBounds(this.handle, rect);
    }

    void createItem(TreeColumn column, int index) {
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (index == 0) {
            column.style &= 0xFEFDBFFF;
            column.style |= 0x4000;
        }
        column.id = this.column_id + this.idCount++;
        int position = index + ((this.style & 0x20) != 0 ? 1 : 0);
        if (this.columnCount != 0) {
            DataBrowserListViewColumnDesc desc = new DataBrowserListViewColumnDesc();
            desc.headerBtnDesc_version = 0;
            desc.propertyDesc_propertyID = column.id;
            desc.propertyDesc_propertyType = 0x3F3F3F3F;
            desc.propertyDesc_propertyFlags = 327680;
            desc.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
            desc.headerBtnDesc_initialOrder = 1;
            desc.headerBtnDesc_btnFontStyle_just = (short)-2;
            if ((this.style & 0x1000000) != 0) {
                desc.headerBtnDesc_btnFontStyle_just = 1;
            }
            if ((this.style & 0x20000) != 0) {
                desc.headerBtnDesc_btnFontStyle_just = (short)-1;
            }
            desc.headerBtnDesc_btnFontStyle_flags = (short)(desc.headerBtnDesc_btnFontStyle_flags | 0x40);
            OS.AddDataBrowserListViewColumn(this.handle, desc, position);
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, (short)0);
            if (index == 0) {
                int[] disclosure = new int[1];
                boolean[] expandableRows = new boolean[1];
                OS.GetDataBrowserListViewDisclosureColumn(this.handle, disclosure, expandableRows);
                OS.SetDataBrowserListViewDisclosureColumn(this.handle, column.id, expandableRows[0]);
            }
        }
        if (this.columnCount == this.columns.length) {
            TreeColumn[] newColumns = new TreeColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        if (this.columnCount >= 1) {
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    Font[] cellFont;
                    Color[] cellForeground;
                    Color[] cellBackground;
                    Image[] images;
                    String[] strings = item.strings;
                    if (strings != null) {
                        String[] temp = new String[this.columnCount];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index, temp, index + 1, this.columnCount - index - 1);
                        temp[index] = "";
                        item.strings = temp;
                    }
                    if (index == 0) {
                        item.text = "";
                    }
                    if ((images = item.images) != null) {
                        Image[] temp = new Image[this.columnCount];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index, temp, index + 1, this.columnCount - index - 1);
                        item.images = temp;
                    }
                    if (index == 0) {
                        item.image = null;
                    }
                    if ((cellBackground = item.cellBackground) != null) {
                        Color[] temp = new Color[this.columnCount];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellBackground = temp;
                    }
                    if ((cellForeground = item.cellForeground) != null) {
                        Color[] temp = new Color[this.columnCount];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellForeground = temp;
                    }
                    if ((cellFont = item.cellFont) != null) {
                        Font[] temp = new Font[this.columnCount];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellFont = temp;
                    }
                }
                ++i;
            }
        }
    }

    void createItem(TreeItem item, TreeItem parentItem, int index) {
        int count = 0;
        int id = this.items.length;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] == null) {
                if (id == this.items.length) {
                    id = i;
                }
            } else if (this.items[i].parentItem == parentItem) {
                ++count;
            }
            ++i;
        }
        if (index == -1) {
            index = count;
        }
        if (index < 0 || index > count) {
            this.error(6);
        }
        item.index = index;
        if (index != count) {
            i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null && this.items[i].parentItem == parentItem && this.items[i].index >= item.index) {
                    ++this.items[i].index;
                }
                ++i;
            }
        }
        if (id == this.items.length) {
            TreeItem[] newItems = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        this.items[id] = item;
        item.id = id + 1;
        int parentID = 0;
        boolean expanded = true;
        if (parentItem != null) {
            parentID = parentItem.id;
            expanded = parentItem.getExpanded();
        }
        if (expanded) {
            if (OS.AddDataBrowserItems(this.handle, parentID, 1, new int[]{item.id}, 0) != 0) {
                this.items[id] = null;
                this.error(14);
            }
        } else if (count == 0 && parentItem != null) {
            parentItem.redraw(0);
        }
    }

    ScrollBar createScrollBar(int style) {
        return this.createStandardBar(style);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 3;
    }

    public void deselectAll() {
        this.checkWidget();
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, selectionFlags);
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, 0, null, 3);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0]);
        }
        this.ignoreSelect = false;
    }

    void destroyItem(TreeColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                if (this.columnCount <= 1) {
                    item.strings = null;
                    item.images = null;
                    item.cellBackground = null;
                    item.cellForeground = null;
                    item.cellFont = null;
                } else {
                    Object[] temp;
                    if (item.strings != null) {
                        String[] strings = item.strings;
                        if (index == 0) {
                            item.text = strings[1] != null ? strings[1] : "";
                        }
                        temp = new String[this.columnCount - 1];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index + 1, temp, index, this.columnCount - 1 - index);
                        item.strings = temp;
                    } else if (index == 0) {
                        item.text = "";
                    }
                    if (item.images != null) {
                        Image[] images = item.images;
                        if (index == 0) {
                            item.image = images[1];
                        }
                        temp = new Image[this.columnCount - 1];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index + 1, temp, index, this.columnCount - 1 - index);
                        item.images = temp;
                    } else if (index == 0) {
                        item.image = null;
                    }
                    if (item.cellBackground != null) {
                        Color[] cellBackground = item.cellBackground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellBackground = temp;
                    }
                    if (item.cellForeground != null) {
                        Color[] cellForeground = item.cellForeground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellForeground = temp;
                    }
                    if (item.cellFont != null) {
                        Font[] cellFont = item.cellFont;
                        temp = new Font[this.columnCount - 1];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellFont = temp;
                    }
                }
            }
            ++i;
        }
        if (this.columnCount == 1) {
            int str;
            this.column_id = column.id;
            this.idCount = 0;
            DataBrowserListViewHeaderDesc desc = new DataBrowserListViewHeaderDesc();
            desc.version = 0;
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, width);
            desc.minimumWidth = desc.maximumWidth = width[0];
            desc.titleString = str = OS.CFStringCreateWithCharacters(0, null, 0);
            OS.SetDataBrowserListViewHeaderDesc(this.handle, this.column_id, desc);
            OS.CFRelease(str);
        } else {
            int[] disclosure = new int[1];
            boolean[] expandableRows = new boolean[1];
            OS.GetDataBrowserListViewDisclosureColumn(this.handle, disclosure, expandableRows);
            if (disclosure[0] == column.id) {
                TreeColumn firstColumn = this.columns[1];
                firstColumn.style &= 0xFEFDBFFF;
                firstColumn.style |= 0x4000;
                firstColumn.updateHeader();
                OS.SetDataBrowserListViewDisclosureColumn(this.handle, firstColumn.id, expandableRows[0]);
            }
            if (OS.RemoveDataBrowserTableViewColumn(this.handle, column.id) != 0) {
                this.error(15);
            }
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        i = index;
        while (i < this.columnCount) {
            this.columns[i].sendEvent(10);
            ++i;
        }
    }

    void destroyItem(TreeItem item) {
        TreeItem parentItem = item.parentItem;
        if (parentItem == null || parentItem.getExpanded()) {
            int parentID = parentItem == null ? 0 : item.parentItem.id;
            this.ignoreExpand = true;
            if (OS.RemoveDataBrowserItems(this.handle, parentID, 1, new int[]{item.id}, 0) != 0) {
                this.error(15);
            }
            this.ignoreExpand = false;
        }
        this.releaseItems(item.getItems());
        this.releaseItem(item);
        boolean hasChild = false;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null && this.items[i].parentItem == parentItem && this.items[i].index >= item.index) {
                --this.items[i].index;
                hasChild = true;
            }
            ++i;
        }
        if (hasChild && parentItem != null && !parentItem.getExpanded()) {
            parentItem.redraw(0);
        }
        this.setScrollWidth();
    }

    int drawItemProc(int browser, int id, int property, int itemState, int theRect, int gdDepth, int colorDevice) {
        int index = id - 1;
        if (index < 0 || index >= this.items.length) {
            return 0;
        }
        int columnIndex = 0;
        if (this.columnCount > 0) {
            columnIndex = 0;
            while (columnIndex < this.columnCount) {
                if (this.columns[columnIndex].id == property) break;
                ++columnIndex;
            }
            if (columnIndex == this.columnCount) {
                return 0;
            }
        }
        Rect controlRect = new Rect();
        OS.GetControlBounds(this.handle, controlRect);
        TreeItem item = this.items[index];
        if ((this.style & 0x10000000) != 0 && !item.cached) {
            if (!this.checkData(item, false)) {
                return 0;
            }
            if (this.setScrollWidth(item)) {
                Rect rect = new Rect();
                if (OS.GetDataBrowserItemPartBounds(this.handle, id, property, 0, rect) == 0) {
                    int x = rect.left - controlRect.left;
                    int y = rect.top - controlRect.top;
                    int width = rect.right - rect.left;
                    int height = rect.bottom - rect.top;
                    this.redrawWidget(this.handle, x, y, width, height, false);
                }
                return 0;
            }
        }
        Rect rect = new Rect();
        OS.memcpy(rect, theRect, 8);
        int x = rect.left;
        int y = rect.top;
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        boolean selected = (itemState & 1) != 0;
        x -= controlRect.left;
        y -= controlRect.top;
        GC gc = this.paintGC;
        if (gc == null) {
            GCData data = new GCData();
            int[] port = new int[1];
            OS.GetPort(port);
            data.port = port[0];
            gc = GC.carbon_new(this, data);
        }
        int clip = OS.NewRgn();
        OS.GetClip(clip);
        OS.OffsetRgn(clip, -controlRect.left, -controlRect.top);
        gc.setClipping(Region.carbon_new(this.display, clip));
        Rect itemRect = new Rect();
        OS.GetDataBrowserItemPartBounds(this.handle, id, property, 0, itemRect);
        OS.OffsetRect(itemRect, -controlRect.left, -controlRect.top);
        if (this.columnCount != 0) {
            if (selected && ((this.style & 0x10000) != 0 || columnIndex == 0)) {
                gc.setBackground(this.display.getSystemColor(26));
            } else {
                gc.setBackground(item.getBackground(columnIndex));
            }
            if (columnIndex == 0) {
                gc.fillRectangle(x - 1, y, itemRect.right - x + 2, itemRect.bottom - y);
            } else {
                gc.fillRectangle(itemRect.left, itemRect.top, itemRect.right - itemRect.left, itemRect.bottom - itemRect.top);
            }
        }
        int rectRgn = OS.NewRgn();
        OS.RectRgn(rectRgn, rect);
        OS.OffsetRgn(rectRgn, -controlRect.left, -controlRect.top);
        OS.SectRgn(rectRgn, clip, clip);
        OS.DisposeRgn(rectRgn);
        gc.setClipping(Region.carbon_new(this.display, clip));
        OS.DisposeRgn(clip);
        Image image = item.getImage(columnIndex);
        String text = item.getText(columnIndex);
        gc.setFont(item.getFont(columnIndex));
        org.eclipse.swt.graphics.Point extent = gc.stringExtent(text);
        int itemWidth = extent.x;
        Rectangle imageBounds = null;
        if (image != null) {
            imageBounds = image.getBounds();
            itemWidth += this.imageBounds.width + 2;
        }
        if (this.columnCount != 0) {
            TreeColumn column = this.columns[columnIndex];
            if ((column.style & 0x1000000) != 0) {
                x += (width - itemWidth) / 2;
            }
            if ((column.style & 0x20000) != 0) {
                x += width - itemWidth;
            }
        }
        if (image != null) {
            gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, x, y + (height - this.imageBounds.height) / 2, this.imageBounds.width, this.imageBounds.height);
            x += this.imageBounds.width + 2;
        }
        if (selected && ((this.style & 0x10000) != 0 || columnIndex == 0)) {
            gc.setForeground(this.display.getSystemColor(27));
            if (this.columnCount == 0) {
                gc.setBackground(this.display.getSystemColor(26));
                gc.fillRectangle(x - 1, y, extent.x + 2, height);
            }
        } else {
            if (this.columnCount == 0) {
                gc.setBackground(item.getBackground());
                gc.fillRectangle(x - 1, y, extent.x + 2, height);
            }
            Color foreground = item.getForeground(columnIndex);
            gc.setForeground(foreground);
        }
        gc.drawString(text, x, y + (height - extent.y) / 2, true);
        if (gc != this.paintGC) {
            gc.dispose();
        }
        return 0;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int border = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric(7, outMetric);
        border += outMetric[0];
        OS.GetThemeMetric(5, outMetric);
        border += outMetric[0];
        Rect rect = new Rect();
        Rect inset = new Rect();
        OS.GetControlBounds(this.handle, rect);
        OS.GetDataBrowserScrollBarInset(this.handle, inset);
        int width = Math.max(0, rect.right - rect.left - inset.right - border - border);
        int height = Math.max(0, rect.bottom - rect.top - inset.bottom - border - border);
        return new Rectangle(inset.left, inset.top, width, height);
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] result = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        return height[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        return height[0] != 0;
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        int i = 0;
        TreeItem item = null;
        while (item == null && i < this.items.length) {
            TreeItem next;
            if ((next = this.items[i++]) == null || next.parentItem != null || next.index != index) continue;
            item = next;
        }
        if (item == null) {
            this.error(6);
        }
        return item;
    }

    public TreeItem getItem(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        Point pt = new Point();
        OS.SetPt(pt, (short)(point.x + rect.left), (short)(point.y + rect.top));
        int columnId = this.columnCount == 0 ? this.column_id : this.columns[0].id;
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && OS.GetDataBrowserItemPartBounds(this.handle, item.id, columnId, 0, rect) == 0 && ((this.style & 0x10000) != 0 ? rect.top <= pt.v && pt.v < rect.bottom : OS.PtInRect(pt, rect))) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.getItemCount(null);
    }

    int getItemCount(TreeItem item) {
        this.checkWidget();
        int count = 0;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null && this.items[i].parentItem == item) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getItemHeight() {
        this.checkWidget();
        short[] height = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, height) != 0) {
            this.error(11);
        }
        return height[0];
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(null);
    }

    TreeItem[] getItems(TreeItem item) {
        if (this.items == null) {
            return new TreeItem[0];
        }
        int count = 0;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null && this.items[i].parentItem == item) {
                ++count;
            }
            ++i;
        }
        TreeItem[] result = new TreeItem[count];
        int i2 = 0;
        while (i2 < this.items.length) {
            if (this.items[i2] != null && this.items[i2].parentItem == item) {
                result[this.items[i2].index] = this.items[i2];
            }
            ++i2;
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return false;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        int ptr = OS.NewHandle(0);
        if (OS.GetDataBrowserItems(this.handle, 0, true, 1, ptr) != 0) {
            this.error(9);
        }
        int count = OS.GetHandleSize(ptr) / 4;
        TreeItem[] result = new TreeItem[count];
        OS.HLock(ptr);
        int[] start = new int[1];
        OS.memcpy(start, ptr, 4);
        int[] id = new int[1];
        int i = 0;
        while (i < count) {
            OS.memcpy(id, start[0] + i * 4, 4);
            result[i] = this.items[id[0] - 1];
            ++i;
        }
        OS.HUnlock(ptr);
        OS.DisposeHandle(ptr);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] count = new int[1];
        if (OS.GetDataBrowserItemCount(this.handle, 0, true, 1, count) != 0) {
            this.error(36);
        }
        return count[0];
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        int offset = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric(7, outMetric);
        offset += outMetric[0];
        OS.GetThemeMetric(5, outMetric);
        offset += outMetric[0];
        if (this.getHeaderVisible()) {
            offset += this.getHeaderHeight();
        }
        int y = rect.top + offset;
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                int columnId;
                int n = columnId = this.columnCount == 0 ? this.column_id : this.columns[0].id;
                if (OS.GetDataBrowserItemPartBounds(this.handle, item.id, columnId, 0, rect) == 0 && rect.top <= y && y <= rect.bottom) {
                    return item;
                }
            }
            ++i;
        }
        return null;
    }

    int hitTestProc(int browser, int id, int property, int theRect, int mouseRect) {
        this.lastHittest = id;
        return 1;
    }

    void hookEvents() {
        super.hookEvents();
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        callbacks.version = 0;
        OS.InitDataBrowserCallbacks(callbacks);
        callbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        callbacks.v1_itemDataCallback = this.display.itemDataProc;
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        DataBrowserCustomCallbacks custom = new DataBrowserCustomCallbacks();
        custom.version = 0;
        OS.InitDataBrowserCustomCallbacks(custom);
        custom.v1_drawItemCallback = this.display.drawItemProc;
        custom.v1_hitTestCallback = this.display.hitTestProc;
        custom.v1_trackingCallback = this.display.trackingProc;
        OS.SetDataBrowserCustomCallbacks(this.handle, custom);
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parentItem != null) {
            return -1;
        }
        return item.index;
    }

    int itemCompareProc(int browser, int itemOne, int itemTwo, int sortProperty) {
        int index1 = itemOne - 1;
        if (index1 < 0 || index1 >= this.items.length) {
            return 0;
        }
        int index2 = itemTwo - 1;
        if (index2 < 0 || index2 >= this.items.length) {
            return 0;
        }
        return this.items[index1].index < this.items[index2].index ? 1 : 0;
    }

    int itemDataProc(int browser, int id, int property, int itemData, int setValue) {
        int index = id - 1;
        if (index < 0 || index >= this.items.length) {
            return 0;
        }
        TreeItem item = this.items[index];
        switch (property) {
            case 1024: {
                if (setValue != 0) {
                    boolean bl = item.checked = !item.checked;
                    if (item.checked && item.grayed) {
                        OS.SetDataBrowserItemDataButtonValue(itemData, (short)2);
                    } else {
                        boolean theData = item.checked;
                        OS.SetDataBrowserItemDataButtonValue(itemData, (short)(theData ? 1 : 0));
                    }
                    Event event = new Event();
                    event.item = item;
                    event.detail = 32;
                    this.postEvent(13, event);
                    if (item.checked) break;
                    item.redraw(1024);
                    break;
                }
                int theData = 0;
                if (item.checked) {
                    theData = item.grayed ? 2 : 1;
                }
                OS.SetDataBrowserItemDataButtonValue(itemData, (short)theData);
                break;
            }
            case 4: {
                int i = 0;
                while (i < this.items.length) {
                    if (this.items[i] != null && this.items[i].parentItem == item) {
                        OS.SetDataBrowserItemDataBooleanValue(itemData, true);
                    }
                    ++i;
                }
                break;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int itemNotificationProc(int browser, int id, int message) {
        TreeItem item;
        block28: {
            if (message == 13) {
                int i;
                int[] property;
                short[] width = new short[1];
                TreeColumn[] newColumns = this.getColumns();
                int i2 = 0;
                while (true) {
                    if (i2 >= this.columnCount) {
                        property = new int[1];
                        OS.GetDataBrowserSortProperty(this.handle, property);
                        if (property[0] == 0) return 0;
                        i = 0;
                        break;
                    }
                    TreeColumn column = newColumns[i2];
                    if (!column.isDisposed()) {
                        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, width);
                        if (width[0] != column.lastWidth) {
                            column.resized(width[0]);
                            return 0;
                        }
                    }
                    ++i2;
                }
                while (i < this.columnCount) {
                    TreeColumn column = this.columns[i];
                    if (property[0] == column.id) {
                        column.postEvent(this.clickCount == 2 ? 14 : 13);
                        break;
                    }
                    ++i;
                }
                OS.SetDataBrowserSortProperty(this.handle, 0);
                return 0;
            }
            int index = id - 1;
            if (index < 0) return 0;
            if (index >= this.items.length) {
                return 0;
            }
            item = this.items[index];
            switch (message) {
                case 5: 
                case 6: {
                    int modifiers;
                    this.wasSelected = true;
                    if (this.ignoreSelect) {
                        return 0;
                    }
                    int[] first = new int[1];
                    int[] last = new int[1];
                    OS.GetDataBrowserSelectionAnchor(this.handle, first, last);
                    boolean selected = false;
                    selected = (this.style & 2) != 0 ? (((modifiers = OS.GetCurrentEventKeyModifiers()) & 0x200) != 0 ? (message == 5 ? first[0] == id || last[0] == id : id == this.anchorFirst || id == this.anchorLast) : ((modifiers & 0x100) != 0 ? true : first[0] == last[0])) : message == 5;
                    if (!selected) return 0;
                    this.anchorFirst = first[0];
                    this.anchorLast = last[0];
                    Event event = new Event();
                    event.item = item;
                    this.postEvent(13, event);
                    return 0;
                }
                case 7: {
                    this.wasSelected = true;
                    Event event = new Event();
                    event.item = item;
                    this.postEvent(14, event);
                    return 0;
                }
                case 9: {
                    int count;
                    int ptr = OS.NewHandle(0);
                    if (OS.GetDataBrowserItems(this.handle, item.id, true, 1, ptr) == 0 && (count = OS.GetHandleSize(ptr) / 4) > 0) {
                        int[] ids = new int[count];
                        OS.HLock(ptr);
                        int[] start = new int[1];
                        OS.memcpy(start, ptr, 4);
                        OS.memcpy(ids, start[0], count * 4);
                        OS.HUnlock(ptr);
                        this.ignoreSelect = true;
                        int[] selectionFlags = null;
                        if ((this.style & 4) != 0) {
                            selectionFlags = new int[1];
                            OS.GetDataBrowserSelectionFlags(this.handle, selectionFlags);
                            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0] & 0xFFFFFFBF);
                        }
                        OS.SetDataBrowserSelectedItems(this.handle, ids.length, ids, 3);
                        if ((this.style & 4) != 0) {
                            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0]);
                        }
                        this.ignoreSelect = false;
                        Event event = new Event();
                        event.item = item;
                        this.sendEvent(13, event);
                    }
                    OS.DisposeHandle(ptr);
                    return 0;
                }
                case 10: {
                    this.wasExpanded = true;
                    if (!this.ignoreExpand) {
                        Event event = new Event();
                        event.item = item;
                        this.sendEvent(18, event);
                    }
                    this.setScrollWidth();
                    return 0;
                }
                case 8: {
                    this.wasExpanded = true;
                    if (!this.ignoreExpand) {
                        Event event = new Event();
                        event.item = item;
                        try {
                            item.state |= 0x100;
                            this.sendEvent(17, event);
                            break;
                        }
                        catch (Throwable ids) {
                            Object count = null;
                            item.state &= 0xFFFFFEFF;
                            throw ids;
                        }
                    }
                    break block28;
                }
                default: {
                    return 0;
                }
            }
            {
                Object count = null;
                item.state &= 0xFFFFFEFF;
            }
        }
        int count = 0;
        int i = 0;
        while (true) {
            if (i >= this.items.length) break;
            if (this.items[i] != null && this.items[i].parentItem == item) {
                ++count;
            }
            ++i;
        }
        TreeItem[] newItems = new TreeItem[count];
        int[] ids = new int[count];
        int i3 = 0;
        while (true) {
            if (i3 >= this.items.length) break;
            if (this.items[i3] != null && this.items[i3].parentItem == item) {
                ids[this.items[i3].index] = this.items[i3].id;
                newItems[this.items[i3].index] = this.items[i3];
            }
            ++i3;
        }
        OS.AddDataBrowserItems(this.handle, id, ids.length, ids, 0);
        this.setScrollWidth(newItems, false);
        return 0;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        switch (keyCode[0]) {
            case 36: {
                this.postEvent(14);
            }
        }
        return result;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int index;
        int[] outData = new int[1];
        OS.GetEventParameter(theEvent, 1667460724, 1835100014, null, 4, null, outData);
        this.clickCount = outData[0];
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        Shell shell = this.getShell();
        shell.bringToTop(true);
        Control oldFocus = this.display.getFocusControl();
        this.display.ignoreFocus = true;
        this.wasExpanded = false;
        this.wasSelected = false;
        result = OS.CallNextEventHandler(nextHandler, theEvent);
        this.display.ignoreFocus = false;
        if (oldFocus != this) {
            if (oldFocus != null && !oldFocus.isDisposed()) {
                oldFocus.sendFocusEvent(16, false);
            }
            if (!this.isDisposed() && this.isEnabled()) {
                this.sendFocusEvent(15, false);
            }
        }
        if (!this.wasSelected && !this.wasExpanded && OS.IsDataBrowserItemSelected(this.handle, this.lastHittest) && (index = this.lastHittest - 1) >= 0 && index < this.items.length) {
            Event event = new Event();
            event.item = this.items[index];
            this.postEvent(13, event);
        }
        if (this.wasExpanded) {
            Point outPt = new Point();
            OS.GetGlobalMouse(outPt);
            Rect rect = new Rect();
            int window = OS.GetControlOwner(this.handle);
            OS.GetWindowBounds(window, (short)33, rect);
            int x = outPt.h - rect.left;
            int y = outPt.v - rect.top;
            OS.GetControlBounds(this.handle, rect);
            x -= rect.left;
            y -= rect.top;
            short[] button = new short[1];
            OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, button);
            int chord = OS.GetCurrentEventButtonState();
            int modifiers = OS.GetCurrentEventKeyModifiers();
            this.sendMouseEvent(4, button[0], chord, (short)x, (short)y, modifiers, false);
        }
        this.wasExpanded = false;
        this.wasSelected = false;
        return result;
    }

    boolean releaseItem(TreeItem item) {
        if (item.isDisposed()) {
            return false;
        }
        this.items[item.id - 1] = null;
        return true;
    }

    void releaseItems(TreeItem[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            TreeItem item = nodes[i];
            TreeItem[] sons = item.getItems();
            if (sons.length != 0) {
                this.releaseItems(sons);
            }
            if (this.releaseItem(item)) {
                item.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        i = 0;
        while (i < this.columnCount) {
            TreeColumn column = this.columns[i];
            if (!column.isDisposed()) {
                column.releaseResources();
            }
            ++i;
        }
        this.columns = null;
        super.releaseWidget();
    }

    public void removeAll() {
        this.checkWidget();
        this.ignoreExpand = true;
        if (OS.RemoveDataBrowserItems(this.handle, 0, 0, null, 0) != 0) {
            this.error(15);
        }
        this.ignoreExpand = false;
        OS.SetDataBrowserScrollPosition(this.handle, 0, 0);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = new TreeItem[4];
        this.anchorLast = 0;
        this.anchorFirst = 0;
        this.setScrollWidth();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    void resetVisibleRegion(int control) {
        super.resetVisibleRegion(control);
        if (this.showItem != null && !this.showItem.isDisposed()) {
            this.showItem(this.showItem, true);
        }
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.ignoreSelect = true;
        OS.SetDataBrowserSelectedItems(this.handle, 0, null, 1);
        this.ignoreSelect = false;
    }

    void setBackground(float[] color) {
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if (this.showItem != null && !this.showItem.isDisposed()) {
            this.showItem(this.showItem, true);
        }
        return result;
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        if (this.items == null) {
            return;
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.width = -1;
            }
            ++i;
        }
        this.setScrollWidth();
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        if (height[0] != 0 != show) {
            OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)(show ? this.headerHeight : 0));
            this.invalidateVisibleRegion(this.handle);
        }
    }

    void setItemHeight(Image image) {
        Rectangle bounds;
        Rectangle rectangle = bounds = image != null ? image.getBounds() : this.imageBounds;
        if (bounds == null) {
            return;
        }
        this.imageBounds = bounds;
        short[] height = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, height) == 0 && height[0] < bounds.height) {
            OS.SetDataBrowserTableViewRowHeight(this.handle, (short)bounds.height);
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0) {
            this.setScrollWidth();
        }
    }

    void setScrollWidth() {
        this.setScrollWidth(this.getItems(null), true);
    }

    boolean setScrollWidth(TreeItem item) {
        if (this.ignoreRedraw || this.drawCount != 0) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        TreeItem parentItem = item.parentItem;
        if (parentItem != null && !parentItem._getExpanded()) {
            return false;
        }
        GC gc = new GC(this);
        int newWidth = item.calculateWidth(0, gc);
        gc.dispose();
        short[] width = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, width);
        if (width[0] < (newWidth += 30)) {
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)newWidth);
            return true;
        }
        return false;
    }

    boolean setScrollWidth(TreeItem[] items, boolean set) {
        if (this.ignoreRedraw || this.drawCount != 0) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        GC gc = new GC(this);
        int newWidth = this.calculateWidth(items, gc);
        gc.dispose();
        newWidth += 30;
        if (!set) {
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, width);
            if (width[0] >= newWidth) {
                return false;
            }
        }
        OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)newWidth);
        return true;
    }

    public void setSelection(TreeItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            if (items[i] == null) {
                this.error(5);
            }
            if (items[i].isDisposed()) {
                this.error(5);
            }
            ids[i] = items[i].id;
            this.showItem(items[i], false);
            ++i;
        }
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, selectionFlags);
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, ids.length, ids, 1);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0]);
        }
        this.ignoreSelect = false;
        if (length > 0) {
            this.showItem(items[0], true);
        }
    }

    public void setTopItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showItem(item, false);
        int columnId = this.columnCount == 0 ? this.column_id : this.columns[0].id;
        OS.RevealDataBrowserItem(this.handle, item.id, columnId, (byte)2);
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (this.columnCount <= 1 || index < 0 || index >= this.columnCount) {
            return;
        }
        short[] w = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, w);
        int width = w[0];
        int x = 0;
        int i = 0;
        while (i < index) {
            w = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.columns[i].id, w);
            x += w[0];
            ++i;
        }
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        if (x < left[0]) {
            OS.SetDataBrowserScrollPosition(this.handle, top[0], x);
        } else {
            Rectangle rect = this.getClientArea();
            int maxWidth = rect.width;
            if (x + (width = Math.min(width, maxWidth)) > left[0] + maxWidth) {
                left[0] = x + width - maxWidth;
                OS.SetDataBrowserScrollPosition(this.handle, top[0], left[0]);
            }
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showItem(item, true);
    }

    void showItem(TreeItem item, boolean scroll) {
        int count = 0;
        TreeItem parentItem = item.parentItem;
        while (parentItem != null && !parentItem._getExpanded()) {
            ++count;
            parentItem = parentItem.parentItem;
        }
        int index = 0;
        parentItem = item.parentItem;
        TreeItem[] path = new TreeItem[count];
        while (parentItem != null && !parentItem._getExpanded()) {
            path[index++] = parentItem;
            parentItem = parentItem.parentItem;
        }
        int i = path.length - 1;
        while (i >= 0) {
            path[i].setExpanded(true);
            --i;
        }
        if (scroll) {
            Rectangle rect = this.getClientArea();
            if (rect.height < this.getItemHeight() || !OS.IsControlVisible(this.handle)) {
                this.showItem = item;
                return;
            }
            this.showItem = null;
            Rectangle itemRect = item.getBounds();
            if (!itemRect.isEmpty() && rect.contains(itemRect.x, itemRect.y) && rect.contains(itemRect.x, itemRect.y + itemRect.height)) {
                return;
            }
            int[] top = new int[1];
            int[] left = new int[1];
            OS.GetDataBrowserScrollPosition(this.handle, top, left);
            int columnId = this.columnCount == 0 ? this.column_id : this.columns[0].id;
            OS.RevealDataBrowserItem(this.handle, item.id, columnId, (byte)2);
            int[] newTop = new int[1];
            int[] newLeft = new int[1];
            OS.GetDataBrowserScrollPosition(this.handle, newTop, newLeft);
            if (this.horizontalBar != null && newLeft[0] != left[0]) {
                this.horizontalBar.redraw();
            }
            if (this.verticalBar != null && newTop[0] != top[0]) {
                this.verticalBar.redraw();
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] selection = this.getSelection();
        if (selection.length > 0) {
            this.showItem(selection[0], true);
        }
    }

    int trackingProc(int browser, int id, int property, int theRect, int startPt, int modifiers) {
        return 1;
    }
}

