/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.EventRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.carbon.TXNBackground;
import org.eclipse.swt.internal.carbon.TXNLongRect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int txnObject;
    int txnFrameID;
    int textLimit = LIMIT;
    char echoCharacter;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\r";
    static final char PASSWORD = '\u00a5';

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        int charCount;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, charCount = this.getCharCount(), charCount, null)) == null) {
            return;
        }
        this.setTXNText(Integer.MAX_VALUE, Integer.MAX_VALUE, string);
        OS.TXNSetSelection(this.txnObject, Integer.MAX_VALUE, Integer.MAX_VALUE);
        OS.TXNShowSelection(this.txnObject, false);
        if (string.length() != 0) {
            this.sendEvent(24);
        }
    }

    static int checkStyle(int style) {
        if ((style & 4) != 0 && (style & 2) != 0) {
            style &= 0xFFFFFFFD;
        }
        if (((style = Text.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    int callFocusEventHandler(int nextHandler, int theEvent) {
        return 0;
    }

    public void clearSelection() {
        this.checkWidget();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
        OS.TXNSetSelection(this.txnObject, oStartOffset[0], oStartOffset[0]);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        TXNLongRect oTextRect = new TXNLongRect();
        OS.TXNGetRectBounds(this.txnObject, null, null, oTextRect);
        int width = oTextRect.right - oTextRect.left;
        int height = oTextRect.bottom - oTextRect.top;
        if (width <= 0) {
            width = 64;
        }
        if (height <= 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int ptr = OS.NewPtr(8);
        OS.TXNGetTXNObjectControls(this.txnObject, 1, new int[]{1835102823}, new int[]{ptr});
        Rect rect = new Rect();
        OS.memcpy(rect, ptr, 8);
        OS.DisposePtr(ptr);
        width += rect.left + rect.right;
        height += rect.top + rect.bottom;
        int[] size = new int[1];
        OS.GetThemeMetric(0, size);
        if (this.horizontalBar != null) {
            height += size[0];
        }
        if (this.verticalBar != null) {
            width += size[0];
        }
        Rect inset = this.inset();
        return new Rectangle(x -= inset.left, y -= inset.top, width += inset.left + inset.right, height += inset.top + inset.bottom);
    }

    public void copy() {
        this.checkWidget();
        OS.TXNCopy(this.txnObject);
    }

    void createHandle() {
        int features = 262;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateUserPaneControl(window, null, features, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        int[] theRoot = new int[1];
        OS.GetRootControl(window, theRoot);
        short[] oldCount = new short[1];
        OS.CountSubControls(theRoot[0], oldCount);
        int iFrameOptions = 135168;
        if ((this.style & 0x100) != 0) {
            iFrameOptions |= 4;
        }
        if ((this.style & 0x200) != 0) {
            iFrameOptions |= 8;
        }
        if ((this.style & 4) != 0) {
            iFrameOptions |= 0x4000;
        }
        if ((this.style & 0x40) != 0) {
            iFrameOptions |= 0x800;
        }
        int[] oTXNObject = new int[1];
        int[] oTXNFrameID = new int[1];
        OS.TXNNewObject(0, window, null, iFrameOptions, 1, 1970567284, 0, oTXNObject, oTXNFrameID, 0);
        if (oTXNObject[0] == 0) {
            this.error(2);
        }
        this.txnObject = oTXNObject[0];
        this.txnFrameID = oTXNFrameID[0];
        short[] newCount = new short[1];
        OS.CountSubControls(theRoot[0], newCount);
        int[] scrollBar = new int[1];
        int i = newCount[0];
        while (i > oldCount[0]) {
            OS.GetIndexedSubControl(theRoot[0], (short)i, scrollBar);
            OS.HIViewRemoveFromSuperview(scrollBar[0]);
            OS.HIViewAddSubview(this.handle, scrollBar[0]);
            --i;
        }
        int ptr = OS.NewPtr(8);
        Rect rect = new Rect();
        if (this.hasBorder()) {
            OS.SetRect(rect, (short)1, (short)1, (short)1, (short)1);
        }
        OS.memcpy(ptr, rect, 8);
        int[] tags = new int[]{1685217639, 1768910966, 1835102823, 1786082164};
        int just = 1;
        if ((this.style & 0x1000000) != 0) {
            just = 4;
        }
        if ((this.style & 0x20000) != 0) {
            just = 2;
        }
        int[] datas = new int[]{1, (this.style & 8) != 0 ? 1 : 0, ptr, just};
        OS.TXNSetTXNObjectControls(this.txnObject, false, tags.length, tags, datas);
        OS.TXNSetFrameBounds(this.txnObject, 0, 0, 0, 0, this.txnFrameID);
        OS.DisposePtr(ptr);
        char[] buffer = new char[]{' '};
        OS.TXNSetData(this.txnObject, 1970567284, buffer, 2, 0, Integer.MAX_VALUE);
        OS.TXNSetData(this.txnObject, 1970567284, buffer, 0, 0, Integer.MAX_VALUE);
    }

    ScrollBar createScrollBar(int style) {
        return this.createStandardBar(style);
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x400000) != 0) {
            this.setEchoChar('\u00a5');
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean cut = true;
        org.eclipse.swt.graphics.Point oldSelection = this.getSelection();
        if ((this.hooks(25) || this.filters(25)) && oldSelection.x != oldSelection.y) {
            String newText = this.verifyText("", oldSelection.x, oldSelection.y, null);
            if (newText == null) {
                return;
            }
            if (newText.length() != 0) {
                this.setTXNText(-1, -1, newText);
                OS.TXNShowSelection(this.txnObject, false);
                cut = false;
            }
        }
        if (cut) {
            OS.TXNCut(this.txnObject);
            if (OS.TXNDataSize(this.txnObject) / 2 == 0) {
                this.setFontStyle(this.font);
            }
        }
        org.eclipse.swt.graphics.Point newSelection = this.getSelection();
        if (!cut || !oldSelection.equals(newSelection)) {
            this.sendEvent(24);
        }
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    void drawBackground(int control) {
        this.drawFocus(control, this.hasFocus() && this.drawFocusRing(), this.hasBorder(), this.getParentBackground(), this.inset());
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
        OS.TXNDraw(this.txnObject, 0);
        super.drawWidget(control, damageRgn, visibleRgn, theEvent);
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return (this.getTopPixel() + this.getCaretLocation().y) / this.getLineHeight();
    }

    public org.eclipse.swt.graphics.Point getCaretLocation() {
        this.checkWidget();
        Point oPoint = new Point();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
        OS.TXNOffsetToPoint(this.txnObject, oStartOffset[0], oPoint);
        Rect oViewRect = new Rect();
        OS.TXNGetViewRect(this.txnObject, oViewRect);
        return new org.eclipse.swt.graphics.Point(oPoint.h - oViewRect.left, oPoint.v - oViewRect.top);
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
        return oStartOffset[0];
    }

    public int getCharCount() {
        this.checkWidget();
        return OS.TXNDataSize(this.txnObject) / 2;
    }

    String getClipboardText() {
        int[] scrap = new int[1];
        OS.GetCurrentScrap(scrap);
        int[] size = new int[1];
        if (OS.GetScrapFlavorSize(scrap[0], 1970567284, size) != 0 || size[0] == 0) {
            return "";
        }
        char[] buffer = new char[size[0] / 2];
        if (OS.GetScrapFlavorData(scrap[0], 1970567284, size, buffer) != 0) {
            return "";
        }
        return new String(buffer);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return true;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoCharacter;
    }

    public boolean getEditable() {
        this.checkWidget();
        return (this.style & 8) == 0;
    }

    public int getLineCount() {
        this.checkWidget();
        int[] oLineTotal = new int[1];
        OS.TXNGetLineCount(this.txnObject, oLineTotal);
        return oLineTotal[0];
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        int[] oLineWidth = new int[1];
        int[] oLineHeight = new int[1];
        OS.TXNGetLineMetrics(this.txnObject, 0, oLineWidth, oLineHeight);
        return OS.Fix2Long(oLineHeight[0]);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public org.eclipse.swt.graphics.Point getSelection() {
        this.checkWidget();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
        return new org.eclipse.swt.graphics.Point(oStartOffset[0], oEndOffset[0]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
        return oEndOffset[0] - oStartOffset[0];
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.getTXNText(-1, -1);
    }

    public int getTabs() {
        this.checkWidget();
        return 8;
    }

    public String getText() {
        this.checkWidget();
        return this.getTXNText(0, Integer.MAX_VALUE);
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        int length = OS.TXNDataSize(this.txnObject) / 2;
        start = Math.max(0, start);
        end = Math.min(end, length - 1);
        return this.getTXNText(start, end + 1);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return this.getTopPixel() / this.getLineHeight();
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        Rect oViewRect = new Rect();
        TXNLongRect oDestinationRect = new TXNLongRect();
        TXNLongRect oTextRect = new TXNLongRect();
        OS.TXNGetRectBounds(this.txnObject, oViewRect, oDestinationRect, oTextRect);
        return oDestinationRect.top - oTextRect.top;
    }

    String getTXNText(int iStartOffset, int iEndOffset) {
        int[] oDataHandle = new int[1];
        OS.TXNGetData(this.txnObject, iStartOffset, iEndOffset, oDataHandle);
        if (oDataHandle[0] == 0) {
            return "";
        }
        int length = OS.GetHandleSize(oDataHandle[0]);
        if (length == 0) {
            return "";
        }
        int[] ptr = new int[1];
        OS.HLock(oDataHandle[0]);
        OS.memcpy(ptr, oDataHandle[0], 4);
        char[] buffer = new char[length / 2];
        OS.memcpy(buffer, ptr[0], length);
        OS.HUnlock(oDataHandle[0]);
        OS.DisposeHandle(oDataHandle[0]);
        return new String(buffer);
    }

    Rect inset() {
        Rect rect = new Rect();
        int[] outMetric = new int[1];
        if (this.drawFocusRing()) {
            OS.GetThemeMetric(7, outMetric);
            rect.left = (short)(rect.left + outMetric[0]);
            rect.top = (short)(rect.top + outMetric[0]);
            rect.right = (short)(rect.right + outMetric[0]);
            rect.bottom = (short)(rect.bottom + outMetric[0]);
        }
        if (this.hasBorder()) {
            OS.GetThemeMetric(5, outMetric);
            rect.left = (short)(rect.left + outMetric[0]);
            rect.top = (short)(rect.top + outMetric[0]);
            rect.right = (short)(rect.right + outMetric[0]);
            rect.bottom = (short)(rect.bottom + outMetric[0]);
        }
        return rect;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            org.eclipse.swt.graphics.Point selection = this.getSelection();
            if ((string = this.verifyText(string, selection.x, selection.y, null)) == null) {
                return;
            }
        }
        this.setTXNText(-1, -1, string);
        OS.TXNShowSelection(this.txnObject, false);
        if (string.length() != 0) {
            this.sendEvent(24);
        }
    }

    int kEventControlActivate(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlActivate(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        OS.TXNFocus(this.txnObject, this.hasFocus());
        OS.TXNActivate(this.txnObject, this.txnFrameID, true);
        return result;
    }

    int kEventControlBoundsChanged(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlBoundsChanged(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] attributes = new int[1];
        OS.GetEventParameter(theEvent, 1635021938, 1835100014, null, attributes.length * 4, null, attributes);
        if ((attributes[0] & 0xC) != 0) {
            this.setTXNBounds();
        }
        return result;
    }

    int kEventControlClick(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlClick(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (!this.isEnabled()) {
            return 0;
        }
        int window = OS.GetControlOwner(this.handle);
        OS.SetKeyboardFocus(window, this.handle, (short)-1);
        EventRecord iEvent = new EventRecord();
        OS.ConvertEventRefToEventRecord(theEvent, iEvent);
        OS.TXNClick(this.txnObject, iEvent);
        return 0;
    }

    int kEventControlDeactivate(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlDeactivate(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        OS.TXNFocus(this.txnObject, this.hasFocus());
        OS.TXNActivate(this.txnObject, this.txnFrameID, false);
        return result;
    }

    int kEventControlGetFocusPart(int nextHandler, int theEvent, int userData) {
        return 0;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetCursor(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        OS.TXNAdjustCursor(this.txnObject, 0);
        return 0;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            short[] part = new short[1];
            OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
            this.drawFocusClipped(this.handle, part[0] != 0 && this.drawFocusRing(), this.hasBorder(), this.getParentBackground(), this.inset());
            OS.TXNDraw(this.txnObject, 0);
            OS.TXNFocus(this.txnObject, part[0] != 0);
        }
        return result;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int[] keyCode;
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] modifiers = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1802334052, 1835100014, null, 4, null, modifiers);
        if (modifiers[0] == 256) {
            keyCode = new int[1];
            OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
            switch (keyCode[0]) {
                case 7: {
                    this.cut();
                    return 0;
                }
                case 8: {
                    this.copy();
                    return 0;
                }
                case 9: {
                    this.paste();
                    return 0;
                }
            }
        }
        if ((this.style & 4) != 0) {
            keyCode = new int[1];
            OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
            switch (keyCode[0]) {
                case 36: {
                    this.postEvent(14);
                    return 0;
                }
                case 48: {
                    return 0;
                }
            }
        }
        return result;
    }

    public void paste() {
        String oldText;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean paste = true;
        if ((this.hooks(25) || this.filters(25)) && (oldText = this.getClipboardText()) != null) {
            org.eclipse.swt.graphics.Point selection = this.getSelection();
            String newText = this.verifyText(oldText, selection.x, selection.y, null);
            if (newText == null) {
                return;
            }
            if (!newText.equals(oldText)) {
                this.setTXNText(-1, -1, newText);
                OS.TXNShowSelection(this.txnObject, false);
                paste = false;
            }
        }
        if (paste) {
            OS.TXNPaste(this.txnObject);
        }
        this.sendEvent(24);
    }

    void releaseWidget() {
        super.releaseWidget();
        OS.TXNDeleteObject(this.txnObject);
        this.txnFrameID = 0;
        this.txnObject = 0;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    void resetVisibleRegion(int control) {
        super.resetVisibleRegion(control);
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        Rect inset = this.inset();
        rect.left = (short)(rect.left + inset.left);
        rect.top = (short)(rect.top + inset.top);
        rect.right = (short)(rect.right - inset.right);
        rect.bottom = OS.IsControlVisible(this.handle) ? (short)(rect.bottom - inset.bottom) : rect.top;
        OS.TXNSetFrameBounds(this.txnObject, rect.top, rect.left, rect.bottom, rect.right, this.txnFrameID);
    }

    public void selectAll() {
        this.checkWidget();
        OS.TXNSelectAll(this.txnObject);
    }

    boolean sendKeyEvent(int type, Event event) {
        String newText;
        if (!super.sendKeyEvent(type, event)) {
            return false;
        }
        if (type != 1) {
            return true;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        String oldText = "";
        int charCount = this.getCharCount();
        org.eclipse.swt.graphics.Point selection = this.getSelection();
        int start = selection.x;
        int end = selection.y;
        switch (event.character) {
            case '\b': {
                if (start != end) break;
                if (start == 0) {
                    return true;
                }
                start = Math.max(0, start - 1);
                break;
            }
            case '\u007f': {
                if (start != end) break;
                if (start == charCount) {
                    return true;
                }
                end = Math.min(end + 1, charCount);
                break;
            }
            case '\r': {
                if ((this.style & 4) != 0) {
                    return true;
                }
                oldText = DELIMITER;
                break;
            }
            default: {
                if (event.character != '\t' && event.character < ' ') {
                    return true;
                }
                oldText = new String(new char[]{event.character});
            }
        }
        if ((newText = this.verifyText(oldText, start, end, event)) == null) {
            return false;
        }
        if (charCount - (end - start) + newText.length() > this.textLimit) {
            return false;
        }
        if (newText != oldText) {
            this.setTXNText(start, end, newText);
        }
        this.postEvent(24);
        return newText == oldText;
    }

    void setBackground(float[] color) {
        TXNBackground txnColor = new TXNBackground();
        txnColor.bgType = 1;
        short red = (short)(color == null ? 255.0f : color[0] * 255.0f);
        short green = (short)(color == null ? 255.0f : color[1] * 255.0f);
        short blue = (short)(color == null ? 255.0f : color[2] * 255.0f);
        txnColor.bg_red = (short)(red << 8 | red);
        txnColor.bg_green = (short)(green << 8 | green);
        txnColor.bg_blue = (short)(blue << 8 | blue);
        OS.TXNSetBackground(this.txnObject, txnColor);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if ((result & 0xC0) != 0) {
            this.setTXNBounds();
        }
        return result;
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.echoCharacter = echo;
        OS.TXNEchoMode(this.txnObject, echo, 0, echo != '\u0000');
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style = editable ? (this.style &= 0xFFFFFFF7) : (this.style |= 8);
        OS.TXNSetTXNObjectControls(this.txnObject, false, 1, new int[]{1768910966}, new int[]{(this.style & 8) != 0 ? 1 : 0});
    }

    void setForeground(float[] color) {
        int ptr2 = OS.NewPtr(6);
        RGBColor rgb = color == null ? new RGBColor() : this.toRGBColor(color);
        OS.memcpy(ptr2, rgb, 6);
        int[] attribs = new int[]{1802268530, 6, ptr2};
        int ptr1 = OS.NewPtr(attribs.length * 4);
        OS.memcpy(ptr1, attribs, attribs.length * 4);
        OS.TXNSetTypeAttributes(this.txnObject, attribs.length / 3, ptr1, 0, 0);
        OS.DisposePtr(ptr1);
        OS.DisposePtr(ptr2);
    }

    void setFontStyle(Font font) {
        int[] attribs = new int[]{1936292453, 2, font == null ? 786432 : OS.X2Fix(font.size), 1717658469, 2, font == null ? (short)0 : font.style, 1718578804, 2, font == null ? (short)0 : font.id};
        int ptr = OS.NewPtr(attribs.length * 4);
        OS.memcpy(ptr, attribs, attribs.length * 4);
        boolean readOnly = (this.style & 8) != 0;
        int[] tag = new int[]{1768910966};
        if (readOnly) {
            OS.TXNSetTXNObjectControls(this.txnObject, false, 1, tag, new int[1]);
        }
        OS.TXNSetTypeAttributes(this.txnObject, attribs.length / 3, ptr, 0, 0);
        if (readOnly) {
            OS.TXNSetTXNObjectControls(this.txnObject, false, 1, tag, new int[]{1});
        }
        OS.DisposePtr(ptr);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(int start) {
        this.checkWidget();
        this.setSelection(start, start);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        int length = OS.TXNDataSize(this.txnObject) / 2;
        int nStart = Math.min(Math.max(Math.min(start, end), 0), length);
        int nEnd = Math.min(Math.max(Math.max(start, end), 0), length);
        OS.TXNSetSelection(this.txnObject, nStart, nEnd);
        OS.TXNShowSelection(this.txnObject, false);
    }

    public void setSelection(org.eclipse.swt.graphics.Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        this.setTXNText(0, Integer.MAX_VALUE, string);
        OS.TXNSetSelection(this.txnObject, 0, 0);
        OS.TXNShowSelection(this.txnObject, false);
        this.sendEvent(24);
    }

    void setTXNBounds() {
        Rect viewRect = new Rect();
        OS.TXNGetViewRect(this.txnObject, viewRect);
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        Rect inset = this.inset();
        rect.left = (short)(rect.left + inset.left);
        rect.top = (short)(rect.top + inset.top);
        rect.right = (short)(rect.right - inset.right);
        rect.bottom = (short)(rect.bottom - inset.bottom);
        OS.TXNSetFrameBounds(this.txnObject, rect.top, rect.left, rect.bottom, rect.right, this.txnFrameID);
        int width = viewRect.left - viewRect.right;
        int height = viewRect.bottom - viewRect.top;
        if (width <= inset.left + inset.right && height <= inset.top + inset.bottom) {
            int[] oStartOffset = new int[1];
            int[] oEndOffset = new int[1];
            OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
            OS.TXNSetSelection(this.txnObject, 0, 0);
            OS.TXNShowSelection(this.txnObject, false);
            OS.TXNSetSelection(this.txnObject, oStartOffset[0], oEndOffset[0]);
            OS.TXNShowSelection(this.txnObject, false);
        }
    }

    void setTXNText(int iStartOffset, int iEndOffset, String string) {
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        boolean readOnly = (this.style & 8) != 0;
        int[] tag = new int[]{1768910966};
        if (readOnly) {
            OS.TXNSetTXNObjectControls(this.txnObject, false, 1, tag, new int[1]);
        }
        OS.TXNSetData(this.txnObject, 1970567284, buffer, buffer.length * 2, iStartOffset, iEndOffset);
        if (readOnly) {
            OS.TXNSetTXNObjectControls(this.txnObject, false, 1, tag, new int[]{1});
        }
        if (OS.TXNDataSize(this.txnObject) / 2 == 0) {
            this.setFontStyle(this.font);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        this.textLimit = limit;
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
    }

    public void showSelection() {
        this.checkWidget();
        OS.TXNShowSelection(this.txnObject, false);
    }

    int traversalCode(int key, int theEvent) {
        int bits = super.traversalCode(key, theEvent);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 48 && theEvent != 0) {
                boolean next;
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                boolean bl = next = (modifiers[0] & 0x200) == 0;
                if (next && (modifiers[0] & 0x1000) == 0) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

