/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    boolean dragging;
    boolean tracking;
    int increment = 1;
    int pageIncrement = 10;

    public Slider(Composite parent, int style) {
        super(parent, Slider.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Slider.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    int actionProc(int theControl, int partCode) {
        Event event = new Event();
        int value = OS.GetControl32BitValue(this.handle);
        switch (partCode) {
            case 20: {
                value -= this.increment;
                event.detail = 0x1000001;
                break;
            }
            case 22: {
                value -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 23: {
                value += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 21: {
                value += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 129: {
                this.dragging = true;
                event.detail = 1;
                break;
            }
            default: {
                return 0;
            }
        }
        OS.SetControl32BitValue(this.handle, value);
        this.sendEvent(13, event);
        Shell shell = this.getShell();
        shell.update(true);
        return 0;
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int[] outMetric = new int[1];
        OS.GetThemeMetric(0, outMetric);
        int width = 0;
        int height = 0;
        if ((this.style & 0x100) != 0) {
            height = outMetric[0];
            width = height * 10;
        } else {
            width = outMetric[0];
            height = width * 10;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    void createHandle() {
        int actionProc = this.display.actionProc;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateScrollBarControl(window, null, 0, 0, 90, 10, true, actionProc, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void drawBackground(int control) {
        this.drawBackground(control, this.background);
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        int maximum = OS.GetControl32BitMaximum(this.handle);
        int viewSize = OS.GetControlViewSize(this.handle);
        return maximum + viewSize;
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.GetControl32BitMinimum(this.handle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return OS.GetControl32BitValue(this.handle);
    }

    public int getThumb() {
        this.checkWidget();
        return OS.GetControlViewSize(this.handle);
    }

    int kEventControlTrack(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlTrack(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.tracking = true;
        return -9874;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int status = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (status == 0) {
            return status;
        }
        this.display.grabControl = null;
        this.display.runDeferredEvents();
        this.tracking = false;
        this.dragging = false;
        status = OS.CallNextEventHandler(nextHandler, theEvent);
        if (this.dragging) {
            Event event = new Event();
            this.sendEvent(13, event);
        }
        this.dragging = false;
        if (this.tracking) {
            Point outPt = new Point();
            OS.GetGlobalMouse(outPt);
            Rect rect = new Rect();
            int window = OS.GetControlOwner(this.handle);
            OS.GetWindowBounds(window, (short)33, rect);
            int x = outPt.h - rect.left;
            int y = outPt.v - rect.top;
            OS.GetControlBounds(this.parent.handle, rect);
            x -= rect.left;
            y -= rect.top;
            short[] button = new short[1];
            OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, button);
            int chord = OS.GetCurrentEventButtonState();
            int modifiers = OS.GetCurrentEventKeyModifiers();
            this.sendMouseEvent(4, button[0], chord, (short)x, (short)y, modifiers, true);
        }
        this.tracking = false;
        return status;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int minimum = OS.GetControl32BitMinimum(this.handle);
        if (value <= minimum) {
            return;
        }
        int viewSize = OS.GetControlViewSize(this.handle);
        if (value - minimum < viewSize) {
            viewSize = value - minimum;
            OS.SetControlViewSize(this.handle, viewSize);
        }
        OS.SetControl32BitMaximum(this.handle, value - viewSize);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int viewSize = OS.GetControlViewSize(this.handle);
        int maximum = OS.GetControl32BitMaximum(this.handle) + viewSize;
        if (value >= maximum) {
            return;
        }
        if (maximum - value < viewSize) {
            viewSize = maximum - value;
            OS.SetControl32BitMaximum(this.handle, maximum - viewSize);
            OS.SetControlViewSize(this.handle, viewSize);
        }
        OS.SetControl32BitMinimum(this.handle, value);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.SetControl32BitValue(this.handle, value);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int minimum = OS.GetControl32BitMinimum(this.handle);
        int viewSize = OS.GetControlViewSize(this.handle);
        int maximum = OS.GetControl32BitMaximum(this.handle) + viewSize;
        value = Math.min(value, maximum - minimum);
        OS.SetControl32BitMaximum(this.handle, maximum - value);
        OS.SetControlViewSize(this.handle, value);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        OS.SetControl32BitMinimum(this.handle, minimum);
        OS.SetControl32BitMaximum(this.handle, maximum - thumb);
        OS.SetControlViewSize(this.handle, thumb);
        OS.SetControl32BitValue(this.handle, selection);
        this.increment = increment;
        this.pageIncrement = pageIncrement;
    }
}

