/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int accelerator;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    int createEmptyMenu() {
        if ((this.parent.style & 2) != 0) {
            int[] outMenuRef = new int[1];
            if (OS.CreateNewMenu((short)0, 0, outMenuRef) != 0) {
                this.error(2);
            }
            return outMenuRef[0];
        }
        return 0;
    }

    void destroyEmptyMenu(int index) {
        if ((this.parent.style & 2) != 0) {
            if (index == -1) {
                index = this.parent.indexOf(this);
            }
            if (index != -1) {
                short menuIndex = (short)(index + 1);
                int[] outMenuRef = new int[1];
                OS.GetMenuItemHierarchicalMenu(this.parent.handle, menuIndex, outMenuRef);
                if (outMenuRef[0] != 0) {
                    OS.DisposeMenu(outMenuRef[0]);
                }
            }
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if ((this.parent.style & 2) != 0) {
            int index = this.parent.indexOf(this);
            if (index == -1) {
                return new Rectangle(0, 0, 0, 0);
            }
            Menu menu = this.display.getMenuBar();
            if (this.parent != menu) {
                return new Rectangle(0, 0, 0, 0);
            }
            int[] outMenuRef = new int[1];
            if (OS.GetMenuItemHierarchicalMenu(menu.handle, (short)(index + 1), outMenuRef) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            Rect rect = new Rect();
            int width = rect.right - rect.left;
            int height = rect.bottom - rect.top;
            return new Rectangle(rect.left, rect.top, width, height);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return false;
        }
        short[] outMark = new short[1];
        OS.GetItemMark(this.parent.handle, (short)(index + 1), outMark);
        return outMark[0] != 0;
    }

    int kEventProcessCommand(int nextHandler, int theEvent, int userData) {
        if (!this.isEnabled()) {
            return 0;
        }
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        int[] modifiers = new int[1];
        OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
        Event event = new Event();
        this.setInputState(event, 0, OS.GetCurrentEventButtonState(), modifiers[0]);
        this.postEvent(13, event);
        return 0;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    int keyGlyph(int key) {
        switch (key) {
            case 8: {
                return 23;
            }
            case 13: {
                return 11;
            }
            case 127: {
                return 10;
            }
            case 27: {
                return 27;
            }
            case 10: {
                return 11;
            }
            case 9: {
                return 2;
            }
            case 32: {
                return 97;
            }
            case 65536: {
                return 7;
            }
            case 131072: {
                return 5;
            }
            case 262144: {
                return 138;
            }
            case 0x400000: {
                return 17;
            }
            case 0x1000001: {
                return 104;
            }
            case 0x1000002: {
                return 106;
            }
            case 0x1000003: {
                return 100;
            }
            case 0x1000004: {
                return 101;
            }
            case 0x1000005: {
                return 98;
            }
            case 0x1000006: {
                return 107;
            }
            case 0x100000A: {
                return 111;
            }
            case 0x100000B: {
                return 112;
            }
            case 0x100000C: {
                return 113;
            }
            case 0x100000D: {
                return 114;
            }
            case 0x100000E: {
                return 115;
            }
            case 0x100000F: {
                return 116;
            }
            case 0x1000010: {
                return 117;
            }
            case 0x1000011: {
                return 118;
            }
            case 0x1000012: {
                return 119;
            }
            case 0x1000013: {
                return 120;
            }
            case 0x1000014: {
                return 121;
            }
            case 0x1000015: {
                return 122;
            }
        }
        return 0;
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        if (this.menu == null) {
            this.destroyEmptyMenu(-1);
        } else {
            this.menu.releaseWidget();
            this.menu.destroyWidget();
        }
        this.menu = null;
        super.releaseWidget();
        this.accelerator = 0;
        if (this == this.parent.defaultItem) {
            this.parent.defaultItem = null;
        }
        this.parent = null;
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        int index = 0;
        MenuItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        boolean update = this.accelerator == 0 && accelerator != 0 || this.accelerator != 0 && accelerator == 0;
        this.accelerator = accelerator;
        boolean inSetVirtualKey = false;
        int inModifiers = 0;
        int inGlyph = 0;
        int inKey = 0;
        if (accelerator != 0) {
            inKey = accelerator & 0x100FFFF;
            inGlyph = this.keyGlyph(inKey);
            int virtualKey = Display.untranslateKey(inKey);
            if (inKey == 32) {
                virtualKey = 49;
            }
            if (virtualKey != 0) {
                inSetVirtualKey = true;
                inKey = virtualKey;
            } else {
                inKey = Character.toUpperCase((char)inKey);
            }
            inModifiers = 8;
            if ((accelerator & 0x20000) != 0) {
                inModifiers |= 1;
            }
            if ((accelerator & 0x40000) != 0) {
                inModifiers |= 4;
            }
            if ((accelerator & 0x400000) != 0) {
                inModifiers &= 0xFFFFFFF7;
            }
            if ((accelerator & 0x10000) != 0) {
                inModifiers |= 2;
            }
        }
        short menuIndex = (short)(index + 1);
        OS.SetMenuItemModifiers(this.parent.handle, menuIndex, (byte)inModifiers);
        OS.SetMenuItemCommandKey(this.parent.handle, menuIndex, inSetVirtualKey, (char)inKey);
        OS.SetMenuItemKeyGlyph(this.parent.handle, menuIndex, (short)inGlyph);
        if (update) {
            this.updateText(menuIndex);
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int[] outMenuRef = new int[1];
        short menuIndex = (short)(index + 1);
        OS.GetMenuItemHierarchicalMenu(this.parent.handle, menuIndex, outMenuRef);
        if (enabled) {
            this.state &= 0xFFFFFFF7;
            if (outMenuRef[0] != 0) {
                OS.EnableMenuItem(outMenuRef[0], (short)0);
            }
            OS.EnableMenuItem(this.parent.handle, menuIndex);
        } else {
            this.state |= 8;
            if (outMenuRef[0] != 0) {
                OS.DisableMenuItem(outMenuRef[0], (short)0);
            }
            OS.DisableMenuItem(this.parent.handle, menuIndex);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        super.setImage(image);
        int imageHandle = image != null ? image.handle : 0;
        byte type = image != null ? (byte)7 : 0;
        OS.SetMenuItemIconHandle(this.parent.handle, (short)(index + 1), type, imageHandle);
    }

    public void setMenu(Menu menu) {
        Menu oldMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((oldMenu = this.menu) == menu) {
            return;
        }
        if (oldMenu != null) {
            oldMenu.cascade = null;
        }
        this.menu = menu;
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int menuHandle = 0;
        if (menu == null) {
            menuHandle = this.createEmptyMenu();
        } else {
            menu.cascade = this;
            if (oldMenu == null) {
                this.destroyEmptyMenu(index);
            }
            menuHandle = menu.handle;
        }
        short menuIndex = (short)(index + 1);
        if (menuHandle != 0) {
            int[] outString = new int[1];
            if (OS.CopyMenuItemTextAsCFString(this.parent.handle, menuIndex, outString) != 0) {
                this.error(29);
            }
            OS.SetMenuTitleWithCFString(menuHandle, outString[0]);
            OS.CFRelease(outString[0]);
        }
        if (OS.SetMenuItemHierarchicalMenu(this.parent.handle, menuIndex, menuHandle) != 0) {
            this.error(29);
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int inMark = selected ? ((this.style & 0x10) != 0 ? 19 : 18) : 0;
        OS.SetItemMark(this.parent.handle, (short)(index + 1), (short)inMark);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        super.setText(string);
        this.updateText((short)(index + 1));
    }

    void updateText(short menuIndex) {
        int str;
        if ((this.style & 2) != 0) {
            return;
        }
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int i = 0;
        int j = 0;
        while (i < buffer.length) {
            if (buffer[i] == '\t') break;
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            --j;
        }
        if ((str = OS.CFStringCreateWithCharacters(0, buffer, j)) == 0) {
            this.error(13);
        }
        OS.SetMenuItemTextWithCFString(this.parent.handle, menuIndex, str);
        int[] outHierMenu = new int[1];
        OS.GetMenuItemHierarchicalMenu(this.parent.handle, menuIndex, outHierMenu);
        if (outHierMenu[0] != 0) {
            OS.SetMenuTitleWithCFString(outHierMenu[0], str);
        }
        OS.CFRelease(str);
    }
}

