/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    String text = "";

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rect bounds;
        boolean fixBounds;
        this.checkWidget();
        Rect oldBounds = new Rect();
        OS.GetControlBounds(this.handle, oldBounds);
        boolean bl = fixBounds = oldBounds.right - oldBounds.left < 100 || oldBounds.bottom - oldBounds.top < 100;
        if (fixBounds) {
            bounds = new Rect();
            bounds.bottom = (short)100;
            bounds.right = (short)100;
            OS.SetControlBounds(this.handle, bounds);
        } else {
            bounds = oldBounds;
        }
        int rgnHandle = OS.NewRgn();
        OS.GetControlRegion(this.handle, (short)-2, rgnHandle);
        Rect client = new Rect();
        OS.GetRegionBounds(rgnHandle, client);
        OS.DisposeRgn(rgnHandle);
        if (fixBounds) {
            OS.SetControlBounds(this.handle, oldBounds);
        }
        return new Rectangle(x -= client.left - bounds.left, y -= client.top - bounds.top, width += Math.max(8, bounds.right - bounds.left - (client.right - client.left)), height += Math.max(this.text.length() == 0 ? 8 : 22, bounds.bottom - bounds.top - (client.bottom - client.top)));
    }

    void createHandle() {
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateGroupBoxControl(window, null, 0, true, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void drawBackground(int control) {
        this.drawBackground(control, this.background);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rect bounds = new Rect();
        OS.GetControlBounds(this.handle, bounds);
        int rgnHandle = OS.NewRgn();
        OS.GetControlRegion(this.handle, (short)-2, rgnHandle);
        Rect client = new Rect();
        OS.GetRegionBounds(rgnHandle, client);
        OS.DisposeRgn(rgnHandle);
        int x = Math.max(0, client.left - bounds.left);
        int y = this.text.length() == 0 ? x : Math.max(0, client.top - bounds.top);
        int width = Math.max(0, client.right - client.left);
        int height = Math.max(0, this.text.length() == 0 ? bounds.bottom - bounds.top - 2 * y : client.bottom - client.top);
        return new Rectangle(x, y, width, height);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, length);
        if (ptr == 0) {
            this.error(13);
        }
        OS.SetControlTitleWithCFString(this.handle, ptr);
        OS.CFRelease(ptr);
    }
}

