/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public int handle;
    Composite parent;
    String toolTipText;
    Object layoutData;
    int drawCount;
    int visibleRgn;
    Menu menu;
    float[] foreground;
    float[] background;
    Font font;
    Cursor cursor;
    GCData[] gcs;
    Accessible accessible;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    int colorProc(int inControl, int inMessage, int inDrawDepth, int inDrawInColor) {
        switch (inMessage) {
            case 30: {
                if (this.foreground != null) {
                    OS.RGBForeColor(this.toRGBColor(this.foreground));
                } else {
                    OS.SetThemeTextColor((short)1, (short)inDrawDepth, inDrawInColor != 0);
                }
                return 0;
            }
            case 23: {
                float[] background;
                float[] fArray = background = this.background != null ? this.background : this.getParentBackground();
                if (background != null) {
                    OS.RGBBackColor(this.toRGBColor(background));
                } else {
                    OS.SetThemeBackground((short)1, (short)inDrawDepth, inDrawInColor != 0);
                }
                return 0;
            }
        }
        return -9874;
    }

    int callFocusEventHandler(int nextHandler, int theEvent) {
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new org.eclipse.swt.graphics.Point(width += border * 2, height += border * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.checkBuffered();
        this.setDefaultFont();
        this.setZOrder();
    }

    Color defaultBackground() {
        return this.display.getSystemColor(22);
    }

    Font defaultFont() {
        byte[] family = new byte[256];
        short[] size = new short[1];
        byte[] style = new byte[1];
        OS.GetThemeFont((short)this.defaultThemeFont(), (short)-1, family, size, style);
        short id = OS.FMGetFontFamilyFromName(family);
        int[] font = new int[1];
        OS.FMGetFontFromFontFamilyInstance(id, style[0], font, null);
        return Font.carbon_new(this.display, font[0], id, style[0], size[0]);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(21);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 0;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        int theControl = this.topHandle();
        this.releaseHandle();
        if (theControl != 0) {
            OS.DisposeControl(theControl);
        }
    }

    boolean drawFocusRing() {
        return !this.display.noFocusRing || this.getShell().parent != null;
    }

    boolean drawGripper(int x, int y, int width, int height) {
        return false;
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
        if (control != this.handle) {
            return;
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return;
        }
        Rect rect = new Rect();
        OS.GetRegionBounds(visibleRgn, rect);
        Rect bounds = new Rect();
        OS.GetControlBounds(this.handle, bounds);
        OS.OffsetRect(rect, -bounds.left, -bounds.top);
        int[] port = new int[1];
        OS.GetPort(port);
        GCData data = new GCData();
        data.port = port[0];
        data.paintEvent = theEvent;
        data.visibleRgn = visibleRgn;
        GC gc = GC.carbon_new(this, data);
        Event event = new Event();
        event.gc = gc;
        event.x = rect.left;
        event.y = rect.top;
        event.width = rect.right - rect.left;
        event.height = rect.bottom - rect.top;
        this.sendEvent(9, event);
        event.gc = null;
        gc.dispose();
    }

    void enableWidget(boolean enabled) {
        int topHandle = this.topHandle();
        if (enabled) {
            OS.EnableControl(topHandle);
        } else {
            OS.DisableControl(topHandle);
        }
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell && (control = control.parent) != null) {
            if (!control.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(focusControl);
        int window = OS.GetControlOwner(this.handle);
        OS.ClearKeyboardFocus(window);
    }

    int focusHandle() {
        return this.handle;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        shell.setSavedFocus(null);
        shell.bringToTop(false);
        if (this.isDisposed()) {
            return false;
        }
        Control oldFocus = this.display.getFocusControl();
        this.display.ignoreFocus = true;
        int focusHandle = this.focusHandle();
        int window = OS.GetControlOwner(focusHandle);
        OS.SetKeyboardFocus(window, focusHandle, (short)-1);
        this.display.ignoreFocus = false;
        Control newFocus = this.display.getFocusControl();
        if (oldFocus != newFocus) {
            if (oldFocus != null && !oldFocus.isDisposed()) {
                oldFocus.sendFocusEvent(16, false);
            }
            if (newFocus != null && !newFocus.isDisposed() && newFocus.isEnabled()) {
                newFocus.sendFocusEvent(15, false);
            }
        }
        if (this.isDisposed()) {
            return false;
        }
        shell.setSavedFocus(this);
        return this.hasFocus();
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.defaultBackground();
        }
        return Color.carbon_new(this.display, this.background);
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rect rect = this.getControlBounds(this.topHandle());
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    int getDrawCount(int control) {
        if (!this.isTrimHandle(control) && this.drawCount > 0) {
            return this.drawCount;
        }
        return this.parent.getDrawCount(control);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.defaultForeground();
        }
        return Color.carbon_new(this.display, this.foreground);
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public org.eclipse.swt.graphics.Point getLocation() {
        this.checkWidget();
        Rect rect = this.getControlBounds(this.topHandle());
        return new org.eclipse.swt.graphics.Point(rect.left, rect.top);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    int getMininumHeight() {
        return 0;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor[] monitors = this.display.getMonitors();
        if (monitors.length == 1) {
            return monitors[0];
        }
        int index = -1;
        int value = -1;
        Rectangle bounds = this.getBounds();
        if (this != this.getShell()) {
            bounds = this.display.map((Control)this.parent, null, bounds);
        }
        int i = 0;
        while (i < monitors.length) {
            Rectangle rect = bounds.intersection(monitors[i].getBounds());
            int area = rect.width * rect.height;
            if (area > 0 && area > value) {
                index = i;
                value = area;
            }
            ++i;
        }
        if (index >= 0) {
            return monitors[index];
        }
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        int i2 = 0;
        while (i2 < monitors.length) {
            int x;
            Rectangle rect = monitors[i2].getBounds();
            int n = centerX < rect.x ? rect.x - centerX : (x = centerX > rect.x + rect.width ? centerX - rect.x - rect.width : 0);
            int y = centerY < rect.y ? rect.y - centerY : (centerY > rect.y + rect.height ? centerY - rect.y - rect.height : 0);
            int distance = x * x + y * y;
            if (index == -1 || distance < value) {
                index = i2;
                value = distance;
            }
            ++i2;
        }
        return monitors[index];
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    float[] getParentBackground() {
        return this.parent.background;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public org.eclipse.swt.graphics.Point getSize() {
        this.checkWidget();
        Rect rect = this.getControlSize(this.topHandle());
        return new org.eclipse.swt.graphics.Point(rect.right - rect.left, rect.bottom - rect.top);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        if (!clipChildren) {
            return super.getVisibleRegion(control, clipChildren);
        }
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(control, this.visibleRgn, clipChildren);
        }
        int result = OS.NewRgn();
        OS.CopyRgn(this.visibleRgn, result);
        return result;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        switch (inRequest) {
            case 0: {
                int[] contentProvided = new int[]{-2};
                if (this.toolTipText != null && this.toolTipText.length() != 0) {
                    char[] buffer = new char[this.toolTipText.length()];
                    this.toolTipText.getChars(0, buffer.length, buffer, 0);
                    int length = this.fixMnemonic(buffer);
                    if (this.display.helpString != 0) {
                        OS.CFRelease(this.display.helpString);
                    }
                    this.display.helpString = OS.CFStringCreateWithCharacters(0, buffer, length);
                    HMHelpContentRec helpContent = new HMHelpContentRec();
                    OS.memcpy(helpContent, ioHelpContent, 534);
                    helpContent.version = 3;
                    int cursorHeight = 16;
                    helpContent.tagSide = (short)23;
                    int x = inGlobalMouse & 0xFFFF;
                    int y = inGlobalMouse >> 16;
                    if (this.display.helpControl != this) {
                        this.display.lastHelpX = x + cursorHeight / 2;
                        this.display.lastHelpY = y + cursorHeight + cursorHeight / 2;
                    }
                    int jitter = 4;
                    int deltaX = Math.abs(this.display.lastHelpX - x) + jitter;
                    int deltaY = Math.abs(this.display.lastHelpY - y) + jitter;
                    x = this.display.lastHelpX - deltaX;
                    y = this.display.lastHelpY - deltaY;
                    int width = deltaX * 2;
                    int height = deltaY * 2;
                    this.display.helpControl = this;
                    helpContent.absHotRect_left = (short)x;
                    helpContent.absHotRect_top = (short)y;
                    helpContent.absHotRect_right = (short)(x + width);
                    helpContent.absHotRect_bottom = (short)(y + height);
                    helpContent.content0_contentType = 1667658612;
                    helpContent.content0_tagCFString = this.display.helpString;
                    helpContent.content1_contentType = 1667658612;
                    helpContent.content1_tagCFString = this.display.helpString;
                    OS.memcpy(ioHelpContent, helpContent, 534);
                    contentProvided[0] = 0;
                }
                OS.memcpy(outContentProvided, contentProvided, 4);
                break;
            }
            case 1: {
                if (this.display.helpString != 0) {
                    OS.CFRelease(this.display.helpString);
                }
                this.display.helpString = 0;
            }
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int controlProc = this.display.controlProc;
        int[] mask = new int[]{1668183148, 9, 1668183148, 5, 1668183148, 154, 1668183148, 13, 1668183148, 12, 1668183148, 10, 1668183148, 4, 1668183148, 1, 1668183148, 11, 1668183148, 7, 1668183148, 8, 1668183148, 51};
        int controlTarget = OS.GetControlEventTarget(this.handle);
        OS.InstallEventHandler(controlTarget, controlProc, mask.length / 2, mask, this.handle, null);
        int helpProc = this.display.helpProc;
        OS.HMInstallControlContentCallback(this.handle, helpProc);
        int colorProc = this.display.colorProc;
        OS.SetControlColorProc(this.handle, colorProc);
    }

    public int internal_new_GC(GCData data) {
        int port;
        this.checkWidget();
        int n = port = data != null ? data.port : 0;
        if (port == 0) {
            int window = OS.GetControlOwner(this.handle);
            port = OS.GetWindowPort(window);
        }
        int[] buffer = new int[1];
        OS.CreateCGContextForPort(port, buffer);
        int context = buffer[0];
        if (context == 0) {
            SWT.error(2);
        }
        int visibleRgn = 0;
        visibleRgn = data != null && data.paintEvent != 0 ? data.visibleRgn : (this.getDrawCount(this.handle) > 0 ? OS.NewRgn() : this.getVisibleRegion(this.handle, true));
        Rect rect = new Rect();
        Rect portRect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        OS.GetPortBounds(port, portRect);
        OS.ClipCGContextToRegion(context, portRect, visibleRgn);
        int portHeight = portRect.bottom - portRect.top;
        OS.CGContextScaleCTM(context, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(context, rect.left, -portHeight + rect.top);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            }
            data.device = this.display;
            data.thread = this.display.thread;
            data.background = this.background != null ? this.background : this.defaultBackground().handle;
            data.foreground = this.foreground != null ? this.foreground : this.defaultForeground().handle;
            data.font = this.font != null ? this.font : this.defaultFont();
            data.visibleRgn = visibleRgn;
            data.control = this.handle;
            data.portRect = portRect;
            data.controlRect = rect;
            if (data.paintEvent == 0) {
                if (this.gcs == null) {
                    this.gcs = new GCData[4];
                }
                int index = 0;
                while (index < this.gcs.length && this.gcs[index] != null) {
                    ++index;
                }
                if (index == this.gcs.length) {
                    GCData[] newGCs = new GCData[this.gcs.length + 4];
                    System.arraycopy(this.gcs, 0, newGCs, 0, this.gcs.length);
                    this.gcs = newGCs;
                }
                this.gcs[index] = data;
            }
        }
        return context;
    }

    public void internal_dispose_GC(int context, GCData data) {
        this.checkWidget();
        if (data != null && data.paintEvent == 0) {
            if (data.visibleRgn != 0) {
                OS.DisposeRgn(data.visibleRgn);
                data.visibleRgn = 0;
            }
            int index = 0;
            while (index < this.gcs.length && this.gcs[index] != data) {
                ++index;
            }
            if (index < this.gcs.length) {
                this.gcs[index] = null;
                index = 0;
                while (index < this.gcs.length && this.gcs[index] == null) {
                    ++index;
                }
                if (index == this.gcs.length) {
                    this.gcs = null;
                }
            }
        }
        OS.CGContextSynchronize(context);
        OS.CGContextRelease(context);
    }

    void invalidateChildrenVisibleRegion(int control) {
    }

    void invalidateVisibleRegion(int control) {
        int index = 0;
        Control[] siblings = this.parent._getChildren();
        while (index < siblings.length && siblings[index] != this) {
            ++index;
        }
        int i = index;
        while (i < siblings.length) {
            Control sibling = siblings[i];
            sibling.resetVisibleRegion(control);
            sibling.invalidateChildrenVisibleRegion(control);
            ++i;
        }
        this.parent.resetVisibleRegion(control);
    }

    void invalWindowRgn(int window, int rgn) {
        this.parent.invalWindowRgn(window, rgn);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isEnabledCursor() {
        return this.isEnabled();
    }

    boolean isEnabledModal() {
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell modal = shells[i];
            if (modal != this && modal.isVisible()) {
                Shell shell;
                if ((modal.style & 0x8000) != 0 && modal.parent == (shell = this.getShell())) {
                    return false;
                }
                int bits = 196608;
                if ((modal.style & bits) != 0) {
                    Control control = this;
                    while (control != null) {
                        if (control == modal) break;
                        control = control.parent;
                    }
                    if (control != modal) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            org.eclipse.swt.graphics.Point size = control.getSize();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, 0)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, 0)) & 0x60) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return OS.IsControlVisible(this.topHandle());
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    int kEventControlContextualMenuClick(int nextHandler, int theEvent, int userData) {
        int sizeof = 4;
        Point pt = new Point();
        OS.GetEventParameter(theEvent, 1835822947, 1363439732, null, sizeof, null, pt);
        Rect rect = new Rect();
        int window = OS.GetControlOwner(this.handle);
        OS.GetWindowBounds(window, (short)33, rect);
        int x = pt.h + rect.left;
        int y = pt.v + rect.top;
        Event event = new Event();
        event.x = x;
        event.y = y;
        this.sendEvent(35, event);
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            if (event.x != x || event.y != y) {
                this.menu.setLocation(event.x, event.y);
            }
            this.menu.setVisible(true);
        }
        return -9874;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        if (!this.isEnabledCursor()) {
            return 0;
        }
        Cursor cursor = null;
        if (this.isEnabledModal() && (cursor = this.findCursor()) != null) {
            this.display.setCursor(cursor.handle);
        }
        return cursor != null ? 0 : -9874;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        this.display.focusCombo = null;
        int result = this.callFocusEventHandler(nextHandler, theEvent);
        if (!this.display.ignoreFocus && result == 0) {
            int window = OS.GetControlOwner(this.handle);
            if (window == OS.GetUserFocusWindow()) {
                int focusHandle = this.focusHandle();
                int[] focusControl = new int[1];
                OS.GetKeyboardFocus(window, focusControl);
                short[] part = new short[1];
                OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
                if (part[0] == 0) {
                    if (focusControl[0] == focusHandle) {
                        this.sendFocusEvent(16, false);
                    }
                } else if (focusControl[0] != focusHandle) {
                    this.sendFocusEvent(15, false);
                }
            }
            if (this.isDisposed()) {
                return 0;
            }
        }
        return result;
    }

    int kEventControlTrack(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        Shell shell = this.getShell();
        short[] button = new short[1];
        OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, button);
        int[] clickCount = new int[1];
        OS.GetEventParameter(theEvent, 1667460724, 1835100014, null, 4, null, clickCount);
        this.sendMouseEvent(3, button[0], 0, 0, false, theEvent);
        if (clickCount[0] == 2) {
            this.sendMouseEvent(8, button[0], 0, 0, false, theEvent);
        }
        if ((this.state & 0x20) != 0) {
            this.display.grabControl = this;
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        if (this.hooks(29)) {
            Point pt = new Point();
            int sizeof = 4;
            OS.GetEventParameter(theEvent, 1835822947, 1363439732, null, sizeof, null, pt);
            this.display.dragMouseStart = pt;
            this.display.dragging = false;
        }
        return -9874;
    }

    int kEventMouseDragged(int nextHandler, int theEvent, int userData) {
        if ((this.state & 2) == 0) {
            if (this.isEnabledModal()) {
                this.sendMouseEvent(5, (short)0, 0, 0, false, theEvent);
            }
            this.display.dragDetect(this);
        }
        return -9874;
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        if (this.isEnabledModal()) {
            this.sendMouseEvent(5, (short)0, 0, 0, false, theEvent);
        }
        return -9874;
    }

    int kEventMouseUp(int nextHandler, int theEvent, int userData) {
        short[] button = new short[1];
        OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, button);
        this.sendMouseEvent(4, button[0], 0, 0, false, theEvent);
        return -9874;
    }

    int kEventMouseWheelMoved(int nextHandler, int theEvent, int userData) {
        if ((this.state & 0x800) != 0) {
            return -9874;
        }
        short[] wheelAxis = new short[1];
        OS.GetEventParameter(theEvent, 1836540280, 1836540280, null, 2, null, wheelAxis);
        int[] wheelDelta = new int[1];
        OS.GetEventParameter(theEvent, 1836541036, 1819242087, null, 4, null, wheelDelta);
        Shell shell = this.getShell();
        Control control = this;
        while (control != null) {
            if (!control.sendMouseEvent(37, (short)0, wheelDelta[0], 1, true, theEvent) || control.sendMouseWheel(wheelAxis[0], wheelDelta[0])) break;
            if (control == this) {
                this.state |= 0x800;
                int result = OS.CallNextEventHandler(nextHandler, theEvent);
                this.state &= 0xFFFFF7FF;
                if (result == 0) break;
            }
            if (control == shell) break;
            control = control.parent;
        }
        return 0;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        if (this.translateTraversal(keyCode[0], keyboardEvent[0])) {
            return 0;
        }
        if (keyCode[0] == 114) {
            Control control = this;
            while (control != null) {
                if (control.hooks(28)) {
                    control.postEvent(28);
                    break;
                }
                control = control.parent;
            }
        }
        if (!this.sendKeyEvent(1, keyboardEvent[0])) {
            return 0;
        }
        return -9874;
    }

    void markLayout(boolean changed, boolean all) {
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public void redraw() {
        this.checkWidget();
        this.redrawWidget(this.handle, false);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        this.redrawWidget(this.handle, x, y, width, height, all);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
    }

    void releaseChild() {
        this.setVisible(this.topHandle(), false);
        this.parent.removeControl(this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
        }
        this.visibleRgn = 0;
        this.menu = null;
        this.parent = null;
        this.layoutData = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    void resetVisibleRegion(int control) {
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
            this.visibleRgn = 0;
        }
        if (this.gcs != null) {
            int visibleRgn = this.getVisibleRegion(this.handle, true);
            int i = 0;
            while (i < this.gcs.length) {
                GCData data = this.gcs[i];
                if (data != null) {
                    data.updateClip = true;
                    OS.CopyRgn(visibleRgn, data.visibleRgn);
                }
                ++i;
            }
            OS.DisposeRgn(visibleRgn);
        }
    }

    void sendFocusEvent(int type, boolean post) {
        Display display = this.display;
        Shell shell = this.getShell();
        display.focusControl = this;
        display.focusEvent = type;
        if (post) {
            this.postEvent(type);
        } else {
            this.sendEvent(type);
        }
        if (!shell.isDisposed()) {
            switch (type) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
        display.focusEvent = 0;
        display.focusControl = null;
    }

    boolean sendMouseEvent(int type, short button, int count, int detail, boolean send, int theEvent) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        int sizeof = 4;
        Point pt = new Point();
        OS.GetEventParameter(theEvent, 1835822947, 1363439732, null, sizeof, null, pt);
        Rect rect = new Rect();
        int window = OS.GetControlOwner(this.handle);
        OS.GetWindowBounds(window, (short)33, rect);
        int x = pt.h - rect.left;
        int y = pt.v - rect.top;
        OS.GetControlBounds(this.handle, rect);
        x -= rect.left;
        y -= rect.top;
        int[] chord = new int[1];
        OS.GetEventParameter(theEvent, 1667788658, 1835100014, null, 4, null, chord);
        int[] modifiers = new int[1];
        OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
        return this.sendMouseEvent(type, button, count, detail, chord[0], (short)x, (short)y, modifiers[0], send);
    }

    boolean sendMouseEvent(int type, short button, int chord, short x, short y, int modifiers, boolean send) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        return this.sendMouseEvent(type, button, 0, 0, chord, x, y, modifiers, send);
    }

    boolean sendMouseEvent(int type, short button, int count, int detail, int chord, short x, short y, int modifiers, boolean send) {
        Event event = new Event();
        switch (button) {
            case 1: {
                event.button = 1;
                break;
            }
            case 2: {
                event.button = 3;
                break;
            }
            case 3: {
                event.button = 2;
                break;
            }
            case 4: {
                event.button = 4;
                break;
            }
            case 5: {
                event.button = 5;
            }
        }
        event.x = x;
        event.y = y;
        event.count = count;
        event.detail = detail;
        this.setInputState(event, type, chord, modifiers);
        this.sendEvent(type, event, send);
        return event.doit;
    }

    boolean sendMouseWheel(short wheelAxis, int wheelDelta) {
        return false;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.background = color != null ? color.handle : null;
        this.setBackground(this.background);
        this.redrawWidget(this.handle, false);
    }

    void setBackground(float[] color) {
        this.setBackground(this.handle, color);
    }

    void setBackground(int control, float[] color) {
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData(control, (short)0, 1718578804, 24, fontStyle, null);
        if (color != null) {
            fontStyle.backColor_red = (short)(color[0] * 65535.0f);
            fontStyle.backColor_green = (short)(color[1] * 65535.0f);
            fontStyle.backColor_blue = (short)(color[2] * 65535.0f);
            fontStyle.flags = (short)(fontStyle.flags | 0x10);
        } else {
            fontStyle.flags = (short)(fontStyle.flags & 0xFFFFFFEF);
        }
        OS.SetControlFontStyle(control, fontStyle);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), true, true, true);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        return this.setBounds(this.topHandle(), x, y, width, height, move, resize, events);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, Math.max(0, rect.width), Math.max(0, rect.height), true, true, true);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        if (!this.isEnabled()) {
            return;
        }
        Point where = new Point();
        OS.GetGlobalMouse(where);
        int[] theWindow = new int[1];
        if (this.display.grabControl == this) {
            theWindow[0] = OS.GetControlOwner(this.handle);
        } else {
            if (OS.FindWindow(where, theWindow) != 3) {
                return;
            }
            if (theWindow[0] == 0) {
                return;
            }
        }
        Rect rect = new Rect();
        OS.GetWindowBounds(theWindow[0], (short)33, rect);
        int[] theControl = new int[1];
        if (this.display.grabControl == this) {
            theControl[0] = this.handle;
        } else {
            Control control;
            Widget widget;
            CGPoint inPoint = new CGPoint();
            inPoint.x = where.h - rect.left;
            inPoint.y = where.v - rect.top;
            int[] theRoot = new int[1];
            OS.GetRootControl(theWindow[0], theRoot);
            OS.HIViewGetSubviewHit(theRoot[0], inPoint, true, theControl);
            int cursorControl = theControl[0];
            while (theControl[0] != 0 && theControl[0] != this.handle) {
                OS.GetSuperControl(theControl[0], theControl);
            }
            if (theControl[0] == 0) {
                return;
            }
            theControl[0] = cursorControl;
            while ((widget = this.display.getWidget(theControl[0])) == null || !(widget instanceof Control) || !(control = (Control)widget).isEnabled()) {
                OS.GetSuperControl(theControl[0], theControl);
                if (theControl[0] != 0) continue;
            }
            if (theControl[0] == 0) {
                theControl[0] = theRoot[0];
                widget = this.display.getWidget(theControl[0]);
                if (widget != null && widget instanceof Control) {
                    control = (Control)widget;
                    theControl[0] = control.handle;
                }
            }
        }
        where.h = (short)(where.h - rect.left);
        where.v = (short)(where.v - rect.top);
        int modifiers = OS.GetCurrentEventKeyModifiers();
        boolean[] cursorWasSet = new boolean[1];
        OS.HandleControlSetCursor(theControl[0], where, (short)modifiers, cursorWasSet);
        if (!cursorWasSet[0]) {
            OS.SetThemeCursor(0);
        }
    }

    void setDefaultFont() {
        if (this.display.smallFonts) {
            this.setFontStyle(this.defaultFont());
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 == enabled) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(enabled);
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        this.setFontStyle(this.display.smallFonts ? (font != null ? font : this.defaultFont()) : font);
        this.redrawWidget(this.handle, false);
    }

    void setFontStyle(Font font) {
        this.setFontStyle(this.handle, font);
    }

    void setFontStyle(int control, Font font) {
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData(control, (short)0, 1718578804, 24, fontStyle, null);
        fontStyle.flags = (short)(fontStyle.flags & 0xFFFFFF78);
        if (font != null) {
            fontStyle.flags = (short)(fontStyle.flags | 7);
            fontStyle.font = font.id;
            fontStyle.style = font.style;
            fontStyle.size = font.size;
        }
        OS.SetControlFontStyle(control, fontStyle);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.foreground = color != null ? color.handle : null;
        this.setForeground(this.foreground);
        this.redrawWidget(this.handle, false);
    }

    void setForeground(float[] color) {
        this.setForeground(this.handle, color);
    }

    void setForeground(int control, float[] color) {
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData(control, (short)0, 1718578804, 24, fontStyle, null);
        if (color != null) {
            fontStyle.foreColor_red = (short)(color[0] * 65535.0f);
            fontStyle.foreColor_green = (short)(color[1] * 65535.0f);
            fontStyle.foreColor_blue = (short)(color[2] * 65535.0f);
            fontStyle.flags = (short)(fontStyle.flags | 8);
        } else {
            fontStyle.flags = (short)(fontStyle.flags & 0xFFFFFFF7);
        }
        OS.SetControlFontStyle(control, fontStyle);
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false, true);
    }

    public void setLocation(org.eclipse.swt.graphics.Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setBounds(location.x, location.y, 0, 0, true, false, true);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                this.invalidateVisibleRegion(this.handle);
                this.redrawWidget(this.handle, true);
            }
        } else {
            if (this.drawCount == 0) {
                this.invalidateVisibleRegion(this.handle);
            }
            ++this.drawCount;
        }
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), false, true, true);
    }

    public void setSize(org.eclipse.swt.graphics.Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, size.x), Math.max(0, size.y), false, true, true);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean fixFocus = false;
        if (!visible && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.setVisible(this.topHandle(), visible);
        if (!visible) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    void setZOrder() {
        int topHandle = this.topHandle();
        int parentHandle = this.parent.handle;
        OS.HIViewAddSubview(parentHandle, topHandle);
        Rect parentRect = new Rect();
        OS.GetControlBounds(parentHandle, parentRect);
        Rect inset = this.getInset();
        Rect newBounds = new Rect();
        newBounds.left = (short)(parentRect.left + inset.left);
        newBounds.top = (short)(parentRect.top + inset.top);
        newBounds.right = (short)(newBounds.left - inset.right - inset.left);
        newBounds.bottom = (short)(newBounds.top - inset.bottom - inset.top);
        if (newBounds.bottom < newBounds.top) {
            newBounds.bottom = newBounds.top;
        }
        if (newBounds.right < newBounds.left) {
            newBounds.right = newBounds.left;
        }
        OS.SetControlBounds(topHandle, newBounds);
    }

    void setZOrder(Control control, boolean above) {
        int otherControl = control == null ? 0 : control.topHandle();
        this.setZOrder(this.topHandle(), otherControl, above);
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    public org.eclipse.swt.graphics.Point toControl(int x, int y) {
        this.checkWidget();
        Rect rect = new Rect();
        int window = OS.GetControlOwner(this.handle);
        OS.GetWindowBounds(window, (short)33, rect);
        Rect inset = this.getInset();
        OS.GetControlBounds(this.handle, rect);
        return new org.eclipse.swt.graphics.Point((x -= rect.left - inset.left) - rect.left, (y -= rect.top - inset.top) - rect.top);
    }

    public org.eclipse.swt.graphics.Point toControl(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public org.eclipse.swt.graphics.Point toDisplay(int x, int y) {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        Rect inset = this.getInset();
        int window = OS.GetControlOwner(this.handle);
        OS.GetWindowBounds(window, (short)33, rect);
        return new org.eclipse.swt.graphics.Point((x += rect.left - inset.left) + rect.left, (y += rect.top - inset.top) + rect.top);
    }

    public org.eclipse.swt.graphics.Point toDisplay(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    int topHandle() {
        return this.handle;
    }

    boolean translateTraversal(int key, int theEvent) {
        int detail = 0;
        int code = this.traversalCode(key, theEvent);
        boolean all = false;
        switch (key) {
            case 53: {
                all = true;
                detail = 2;
                break;
            }
            case 36: {
                all = true;
                detail = 4;
                break;
            }
            case 48: {
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                boolean next = (modifiers[0] & 0x200) == 0;
                detail = next ? 16 : 8;
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                boolean next = key == 125 || key == 124;
                detail = next ? 64 : 32;
                break;
            }
            case 116: 
            case 121: {
                all = true;
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                if ((modifiers[0] & 0x1000) == 0) {
                    return false;
                }
                detail = key == 121 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (code & detail) != 0;
        event.detail = detail;
        if (!this.setKeyState(event, 31, theEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, int theEvent) {
        int code = 28;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean traverseMnemonic(char key) {
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(Event event) {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        if (!this.isDrawing(this.handle)) {
            return;
        }
        int window = OS.GetControlOwner(this.handle);
        int port = OS.GetWindowPort(window);
        int portRgn = OS.NewRgn();
        OS.GetPortVisibleRegion(port, portRgn);
        if (!OS.EmptyRgn(portRgn)) {
            int updateRgn = OS.NewRgn();
            OS.GetWindowRegion(window, (short)34, updateRgn);
            if (!OS.EmptyRgn(updateRgn)) {
                Rect rect = new Rect();
                OS.GetWindowBounds(window, (short)33, rect);
                OS.OffsetRgn(updateRgn, -rect.left, -rect.top);
                OS.SectRgn(portRgn, updateRgn, updateRgn);
                if (!OS.EmptyRgn(updateRgn)) {
                    int visibleRgn = this.getVisibleRegion(this.handle, !all);
                    if (!OS.EmptyRgn(visibleRgn)) {
                        OS.SectRgn(updateRgn, visibleRgn, visibleRgn);
                        if (!OS.EmptyRgn(visibleRgn)) {
                            int[] currentPort = new int[1];
                            OS.GetPort(currentPort);
                            OS.SetPort(port);
                            OS.BeginUpdate(window);
                            OS.DiffRgn(updateRgn, visibleRgn, updateRgn);
                            this.invalWindowRgn(window, updateRgn);
                            OS.UpdateControls(window, visibleRgn);
                            OS.EndUpdate(window);
                            OS.SetPort(currentPort[0]);
                        }
                    }
                    OS.DisposeRgn(visibleRgn);
                }
            }
            OS.DisposeRgn(updateRgn);
        }
        OS.DisposeRgn(portRgn);
    }

    void updateLayout(boolean all) {
    }
}

