/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Compatibility;

public final class Program {
    String name;
    String command;
    String iconName;

    Program() {
    }

    public static Program findProgram(String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = String.valueOf('.') + extension;
        }
        return Program.getProgram(extension);
    }

    public static String[] getExtensions() {
        return new String[]{".xml", ".html", ".java", ".properties", ".jar", ".zip", ".txt", ".jpeg", ".jpg", ".tiff", ".gif", ".png"};
    }

    static Program getProgram(String key) {
        String[] extentions = Program.getExtensions();
        int i = 0;
        while (i < extentions.length) {
            String ext = extentions[i];
            if (ext.equals(key)) break;
            ++i;
        }
        if (i == extentions.length) {
            return null;
        }
        String name = key;
        if (name == null || name.length() == 0) {
            return null;
        }
        String command = "/usr/bin/open %f";
        if (command == null || command.length() == 0) {
            return null;
        }
        String iconName = "icon";
        if (iconName == null || iconName.length() == 0) {
            return null;
        }
        Program program = new Program();
        program.name = name;
        program.command = command;
        program.iconName = iconName;
        return program;
    }

    public static Program[] getPrograms() {
        return new Program[]{Program.getProgram(".html")};
    }

    public static boolean launch(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        String[] args = new String[]{"/usr/bin/open", fileName};
        try {
            Compatibility.exec(args);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    static String[] parseCommand(String cmd) {
        args = new Vector<String>();
        sIndex = 0;
        ** GOTO lbl25
        {
            ++sIndex;
            do {
                if (sIndex < cmd.length() && Compatibility.isWhitespace(cmd.charAt(sIndex))) continue block0;
                if (sIndex >= cmd.length()) continue;
                if (cmd.charAt(sIndex) == '\"' || cmd.charAt(sIndex) == '\'') {
                    eIndex = sIndex + 1;
                    while (eIndex < cmd.length() && cmd.charAt(eIndex) != cmd.charAt(sIndex)) {
                        ++eIndex;
                    }
                    if (eIndex >= cmd.length()) {
                        args.addElement(cmd.substring(sIndex, eIndex));
                    } else {
                        args.addElement(cmd.substring(sIndex + 1, eIndex));
                    }
                    sIndex = eIndex + 1;
                    continue;
                }
                eIndex = sIndex;
                while (eIndex < cmd.length() && !Compatibility.isWhitespace(cmd.charAt(eIndex))) {
                    ++eIndex;
                }
                args.addElement(cmd.substring(sIndex, eIndex));
                sIndex = eIndex + 1;
lbl25:
                // 4 sources

            } while (sIndex < cmd.length());
        }
        result = new String[args.size()];
        args.copyInto(result);
        return result;
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        String[] args = Program.parseCommand(this.command);
        int fileArg = -1;
        int index = 0;
        while (index < args.length) {
            int j = args[index].indexOf("%f");
            if (j != -1) {
                String value = args[index];
                fileArg = index;
                args[index] = String.valueOf(value.substring(0, j)) + fileName + value.substring(j + 2);
            }
            ++index;
        }
        if (fileName.length() > 0 && fileArg < 0) {
            String[] newArgs = new String[args.length + 1];
            index = 0;
            while (index < args.length) {
                newArgs[index] = args[index];
                ++index;
            }
            newArgs[args.length] = fileName;
            args = newArgs;
        }
        try {
            Compatibility.exec(args);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public ImageData getImageData() {
        RGB[] rgbs = new RGB[]{new RGB(255, 255, 255), new RGB(95, 95, 95), new RGB(128, 128, 128), new RGB(192, 192, 192), new RGB(223, 223, 191), new RGB(255, 223, 159), new RGB(0, 0, 0)};
        ImageData data = new ImageData(16, 16, 4, new PaletteData(rgbs));
        data.transparentPixel = 6;
        String[] p = new String[]{"CCCCCCCCGGG", "CFAAAAACBGG", "CAAAAAACFBG", "CAAAAAACBBB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CDDDDDDDDDB", "CBBBBBBBBBB"};
        int y = 0;
        while (y < p.length) {
            int x = 0;
            while (x < 11) {
                data.setPixel(x + 3, y + 1, p[y].charAt(x) - 65);
                ++x;
            }
            ++y;
        }
        return data;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.name.equals(program.name) && this.command.equals(program.command) && this.iconName.equals(program.iconName);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.iconName.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

