/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.ATSTrapezoid;
import org.eclipse.swt.internal.carbon.ATSUCaret;
import org.eclipse.swt.internal.carbon.ATSUTab;
import org.eclipse.swt.internal.carbon.ATSUUnhighlightData;
import org.eclipse.swt.internal.carbon.FontInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int textPtr;
    StyleItem[] styles;
    int layout;
    int spacing;
    int ascent;
    int descent;
    int[] tabs;
    int[] segments;
    int tabsPtr;
    int[] breaks;
    int[] lineX;
    int[] lineWidth;
    int[] lineHeight;
    int[] lineAscent;
    static final int TAB_COUNT = 32;

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        int[] buffer = new int[1];
        OS.ATSUCreateTextLayout(buffer);
        if (buffer[0] == 0) {
            SWT.error(2);
        }
        this.layout = buffer[0];
        this.setLayoutControl(3, 0, 1);
        OS.ATSUSetHighlightingMethod(this.layout, 1, new ATSUUnhighlightData());
        this.descent = -1;
        this.ascent = -1;
        this.text = "";
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        if (this.breaks != null) {
            return;
        }
        int length = this.text.length();
        if (length != 0) {
            int[] values;
            int[] sizes;
            int i = 0;
            while (i < this.styles.length - 1) {
                StyleItem run = this.styles[i];
                run.createStyle(this.font);
                int runLength = this.styles[i + 1].start - run.start;
                OS.ATSUSetRunStyle(this.layout, run.atsuStyle, run.start, runLength);
                ++i;
            }
            int[] buffer = new int[1];
            if (this.ascent != -1) {
                OS.ATSUGetLayoutControl(this.layout, 8, 4, buffer, null);
                int ptr = OS.NewPtr(4);
                buffer[0] = OS.Long2Fix(Math.max(this.ascent, OS.Fix2Long(buffer[0])));
                OS.memcpy(ptr, buffer, 4);
                int[] tags = new int[]{8};
                sizes = new int[]{4};
                values = new int[]{ptr};
                OS.ATSUSetLineControls(this.layout, 0, tags.length, tags, sizes, values);
                OS.DisposePtr(ptr);
            }
            if (this.descent != -1) {
                OS.ATSUGetLayoutControl(this.layout, 9, 4, buffer, null);
                int ptr = OS.NewPtr(4);
                buffer[0] = OS.Long2Fix(Math.max(this.descent, OS.Fix2Long(buffer[0])));
                OS.memcpy(ptr, buffer, 4);
                int[] tags = new int[]{9};
                sizes = new int[]{4};
                values = new int[]{ptr};
                OS.ATSUSetLineControls(this.layout, 0, tags.length, tags, sizes, values);
                OS.DisposePtr(ptr);
            }
            OS.ATSUGetLayoutControl(this.layout, 1, 4, buffer, null);
            int wrapWidth = OS.Fix2Long(buffer[0]);
            int width = wrapWidth == 0 ? Short.MAX_VALUE : wrapWidth;
            OS.ATSUBatchBreakLines(this.layout, 0, -1, OS.Long2Fix(width), buffer);
            int count = Math.max(0, buffer[0]);
            this.breaks = new int[count + 1];
            OS.ATSUGetSoftLineBreaks(this.layout, 0, -1, count, this.breaks, buffer);
            this.breaks[count] = length;
        } else {
            this.breaks = new int[1];
        }
        int lineCount = this.breaks.length;
        this.lineX = new int[lineCount];
        this.lineWidth = new int[lineCount];
        this.lineHeight = new int[lineCount];
        this.lineAscent = new int[lineCount];
        if (length != 0) {
            ATSTrapezoid trapezoid = new ATSTrapezoid();
            int i = 0;
            int start = 0;
            while (i < lineCount) {
                int lineBreak = this.breaks[i];
                int lineLength = this.skipHardBreak(lineBreak) - start;
                OS.ATSUGetGlyphBounds(this.layout, 0, 0, start, lineLength == 0 ? 1 : lineLength, (short)1, 1, trapezoid, null);
                this.lineX[i] = OS.Fix2Long(trapezoid.lowerLeft_x);
                this.lineAscent[i] = -OS.Fix2Long(trapezoid.upperRight_y);
                if (lineLength != 0) {
                    this.lineWidth[i] = OS.Fix2Long(trapezoid.upperRight_x) - OS.Fix2Long(trapezoid.upperLeft_x);
                }
                this.lineHeight[i] = OS.Fix2Long(trapezoid.lowerRight_y) + this.lineAscent[i];
                start = lineBreak;
                ++i;
            }
        }
    }

    public void dispose() {
        if (this.layout == 0) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.styles = null;
        if (this.layout != 0) {
            OS.ATSUDisposeTextLayout(this.layout);
        }
        this.layout = 0;
        if (this.textPtr != 0) {
            OS.DisposePtr(this.textPtr);
        }
        this.textPtr = 0;
        if (this.tabsPtr != 0) {
            OS.DisposePtr(this.tabsPtr);
        }
        this.tabsPtr = 0;
        this.device = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        int[] response;
        int err;
        int length;
        this.checkLayout();
        this.computeRuns();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        if ((length = this.text.length()) == 0) {
            return;
        }
        this.setLayoutControl(Short.MAX_VALUE, gc.handle, 4);
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        OS.CGContextSaveGState(gc.handle);
        boolean restoreColor = false;
        if (hasSelection && selectionBackground != null && (err = OS.Gestalt(1937339254, response = new int[1])) == 0 && (response[0] & 0xFFFF) >= 4144) {
            restoreColor = true;
            int color = OS.CGColorCreate(this.device.colorspace, selectionBackground.handle);
            this.setLayoutControl(17, color, 4);
            OS.CGColorRelease(color);
        }
        Rectangle rect = null;
        Region clipping = null;
        Region region = null;
        int j = 0;
        while (j < this.styles.length) {
            StyleItem run = this.styles[j];
            if (run.style != null && run.style.background != null) {
                OS.CGContextSetFillColor(gc.handle, run.style.background.handle);
                if (clipping == null) {
                    region = new Region();
                    clipping = new Region();
                    gc.getClipping(clipping);
                    rect = clipping.getBounds();
                }
                int start = run.start;
                int end = j + 1 < this.styles.length ? this.styles[j + 1].start - 1 : length;
                int i = 0;
                int lineStart = 0;
                int lineY = 0;
                while (i < this.breaks.length) {
                    int lineBreak = this.breaks[i];
                    int lineEnd = lineBreak - 1;
                    if (start <= lineEnd && end >= lineStart) {
                        int highStart = Math.max(lineStart, start);
                        int highEnd = Math.min(lineEnd, end);
                        int highLen = this.skipHardBreak(highEnd) - highStart + 1;
                        if (highLen > 0) {
                            OS.ATSUGetTextHighlight(this.layout, this.lineX[i], lineY, highStart, highLen, region.handle);
                            OS.OffsetRgn(region.handle, (short)0, (short)(lineY + this.lineAscent[i]));
                            OS.OffsetRgn(region.handle, (short)x, (short)y);
                            region.intersect(clipping);
                            gc.setClipping(region);
                            gc.fillRectangle(rect);
                        }
                    }
                    if (lineEnd > end) break;
                    lineY += this.lineHeight[i];
                    lineStart = lineBreak;
                    ++i;
                }
            }
            ++j;
        }
        if (clipping != null) {
            gc.setClipping(clipping);
            OS.CGContextRestoreGState(gc.handle);
            OS.CGContextSaveGState(gc.handle);
            clipping.dispose();
            region.dispose();
        }
        OS.CGContextScaleCTM(gc.handle, 1.0f, -1.0f);
        OS.CGContextSetFillColor(gc.handle, gc.data.foreground);
        int drawX = OS.Long2Fix(x);
        int drawY = y;
        int i = 0;
        int start = 0;
        while (i < this.breaks.length) {
            int lineBreak = this.breaks[i];
            int lineLength = this.skipHardBreak(lineBreak) - start;
            if (lineLength > 0) {
                int fixYDraw = OS.Long2Fix(-(drawY + this.lineAscent[i]));
                OS.ATSUDrawText(this.layout, start, lineLength, drawX, fixYDraw);
                int end = start + lineLength - 1;
                if (hasSelection && selectionStart <= end && start <= selectionEnd) {
                    int selStart = Math.max(selectionStart, start);
                    int selEnd = Math.min(selectionEnd, end);
                    OS.ATSUHighlightText(this.layout, drawX, fixYDraw, selStart, selEnd - selStart + 1);
                }
            }
            drawY += this.lineHeight[i];
            start = lineBreak;
            ++i;
        }
        if (restoreColor) {
            this.setLayoutControl(17, 0, 4);
        }
        OS.CGContextRestoreGState(gc.handle);
    }

    void freeRuns() {
        if (this.breaks == null) {
            return;
        }
        int i = 0;
        while (i < this.styles.length) {
            StyleItem run = this.styles[i];
            run.freeStyle();
            ++i;
        }
        this.lineAscent = null;
        this.lineHeight = null;
        this.lineWidth = null;
        this.lineX = null;
        this.breaks = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int[] buffer = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 5, 4, buffer, null);
        switch (buffer[0]) {
            case 0x20000000: {
                return 0x1000000;
            }
            case 0x40000000: {
                return 131072;
            }
        }
        return 16384;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < this.breaks.length) {
            width = Math.max(width, this.lineWidth[i]);
            height += this.lineHeight[i];
            ++i;
        }
        int[] buffer = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 1, 4, buffer, null);
        int wrapWidth = OS.Fix2Long(buffer[0]);
        if (wrapWidth != 0) {
            width = Math.max(width, wrapWidth);
        }
        return new Rectangle(0, 0, width, height);
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int rgn = OS.NewRgn();
        Rect rect = new Rect();
        Rect rect1 = new Rect();
        int i = 0;
        int lineStart = 0;
        int lineY = 0;
        while (i < this.breaks.length) {
            int lineBreak = this.breaks[i];
            int lineEnd = lineBreak - 1;
            if (start <= lineEnd && end >= lineStart) {
                int highStart = Math.max(lineStart, start);
                int highEnd = Math.min(lineEnd, end);
                int highLen = this.skipHardBreak(highEnd) - highStart + 1;
                if (highLen > 0) {
                    OS.ATSUGetTextHighlight(this.layout, this.lineX[i], lineY, highStart, highLen, rgn);
                    OS.GetRegionBounds(rgn, rect1);
                    OS.OffsetRect(rect1, (short)0, (short)(lineY + this.lineAscent[i]));
                    OS.UnionRect(rect, rect1, rect);
                }
            }
            if (lineEnd > end) break;
            lineY += this.lineHeight[i];
            lineStart = lineBreak;
            ++i;
        }
        OS.DisposeRgn(rgn);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        int level = 0;
        return level;
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int[] offsets = new int[this.breaks.length + 1];
        System.arraycopy(this.breaks, 0, offsets, 1, this.breaks.length);
        return offsets;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(5);
        }
        int i = 0;
        while (i < this.breaks.length - 1) {
            int lineBreak = this.breaks[i];
            if (lineBreak > offset) {
                return i;
            }
            ++i;
        }
        return this.breaks.length - 1;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        int lineCount = this.breaks.length;
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error(6);
        }
        int lineY = 0;
        int i = 0;
        while (i < lineIndex) {
            lineY += this.lineHeight[i];
            ++i;
        }
        return new Rectangle(this.lineX[lineIndex], lineY, this.lineWidth[lineIndex], this.lineHeight[lineIndex]);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return this.breaks.length;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        int length;
        this.checkLayout();
        this.computeRuns();
        int lineCount = this.breaks.length;
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error(6);
        }
        if ((length = this.text.length()) == 0) {
            Font font = this.font != null ? this.font : this.device.getSystemFont();
            FontInfo info = new FontInfo();
            OS.FetchFontInfo(font.id, font.size, font.style, info);
            short ascent = info.ascent;
            short descent = info.descent;
            short leading = info.leading;
            return FontMetrics.carbon_new(ascent, descent, 0, leading, ascent + leading + descent);
        }
        int start = lineIndex == 0 ? 0 : this.breaks[lineIndex - 1];
        int lineLength = this.breaks[lineIndex] - start;
        int[] ascent = new int[1];
        int[] descent = new int[1];
        OS.ATSUGetUnjustifiedBounds(this.layout, start, lineLength, null, null, ascent, descent);
        int height = OS.Fix2Long(ascent[0]) + OS.Fix2Long(descent[0]);
        return FontMetrics.carbon_new(OS.Fix2Long(ascent[0]), OS.Fix2Long(descent[0]), 0, 0, height);
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (length == 0) {
            return new Point(0, 0);
        }
        int lineY = 0;
        int i = 0;
        while (i < this.breaks.length - 1) {
            int lineBreak = this.breaks[i];
            if (lineBreak > offset) break;
            lineY += this.lineHeight[i];
            ++i;
        }
        if (offset != length && this.text.charAt(offset) != '\n' && trailing) {
            ++offset;
        }
        ATSUCaret caret = new ATSUCaret();
        OS.ATSUOffsetToPosition(this.layout, offset, !trailing, caret, null, null);
        return new Point(Math.min(OS.Fix2Long(caret.fX), OS.Fix2Long(caret.fDeltaX)), lineY);
    }

    public int getNextOffset(int offset, int movement) {
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int[] newOffset;
        block10: {
            int type;
            block9: {
                this.checkLayout();
                this.computeRuns();
                int length = this.text.length();
                if (offset < 0 || offset > length) {
                    SWT.error(6);
                }
                if (length == 0) {
                    return 0;
                }
                newOffset = new int[1];
                type = 0;
                switch (movement) {
                    case 2: {
                        type = 3;
                        break;
                    }
                    case 4: {
                        type = 2;
                    }
                }
                if (!forward) break block9;
                OS.ATSUNextCursorPosition(this.layout, offset, type, newOffset);
                if (movement != 4) break block10;
                while (newOffset[0] < length && Compatibility.isWhitespace(this.text.charAt(newOffset[0]))) {
                    newOffset[0] = newOffset[0] + 1;
                }
                break block10;
            }
            OS.ATSUPreviousCursorPosition(this.layout, offset, type, newOffset);
            if (movement == 4) {
                while (newOffset[0] > 0 && !Compatibility.isWhitespace(this.text.charAt(newOffset[0] - 1))) {
                    newOffset[0] = newOffset[0] - 1;
                }
            }
        }
        return newOffset[0];
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        this.computeRuns();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        int length;
        this.checkLayout();
        this.computeRuns();
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        if ((length = this.text.length()) == 0) {
            return 0;
        }
        int lineY = 0;
        int start = 0;
        int i = 0;
        while (i < this.breaks.length - 1) {
            int lineBreak = this.breaks[i];
            int height = this.lineHeight[i];
            if (lineY + height > y) break;
            lineY += height;
            start = lineBreak;
            ++i;
        }
        int[] offset = new int[]{start};
        boolean[] leading = new boolean[1];
        OS.ATSUPositionToOffset(this.layout, OS.Long2Fix(x), OS.Long2Fix(y - lineY), offset, leading, null);
        if (trailing != null) {
            int n = trailing[0] = leading[0] ? 0 : 1;
        }
        if (!leading[0]) {
            offset[0] = offset[0] - 1;
        }
        return offset[0];
    }

    public int getOrientation() {
        this.checkLayout();
        int[] lineDir = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 3, 1, lineDir, null);
        return lineDir[0] == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int index, int movement) {
        return this._getOffset(index, movement, false);
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i = 1;
        while (i < this.styles.length) {
            StyleItem item = this.styles[i];
            if (item.start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        int[] buffer = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 1, 4, buffer, null);
        int wrapWidth = OS.Fix2Long(buffer[0]);
        return wrapWidth == 0 ? -1 : wrapWidth;
    }

    public boolean isDisposed() {
        return this.layout == 0;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if (alignment == this.getAlignment()) {
            return;
        }
        this.freeRuns();
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        int align = 0;
        switch (alignment) {
            case 0x1000000: {
                align = 0x20000000;
                break;
            }
            case 131072: {
                align = 0x40000000;
            }
        }
        this.setLayoutControl(5, align, 4);
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    void setLayoutControl(int tag, int value, int size) {
        Object[] buffer;
        int ptr1 = OS.NewPtr(size);
        if (size == 1) {
            buffer = new byte[]{(byte)value};
            OS.memcpy(ptr1, buffer, size);
        } else {
            buffer = new int[1];
            buffer[0] = value;
            OS.memcpy(ptr1, (int[])buffer, size);
        }
        int[] tags = new int[]{tag};
        int[] sizes = new int[]{size};
        int[] values = new int[]{ptr1};
        OS.ATSUSetLayoutControls(this.layout, tags.length, tags, sizes, values);
        OS.DisposePtr(ptr1);
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (orientation == this.getOrientation()) {
            return;
        }
        this.freeRuns();
        int lineDir = 0;
        if (orientation == 0x4000000) {
            lineDir = 1;
        }
        this.setLayoutControl(3, lineDir, 1);
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.spacing == spacing) {
            return;
        }
        this.spacing = spacing;
    }

    /*
     * Unable to fully structure code
     */
    public void setStyle(TextStyle style, int start, int end) {
        block13: {
            this.checkLayout();
            length = this.text.length();
            if (length == 0) {
                return;
            }
            if (start > end) {
                return;
            }
            start = Math.min(Math.max(0, start), length - 1);
            end = Math.min(Math.max(0, end), length - 1);
            low = -1;
            high = this.styles.length;
            while (high - low > 1) {
                index = (high + low) / 2;
                if (start <= this.styles[index].start) {
                    high = index;
                    continue;
                }
                low = index;
            }
            if (high >= 0 && high < this.styles.length) {
                item = this.styles[high];
                if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style) != false)) {
                    return;
                }
            }
            this.freeRuns();
            count = 0;
            newStyles = new StyleItem[this.styles.length + 2];
            i = 0;
            while (i < this.styles.length) {
                item = this.styles[i];
                if (item.start >= start) break;
                newStyles[count++] = item;
                ++i;
            }
            newItem = new StyleItem();
            newItem.start = start;
            newItem.style = style;
            newStyles[count++] = newItem;
            if (this.styles[i].start <= end) ** GOTO lbl45
            newItem = new StyleItem();
            newItem.start = end + 1;
            newItem.style = this.styles[i - 1].style;
            newStyles[count++] = newItem;
            break block13;
lbl-1000:
            // 1 sources

            {
                item = this.styles[i];
                if (item.start > end) break;
                ++i;
lbl45:
                // 2 sources

                ** while (i < this.styles.length)
            }
lbl46:
            // 2 sources

            if (end != this.styles[i].start - 1) {
                this.styles[--i].start = end + 1;
            }
        }
        while (i < this.styles.length) {
            item = this.styles[i];
            if (item.start > end) {
                newStyles[count++] = item;
            }
            ++i;
        }
        if (newStyles.length != count) {
            this.styles = new StyleItem[count];
            System.arraycopy(newStyles, 0, this.styles, 0, count);
        } else {
            this.styles = newStyles;
        }
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i = 0;
            while (i < tabs.length) {
                if (this.tabs[i] != tabs[i]) break;
                ++i;
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = tabs;
        if (this.tabsPtr != 0) {
            OS.DisposePtr(this.tabsPtr);
        }
        this.tabsPtr = 0;
        if (tabs == null) {
            OS.ATSUSetTabArray(this.layout, 0, 0);
        } else {
            int width;
            ATSUTab tab = new ATSUTab();
            tab.tabPosition = OS.Long2Fix(0);
            int length = Math.max(32, tabs.length);
            int ptr = this.tabsPtr = OS.NewPtr(6 * length);
            int i = 0;
            int offset = ptr;
            while (i < tabs.length) {
                tab.tabType = 0;
                tab.tabPosition += OS.Long2Fix(tabs[i]);
                OS.memcpy(offset, tab, 6);
                ++i;
                offset += 6;
            }
            int n = width = i - 2 >= 0 ? tabs[i - 1] - tabs[i - 2] : tabs[i - 1];
            if (width > 0) {
                while (i < length) {
                    tab.tabType = 0;
                    tab.tabPosition += OS.Long2Fix(width);
                    OS.memcpy(offset, tab, 6);
                    ++i;
                    offset += 6;
                }
            }
            OS.ATSUSetTabArray(this.layout, ptr, i);
        }
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        int length = text.length();
        if (length != 0) {
            char[] chars = new char[length];
            text.getChars(0, length, chars, 0);
            this.textPtr = OS.NewPtr(length * 2);
            OS.memcpy(this.textPtr, chars, length * 2);
            OS.ATSUSetTextPointerLocation(this.layout, this.textPtr, 0, length, length);
            OS.ATSUSetTransientFontMatching(this.layout, true);
        }
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[this.styles.length - 1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (width == this.getWidth()) {
            return;
        }
        this.freeRuns();
        this.setLayoutControl(1, OS.Long2Fix(Math.max(0, width)), 4);
    }

    int skipHardBreak(int lineBreak) {
        return lineBreak;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int atsuStyle;

        StyleItem() {
        }

        void createStyle(Font defaultFont) {
            int ptr;
            if (this.atsuStyle != 0) {
                return;
            }
            int[] buffer = new int[1];
            OS.ATSUCreateStyle(buffer);
            this.atsuStyle = buffer[0];
            if (this.atsuStyle == 0) {
                SWT.error(2);
            }
            int length = 0;
            int ptrLength = 0;
            int index = 0;
            Font font = null;
            Color foreground = null;
            if (this.style != null) {
                font = this.style.font;
                foreground = this.style.foreground;
                if (this.style.underline) {
                    ++length;
                    ++ptrLength;
                }
                if (this.style.strikeout) {
                    ++length;
                    ++ptrLength;
                }
            }
            if (font == null) {
                font = defaultFont;
            }
            boolean synthesize = false;
            if (font != null) {
                length += 2;
                ptrLength += 8;
                short[] realStyle = new short[1];
                OS.FMGetFontFromFontFamilyInstance(font.id, font.style, buffer, realStyle);
                boolean bl = synthesize = font.style != realStyle[0];
                if (synthesize) {
                    length += 2;
                    ptrLength += 2;
                }
            }
            if (foreground != null) {
                ++length;
                ptrLength += 6;
            }
            byte[] buffer1 = new byte[1];
            int[] tags = new int[length];
            int[] sizes = new int[length];
            int[] values = new int[length];
            int ptr1 = ptr = OS.NewPtr(ptrLength);
            if (font != null) {
                buffer[0] = font.handle;
                tags[index] = 261;
                sizes[index] = 4;
                values[index] = ptr1;
                OS.memcpy(values[index], buffer, sizes[index]);
                ptr1 += sizes[index];
                buffer[0] = OS.X2Fix(font.size);
                tags[++index] = 262;
                sizes[index] = 4;
                values[index] = ptr1;
                OS.memcpy(values[index], buffer, sizes[index]);
                ptr1 += sizes[index];
                ++index;
                if (synthesize) {
                    buffer1[0] = (font.style & 2) != 0 ? (byte)1 : 0;
                    tags[index] = 257;
                    sizes[index] = 1;
                    values[index] = ptr1;
                    OS.memcpy(values[index], buffer1, sizes[index]);
                    ptr1 += sizes[index];
                    buffer1[0] = (font.style & 1) != 0 ? (byte)1 : 0;
                    tags[++index] = 256;
                    sizes[index] = 1;
                    values[index] = ptr1;
                    OS.memcpy(values[index], buffer1, sizes[index]);
                    ptr1 += sizes[index];
                    ++index;
                }
            }
            if (this.style != null && this.style.underline) {
                buffer1[0] = 1;
                tags[index] = 258;
                sizes[index] = 1;
                values[index] = ptr1;
                OS.memcpy(values[index], buffer1, sizes[index]);
                ptr1 += sizes[index];
                ++index;
            }
            if (this.style != null && this.style.strikeout) {
                buffer1[0] = 1;
                tags[index] = 292;
                sizes[index] = 1;
                values[index] = ptr1;
                OS.memcpy(values[index], buffer1, sizes[index]);
                ptr1 += sizes[index];
                ++index;
            }
            if (foreground != null) {
                RGBColor rgb = new RGBColor();
                float[] color = foreground.handle;
                rgb.red = (short)(color[0] * 65535.0f);
                rgb.green = (short)(color[1] * 65535.0f);
                rgb.blue = (short)(color[2] * 65535.0f);
                tags[index] = 263;
                sizes[index] = 6;
                values[index] = ptr1;
                OS.memcpy(values[index], rgb, sizes[index]);
                ptr1 += sizes[index];
                ++index;
            }
            OS.ATSUSetAttributes(this.atsuStyle, tags.length, tags, sizes, values);
            OS.DisposePtr(ptr);
        }

        void freeStyle() {
            if (this.atsuStyle == 0) {
                return;
            }
            OS.ATSUDisposeStyle(this.atsuStyle);
            this.atsuStyle = 0;
        }
    }
}

