/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.ATSLayoutRecord;
import org.eclipse.swt.internal.carbon.CGPathElement;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;

public class Path
extends Resource {
    public int handle;
    float originX;
    float originY;
    float[] point = new float[2];
    boolean first;
    CGPathElement element;
    int count;
    int typeCount;
    byte[] types;
    float[] points;

    public Path(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = OS.CGPathCreateMutable();
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float[] cmt = new float[6];
        OS.CGAffineTransformMake(width / 2.0f, 0.0f, 0.0f, height / 2.0f, x + width / 2.0f, y + height / 2.0f, cmt);
        OS.CGPathAddArc(this.handle, cmt, 0.0f, 0.0f, 1.0f, -startAngle * (float)Compatibility.PI / 180.0f, -(startAngle + arcAngle) * (float)Compatibility.PI / 180.0f, true);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        OS.CGPathAddPath(this.handle, null, path.handle);
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        CGRect rect = new CGRect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        OS.CGPathAddRect(this.handle, null, rect);
    }

    int newPathProc(int data) {
        this.first = true;
        return 0;
    }

    int closePathProc(int data) {
        this.first = true;
        return 0;
    }

    int lineProc(int pt1, int pt2, int data) {
        if (this.first) {
            this.first = false;
            OS.memcpy(this.point, pt1, 8);
            OS.CGPathMoveToPoint(this.handle, null, this.originX + this.point[0], this.originY + this.point[1]);
        }
        OS.memcpy(this.point, pt2, 8);
        OS.CGPathAddLineToPoint(this.handle, null, this.originX + this.point[0], this.originY + this.point[1]);
        return 0;
    }

    int curveProc(int pt1, int controlPt, int pt2, int data) {
        if (this.first) {
            this.first = false;
            OS.memcpy(this.point, pt1, 8);
            OS.CGPathMoveToPoint(this.handle, null, this.originX + this.point[0], this.originY + this.point[1]);
        }
        OS.memcpy(this.point, pt2, 8);
        float x2 = this.point[0];
        float y2 = this.point[1];
        OS.memcpy(this.point, controlPt, 8);
        OS.CGPathAddQuadCurveToPoint(this.handle, null, this.originX + this.point[0], this.originY + this.point[1], this.originX + x2, this.originY + y2);
        return 0;
    }

    public void addString(String string, float x, float y, Font font) {
        int style;
        Callback closePathCallback;
        int closePathProc;
        Callback curveCallback;
        int curveProc;
        Callback lineCallback;
        int lineProc;
        int length;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        if ((length = string.length()) == 0) {
            return;
        }
        Callback newPathCallback = new Callback(this, "newPathProc", 1);
        int newPathProc = newPathCallback.getAddress();
        if (newPathProc == 0) {
            SWT.error(3);
        }
        if ((lineProc = (lineCallback = new Callback(this, "lineProc", 3)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((curveProc = (curveCallback = new Callback(this, "curveProc", 4)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((closePathProc = (closePathCallback = new Callback(this, "closePathProc", 1)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((style = font.atsuiStyle) == 0) {
            style = font.createStyle();
        }
        if (style == 0) {
            SWT.error(2);
        }
        int[] buffer = new int[1];
        OS.ATSUCreateTextLayout(buffer);
        if (buffer[0] == 0) {
            SWT.error(2);
        }
        int layout = buffer[0];
        char[] chars = new char[length];
        string.getChars(0, length, chars, 0);
        int textPtr = OS.NewPtr(length * 2);
        if (textPtr == 0) {
            SWT.error(2);
        }
        OS.memcpy(textPtr, chars, length * 2);
        OS.ATSUSetTextPointerLocation(layout, textPtr, 0, length, length);
        OS.ATSUSetRunStyle(layout, style, 0, length);
        OS.ATSUSetTransientFontMatching(layout, true);
        int[] ascent = new int[1];
        int[] descent = new int[1];
        OS.ATSUGetUnjustifiedBounds(layout, 0, length, null, null, ascent, descent);
        y = (float)((double)y + OS.Fix2X(ascent[0]));
        int[] layoutRecords = new int[1];
        int[] numRecords = new int[1];
        int[] deltaYs = new int[1];
        int[] numDeltaYs = new int[1];
        OS.ATSUDirectGetLayoutDataArrayPtrFromTextLayout(layout, 0, 100, layoutRecords, numRecords);
        OS.ATSUDirectGetLayoutDataArrayPtrFromTextLayout(layout, 0, 1, deltaYs, numDeltaYs);
        int[] deltaY = new int[1];
        int[] status = new int[1];
        ATSLayoutRecord record = new ATSLayoutRecord();
        int i = 0;
        while (i < numRecords[0]) {
            OS.memcpy(record, layoutRecords[0] + i * 14, 14);
            this.originX = x + (float)OS.Fix2X(record.realPos);
            if (deltaYs[0] == 0) {
                this.originY = y;
            } else {
                OS.memcpy(deltaY, deltaYs[0] + i * 4, 4);
                this.originY = y - (float)OS.Fix2X(deltaY[0]);
            }
            this.first = true;
            if (record.glyphID != 65535) {
                OS.ATSUGlyphGetQuadraticPaths(style, record.glyphID, newPathProc, lineProc, curveProc, closePathProc, 0, status);
            }
            ++i;
        }
        OS.CGPathCloseSubpath(this.handle);
        if (deltaYs[0] != 0) {
            OS.ATSUDirectReleaseLayoutDataArrayPtr(0, 1, deltaYs[0]);
        }
        OS.ATSUDirectReleaseLayoutDataArrayPtr(0, 100, layoutRecords[0]);
        if (style != font.atsuiStyle) {
            OS.ATSUDisposeStyle(style);
        }
        if (layout != 0) {
            OS.ATSUDisposeTextLayout(layout);
        }
        if (textPtr != 0) {
            OS.DisposePtr(textPtr);
        }
        newPathCallback.dispose();
        lineCallback.dispose();
        curveCallback.dispose();
        closePathCallback.dispose();
    }

    int applierFunc(int info, int elementPtr) {
        OS.memcpy(this.element, elementPtr, 8);
        int type = 0;
        int length = 1;
        switch (this.element.type) {
            case 0: {
                type = 1;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 3;
                length = 2;
                break;
            }
            case 3: {
                type = 4;
                length = 3;
                break;
            }
            case 4: {
                type = 5;
                length = 0;
            }
        }
        if (this.types != null) {
            this.types[this.typeCount] = (byte)type;
            if (length > 0) {
                OS.memcpy(this.point, this.element.points, length * 8);
                System.arraycopy(this.point, 0, this.points, this.count, length * 2);
            }
        }
        ++this.typeCount;
        this.count += length * 2;
        return 0;
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathCloseSubpath(this.handle);
    }

    public boolean contains(float x, float y, GC gc, boolean outline) {
        int pixel;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if ((pixel = OS.NewPtr(4)) == 0) {
            SWT.error(2);
        }
        int[] buffer = new int[]{-1};
        OS.memcpy(pixel, buffer, 4);
        int context = OS.CGBitmapContextCreate(pixel, 1, 1, 8, 4, this.device.colorspace, 6);
        if (context == 0) {
            OS.DisposePtr(pixel);
            SWT.error(2);
        }
        GCData data = gc.data;
        OS.CGContextSetLineCap(context, data.lineCap);
        OS.CGContextSetLineJoin(context, data.lineJoin);
        OS.CGContextSetLineWidth(context, data.lineWidth);
        OS.CGContextTranslateCTM(context, -x + 0.5f, -y + 0.5f);
        OS.CGContextAddPath(context, this.handle);
        if (outline) {
            OS.CGContextStrokePath(context);
        } else if (data.fillRule == 2) {
            OS.CGContextFillPath(context);
        } else {
            OS.CGContextEOFillPath(context);
        }
        OS.CGContextRelease(context);
        OS.memcpy(buffer, pixel, 4);
        OS.DisposePtr(pixel);
        return buffer[0] != -1;
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathAddCurveToPoint(this.handle, null, cx1, cy1, cx2, cy2, x, y);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        OS.CGPathRelease(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getBounds(float[] bounds) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (bounds.length < 4) {
            SWT.error(5);
        }
        CGRect rect = new CGRect();
        OS.CGPathGetBoundingBox(this.handle, rect);
        bounds[0] = rect.x;
        bounds[1] = rect.y;
        bounds[2] = rect.width;
        bounds[3] = rect.height;
    }

    public void getCurrentPoint(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        CGPoint pt = new CGPoint();
        OS.CGPathGetCurrentPoint(this.handle, pt);
        point[0] = pt.x;
        point[1] = pt.y;
    }

    public PathData getPathData() {
        Callback callback;
        int proc;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if ((proc = (callback = new Callback(this, "applierFunc", 2)).getAddress()) == 0) {
            SWT.error(3);
        }
        this.typeCount = 0;
        this.count = 0;
        this.element = new CGPathElement();
        OS.CGPathApply(this.handle, 0, proc);
        this.types = new byte[this.typeCount];
        this.points = new float[this.count];
        this.point = new float[6];
        this.typeCount = 0;
        this.count = 0;
        OS.CGPathApply(this.handle, 0, proc);
        callback.dispose();
        PathData result = new PathData();
        result.types = this.types;
        result.points = this.points;
        this.element = null;
        this.types = null;
        this.points = null;
        this.point = null;
        return result;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathAddLineToPoint(this.handle, null, x, y);
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathMoveToPoint(this.handle, null, x, y);
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathAddQuadCurveToPoint(this.handle, null, cx, cy, x, y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

