/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.io.File;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String HFS = "hfs ";
    private static final String FURL = "furl";
    private static final int HFSID = FileTransfer.registerType("hfs ");
    private static final int FURLID = FileTransfer.registerType("furl");

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        files = (String[])object;
        transferData.result = -1;
        data = new byte[files.length][];
        i = 0;
        while (true) {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            if (i >= data.length) {
                                transferData.data = data;
                                transferData.result = 0;
                                return;
                            }
                            file = new File(files[i]);
                            isDirectory = file.isDirectory();
                            fileName = files[i];
                            chars = new char[fileName.length()];
                            fileName.getChars(0, chars.length, chars, 0);
                            cfstring = OS.CFStringCreateWithCharacters(0, chars, chars.length);
                            if (cfstring == 0) {
                                return;
                            }
                            try {
                                url = OS.CFURLCreateWithFileSystemPath(0, cfstring, 0, isDirectory);
                                if (url == 0) {
                                    var21_22 = null;
                                    break block21;
                                }
                                try {
                                    if (transferData.type != FileTransfer.HFSID) ** GOTO lbl56
                                    fsRef = new byte[80];
                                    if (!OS.CFURLGetFSRef(url, fsRef)) {
                                        var19_21 = null;
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Throwable var20_24) {
                                    var19_21 = null;
                                    OS.CFRelease(url);
                                    throw var20_24;
                                }
                                OS.CFRelease(url);
                                break block22;
lbl-1000:
                                // 1 sources

                                {
                                    fsSpec = new byte[70];
                                    if (OS.FSGetCatalogInfo(fsRef, 0, null, null, fsSpec, null) == 0) ** GOTO lbl-1000
                                    var19_21 = null;
                                }
                                OS.CFRelease(url);
                                break block23;
lbl-1000:
                                // 1 sources

                                {
                                    hfsflavor = new byte[10 + fsSpec.length];
                                    finfo = new byte[16];
                                    OS.FSpGetFInfo(fsSpec, finfo);
                                    System.arraycopy(finfo, 0, hfsflavor, 0, 10);
                                    System.arraycopy(fsSpec, 0, hfsflavor, 10, fsSpec.length);
                                    data[i] = hfsflavor;
lbl56:
                                    // 2 sources

                                    if (transferData.type != FileTransfer.FURLID) ** GOTO lbl81
                                    encoding = OS.CFStringGetSystemEncoding();
                                    theData = OS.CFURLCreateData(0, url, encoding, true);
                                    if (theData != 0) ** GOTO lbl-1000
                                    var19_21 = null;
                                }
                                OS.CFRelease(url);
                                break block24;
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        length = OS.CFDataGetLength(theData);
                                        buffer = new byte[length];
                                        range = new CFRange();
                                        range.length = length;
                                        OS.CFDataGetBytes(theData, range, buffer);
                                        data[i] = buffer;
                                    }
                                    catch (Throwable var18_23) {
                                        var17_20 = null;
                                        OS.CFRelease(theData);
                                        throw var18_23;
                                    }
                                    {
                                        var17_20 = null;
                                        OS.CFRelease(theData);
                                    }
                                }
                                {
lbl81:
                                    // 2 sources

                                    var19_21 = null;
                                    OS.CFRelease(url);
                                    ** GOTO lbl-1000
                                }
                            }
                            catch (Throwable var22_25) {
                                var21_22 = null;
                                OS.CFRelease(cfstring);
                                throw var22_25;
                            }
                        }
                        OS.CFRelease(cfstring);
                        return;
                    }
                    var21_22 = null;
                    OS.CFRelease(cfstring);
                    return;
                }
                var21_22 = null;
                OS.CFRelease(cfstring);
                return;
            }
            var21_22 = null;
            OS.CFRelease(cfstring);
            return;
lbl-1000:
            // 1 sources

            {
                var21_22 = null;
            }
            OS.CFRelease(cfstring);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0) {
            return null;
        }
        int count = transferData.data.length;
        String[] fileNames = new String[count];
        int i = 0;
        while (i < count) {
            Object var14_15;
            int encoding;
            byte[] data = transferData.data[i];
            int url = 0;
            if (transferData.type == HFSID) {
                byte[] fsspec = new byte[data.length - 10];
                System.arraycopy(data, 10, fsspec, 0, fsspec.length);
                byte[] fsRef = new byte[80];
                if (OS.FSpMakeFSRef(fsspec, fsRef) != 0) {
                    return null;
                }
                url = OS.CFURLCreateFromFSRef(0, fsRef);
                if (url == 0) {
                    return null;
                }
            }
            if (transferData.type == FURLID && (url = OS.CFURLCreateWithBytes(0, data, data.length, encoding = OS.CFStringGetSystemEncoding(), 0)) == 0) {
                return null;
            }
            try {
                Object var11_14;
                int length;
                int path;
                block15: {
                    Object var13_17;
                    path = OS.CFURLCopyFileSystemPath(url, 0);
                    if (path == 0) {
                        Object var16_16 = null;
                        var14_15 = null;
                        OS.CFRelease(url);
                        return var16_16;
                    }
                    try {
                        length = OS.CFStringGetLength(path);
                        if (length != 0) break block15;
                        var13_17 = null;
                        var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        var11_14 = null;
                        OS.CFRelease(path);
                        throw throwable;
                    }
                    OS.CFRelease(path);
                    var14_15 = null;
                    OS.CFRelease(url);
                    return var13_17;
                }
                char[] buffer = new char[length];
                CFRange range = new CFRange();
                range.length = length;
                OS.CFStringGetCharacters(path, range, buffer);
                fileNames[i] = new String(buffer);
                var11_14 = null;
                OS.CFRelease(path);
                var14_15 = null;
            }
            catch (Throwable throwable) {
                var14_15 = null;
                OS.CFRelease(url);
                throw throwable;
            }
            OS.CFRelease(url);
            ++i;
        }
        return fileNames;
    }

    protected int[] getTypeIds() {
        return new int[]{FURLID, HFSID};
    }

    protected String[] getTypeNames() {
        return new String[]{FURL, HFS};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null || strings[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

