/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.tg_player;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Receiver;
import org.herac.tuxguitar.play.models.tg_player.ChannelNote;
import org.herac.tuxguitar.play.models.tg_player.MidiMessageUtils;
import org.herac.tuxguitar.song.models.InstrumentString;

public class NotePlayer {
    private Receiver receiver;
    private List channelNotes;
    private List startNotes = new ArrayList();
    private List stopNotes = new ArrayList();
    private List effectNotes = new ArrayList();

    public NotePlayer(Receiver receiver) {
        this.receiver = receiver;
        this.channelNotes = new ArrayList();
    }

    public void addNote(ChannelNote channelNote) {
        this.channelNotes.add(channelNote);
    }

    public void playNote(ChannelNote channelNote) {
        short s = channelNote.getTrack().getChannel().getChannel();
        int n = channelNote.getNote().getValue() + ((InstrumentString)channelNote.getTrack().getStrings().get(channelNote.getNote().getString() - 1)).getValue();
        this.receiver.send(MidiMessageUtils.noteOn(s, n, 64), -1L);
    }

    public void stopNote(ChannelNote channelNote) {
        short s = channelNote.getTrack().getChannel().getChannel();
        int n = channelNote.getNote().getValue() + ((InstrumentString)channelNote.getTrack().getStrings().get(channelNote.getNote().getString() - 1)).getValue();
        this.receiver.send(MidiMessageUtils.noteOff(s, n, 64), -1L);
    }

    public void checkNotes() {
        this.startNotes.clear();
        this.stopNotes.clear();
        this.effectNotes.clear();
        for (ChannelNote channelNote : this.channelNotes) {
            if (channelNote.shouldStop()) {
                this.stopNotes.add(channelNote);
                continue;
            }
            if (channelNote.isPlaying()) continue;
            this.startNotes.add(channelNote);
        }
        this.stopNotes();
        this.playNotes();
    }

    public void playNotes() {
        for (ChannelNote channelNote : this.startNotes) {
            channelNote.setPlaying();
            this.playNote(channelNote);
        }
    }

    public void stopNotes() {
        for (ChannelNote channelNote : this.stopNotes) {
            this.stopNote(channelNote);
            this.channelNotes.remove(channelNote);
        }
    }

    public void stopAll() {
        this.startNotes.clear();
        this.stopNotes.clear();
        this.effectNotes.clear();
        for (ChannelNote channelNote : this.channelNotes) {
            this.stopNotes.add(channelNote);
        }
        this.stopNotes();
    }
}

