/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.tg_player;

import java.util.List;
import org.herac.tuxguitar.play.models.tg_player.ChannelNote;
import org.herac.tuxguitar.play.models.tg_player.NotePlayer;
import org.herac.tuxguitar.play.models.tg_player.SongPlayer;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;

public class BeatIterator {
    private long tickPosition;
    private long nextTickPosition;
    private long beatDuration;
    private int measureIndex;
    private NotePlayer notePlayer;

    public BeatIterator(NotePlayer notePlayer) {
        this.notePlayer = notePlayer;
        this.initPosition();
    }

    private void initPosition() {
        this.nextTickPosition = 1000L;
    }

    public void nextBeat(Song song) {
        SongTrack songTrack;
        Measure measure;
        this.tickPosition = this.nextTickPosition;
        this.nextTickPosition = 0L;
        this.loadSongBeat(song);
        if (this.nextTickPosition <= 0L && (measure = this.getNextMeasure(songTrack = (SongTrack)song.getTracks().get(0))) != null) {
            this.nextTickPosition = measure.getStart();
        }
        this.checkBeatDuration(song);
    }

    public void loadSongBeat(Song song) {
        for (int i = 0; i < song.getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)song.getTracks().get(i);
            Measure measure = this.getCurrentMeasure(songTrack);
            if (measure == null) continue;
            this.loadMeasureBeat(songTrack, measure);
        }
    }

    public void loadMeasureBeat(SongTrack songTrack, Measure measure) {
        for (int i = 0; i < measure.getNotes().size(); ++i) {
            Note note = (Note)measure.getNotes().get(i);
            if (note.getStart() == this.tickPosition) {
                this.notePlayer.addNote(new ChannelNote(songTrack, measure, note));
                continue;
            }
            if (note.getStart() <= this.tickPosition || this.nextTickPosition > 0L && note.getStart() >= this.nextTickPosition) continue;
            this.nextTickPosition = note.getStart();
        }
    }

    public Measure getCurrentMeasure(SongTrack songTrack) {
        List list = songTrack.getMeasures();
        for (int i = this.measureIndex; i < list.size(); ++i) {
            Measure measure = (Measure)list.get(i);
            if (this.tickPosition < measure.getStart() || this.tickPosition >= measure.getStart() + measure.getLength()) continue;
            this.measureIndex = i;
            return measure;
        }
        this.measureIndex = 0;
        return null;
    }

    public Measure getNextMeasure(SongTrack songTrack) {
        List list = songTrack.getMeasures();
        if (list.size() > this.measureIndex + 1) {
            return (Measure)list.get(this.measureIndex + 1);
        }
        return null;
    }

    public void checkBeatDuration(Song song) {
        SongTrack songTrack;
        Measure measure;
        if (this.nextTickPosition > 0L && (measure = this.getCurrentMeasure(songTrack = (SongTrack)song.getTracks().get(0))) != null) {
            int n = measure.getTempo().getValue();
            long l = this.nextTickPosition - this.tickPosition;
            this.beatDuration = SongPlayer.getTime(n, l);
        }
    }

    public long getNextTickPosition() {
        return this.nextTickPosition;
    }

    public long getTickPosition() {
        return this.tickPosition;
    }

    public void setTickPosition(long l) {
        this.tickPosition = l;
        this.nextTickPosition = l;
        this.measureIndex = 0;
    }

    public long getBeatDuration() {
        return this.beatDuration;
    }
}

