/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.defaultplayer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.defaultplayer.MeasureStartMetaEventListener;
import org.herac.tuxguitar.play.models.defaultplayer.SongSequence;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongPlayer
implements Player {
    private SongManager songManager;
    private Sequencer sequencer;
    private Synthesizer synthesizer;
    private Soundbank soundbank;
    private MeasureStartMetaEventListener controller;
    private boolean running;
    private boolean paused;
    private boolean changeTickPosition;
    private long tickPosition;

    public SongPlayer(SongManager songManager) {
        this.songManager = songManager;
        this.controller = new MeasureStartMetaEventListener();
        this.init();
        this.reset();
    }

    private Sequencer getSequencer() throws MidiUnavailableException {
        if (this.sequencer == null) {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.addMetaEventListener(this.controller);
        }
        if (!this.sequencer.isOpen()) {
            this.sequencer.open();
        }
        return this.sequencer;
    }

    public Synthesizer getSynthesizer() throws MidiUnavailableException {
        if (this.synthesizer == null) {
            this.setSynthesizer(MidiSystem.getSynthesizer());
        }
        return this.synthesizer;
    }

    public Soundbank getSoundbank() {
        if (this.soundbank == null) {
            try {
                Synthesizer synthesizer = this.getSynthesizer();
                this.soundbank = synthesizer.getDefaultSoundbank();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
        return this.soundbank;
    }

    public void setSynthesizer(Synthesizer synthesizer) {
        try {
            this.soundbank = null;
            if (this.synthesizer != null && this.synthesizer.isOpen()) {
                this.synthesizer.close();
            }
            this.synthesizer = synthesizer;
            if (this.synthesizer != null) {
                this.synthesizer.open();
                this.connect(synthesizer.getReceiver());
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void connect(Receiver receiver) {
        try {
            Iterator<Transmitter> iterator = this.getSequencer().getTransmitters().iterator();
            while (iterator.hasNext()) {
                iterator.next().close();
            }
            Transmitter transmitter = this.getSequencer().getTransmitter();
            transmitter.setReceiver(receiver);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void init() {
        try {
            this.close();
            this.sequencer = null;
            this.synthesizer = null;
            this.soundbank = null;
            this.getSynthesizer();
            this.getSequencer();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void reset() {
        this.stop();
        this.tickPosition = 1000L;
        this.setChangeTickPosition(false);
        this.controller.reset();
    }

    public void close() {
        try {
            Sequencer sequencer;
            this.stop();
            Synthesizer synthesizer = this.getSynthesizer();
            if (synthesizer != null) {
                synthesizer.close();
            }
            if ((sequencer = this.getSequencer()) != null) {
                sequencer.close();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void allSoundOff() {
        try {
            MidiChannel[] midiChannelArray = this.getSynthesizer().getChannels();
            for (int i = 0; i < midiChannelArray.length; ++i) {
                midiChannelArray[i].allSoundOff();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        this.setRunning(false);
    }

    public void stop(boolean bl) {
        this.setPaused(bl);
        try {
            if (this.isRunning() && this.getSequencer().isOpen()) {
                this.getSequencer().stop();
                this.allSoundOff();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        this.setRunning(false);
    }

    public void stop() {
        this.stop(false);
    }

    public void pause() {
        this.stop(true);
    }

    public synchronized void play() {
        try {
            this.stop();
            this.setRunning(true);
            this.addSecuence();
            this.setChangeTickPosition(true);
            this.getSequencer().start();
            new Thread(new Runnable(){

                public synchronized void run() {
                    try {
                        while (SongPlayer.this.getSequencer().isRunning() && SongPlayer.this.isRunning()) {
                            if (SongPlayer.this.isChangeTickPosition()) {
                                SongPlayer.this.changeTickPosition();
                            }
                            SongPlayer.this.tickPosition = SongPlayer.this.getSequencer().getTickPosition();
                            Thread.sleep(10L);
                        }
                        if (SongPlayer.this.isRunning()) {
                            if (SongPlayer.this.tickPosition >= SongPlayer.this.getSequencer().getTickLength() - 500L) {
                                SongPlayer.this.reset();
                            } else {
                                SongPlayer.this.stop(SongPlayer.this.isPaused());
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        SongPlayer.this.reset();
                        midiUnavailableException.printStackTrace();
                    }
                }
            }).start();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            this.reset();
            midiUnavailableException.printStackTrace();
        }
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    private boolean isChangeTickPosition() {
        return this.changeTickPosition;
    }

    private void setChangeTickPosition(boolean bl) {
        this.changeTickPosition = bl;
    }

    public void setTickPosition(long l) {
        this.setTickPosition(l, this.controller.getStartMove());
    }

    public void setTickPosition(long l, long l2) {
        this.tickPosition = l;
        this.controller.setStartMove(l2);
        this.setChangeTickPosition(true);
        if (!this.isRunning()) {
            this.allSoundOff();
            this.changeTickPosition();
        }
    }

    public long getTickPosition() {
        return this.tickPosition - this.controller.getStartMove();
    }

    private void changeTickPosition() {
        try {
            if (this.isRunning()) {
                this.getSequencer().setTickPosition(this.tickPosition);
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        this.setChangeTickPosition(false);
    }

    public void addSecuence() {
        try {
            SongSequence songSequence = new SongSequence(this.songManager, 0);
            songSequence.createSongSecuence(true);
            this.getSequencer().setSequence(songSequence.getSongSecuence());
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public boolean loadSoundbank(File file) {
        try {
            Soundbank soundbank = MidiSystem.getSoundbank(file);
            if (soundbank != null && this.getSynthesizer().isSoundbankSupported(soundbank)) {
                if (this.getSoundbank() != null) {
                    this.getSynthesizer().unloadAllInstruments(this.getSoundbank());
                }
                this.getSynthesizer().loadAllInstruments(soundbank);
                this.soundbank = soundbank;
                return true;
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public void updateChannels() {
        for (SongTrack songTrack : this.songManager.getSong().getTracks()) {
            this.updateChannel(songTrack.getChannel());
        }
    }

    public void updateChannel(SongChannel songChannel) {
        try {
            double d = (double)this.songManager.getSong().getVolume() / 10.0;
            int n = (int)(d * (double)songChannel.getVolume());
            short s = songChannel.getBalance();
            boolean bl = songChannel.isSolo();
            boolean bl2 = songChannel.isMute();
            Synthesizer synthesizer = this.getSynthesizer();
            MidiChannel[] midiChannelArray = synthesizer.getChannels();
            midiChannelArray[songChannel.getChannel()].controlChange(7, n);
            midiChannelArray[songChannel.getChannel()].controlChange(10, s);
            midiChannelArray[songChannel.getChannel()].setSolo(bl);
            midiChannelArray[songChannel.getChannel()].setMute(bl2);
            if (songChannel.getChannel() != songChannel.getEffectChannel()) {
                midiChannelArray[songChannel.getEffectChannel()].controlChange(7, n);
                midiChannelArray[songChannel.getEffectChannel()].controlChange(10, s);
                midiChannelArray[songChannel.getEffectChannel()].setSolo(bl);
                midiChannelArray[songChannel.getEffectChannel()].setMute(bl2);
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void playBeat(final SongTrack songTrack, List list) {
        try {
            final MidiChannel[] midiChannelArray = this.getSynthesizer().getChannels();
            for (Note note : list) {
                final int n = songTrack.getOffset() + (note.getValue() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue());
                final short s = note.getEffect().hasEffects() ? songTrack.getChannel().getEffectChannel() : songTrack.getChannel().getChannel();
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            midiChannelArray[s].controlChange(7, 127);
                            midiChannelArray[s].controlChange(10, 64);
                            midiChannelArray[s].programChange(songTrack.getChannel().getInstrument());
                            midiChannelArray[s].noteOn(n, 64);
                            Thread.sleep(750L);
                            midiChannelArray[s].noteOff(n, 32);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }).start();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void write(OutputStream outputStream) {
        try {
            SongSequence songSequence = new SongSequence(this.songManager, -1000);
            songSequence.createSongSecuence(false);
            int n = this.songManager.countTracks() > 1 ? 1 : 0;
            MidiSystem.write(songSequence.getSongSecuence(), n, outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

