/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.pt;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public abstract class PTBInputStream {
    protected static final int TRACK_TYPE_GUITAR = 1;
    protected static final int TRACK_TYPE_BASS = 2;
    private static final int ERROR_MARGIN = 50;
    private static final BendEffect[] DEFAULT_BENDS = PTBInputStream.makeDefaultBends();
    private DataInputStream dataInputStream;
    protected String version;
    protected List headers;
    protected List tracks;
    protected List trackInfos;
    protected int lastUsedChannel = 0;

    public PTBInputStream(FileInputStream fileInputStream) throws FileNotFoundException {
        this.dataInputStream = new DataInputStream(fileInputStream);
        this.headers = new ArrayList();
        this.tracks = new ArrayList();
        this.trackInfos = new ArrayList();
    }

    public PTBInputStream(String string) throws FileNotFoundException {
        this(new FileInputStream(new File(string)));
    }

    public abstract boolean isSupportedVersion(String var1);

    public abstract boolean isSupportedVersion();

    protected SongTrack getTrack(int n, int n2) {
        Object object2;
        for (Object object2 : this.tracks) {
            if (((SongTrack)object2).getNumber() != (long)n) continue;
            return object2;
        }
        this.lastUsedChannel = this.lastUsedChannel < SongManager.MAX_CHANNELS - 1 ? this.lastUsedChannel + 1 : this.lastUsedChannel;
        this.lastUsedChannel = this.lastUsedChannel == 9 ? this.lastUsedChannel + 1 : this.lastUsedChannel;
        object2 = new SongChannel((short)this.lastUsedChannel, (short)this.lastUsedChannel, 0);
        SongTrack songTrack = new SongTrack(n, new String(), (SongChannel)object2, new ArrayList(), new ArrayList(), 0, RGBColor.RED);
        TrackInfo trackInfo = null;
        for (TrackInfo trackInfo2 : this.trackInfos) {
            if (trackInfo2.type != n2 || trackInfo != null && trackInfo2.trackInfoNumber >= trackInfo.trackInfoNumber) continue;
            trackInfo = trackInfo2;
        }
        if (trackInfo != null) {
            songTrack.setName(trackInfo.getName());
            songTrack.setStrings(trackInfo.getStrings());
            songTrack.getChannel().setInstrument(trackInfo.getChannel().getInstrument());
            songTrack.getChannel().setVolume(trackInfo.getChannel().getVolume());
            songTrack.getChannel().setBalance(trackInfo.getChannel().getBalance());
        }
        this.tracks.add(songTrack);
        return songTrack;
    }

    protected MeasureHeader getHeader(long l) {
        MeasureHeader measureHeader2;
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (MeasureHeader measureHeader2 : this.headers) {
            if (l + 50L < measureHeader2.getStart() || l + 50L >= measureHeader2.getStart() + measureHeader2.getLength()) continue;
            return measureHeader2;
        }
        measureHeader2 = this.getLastHeader();
        int n = measureHeader2 != null ? measureHeader2.getNumber() + 1 : 1;
        long l2 = measureHeader2 != null ? measureHeader2.getStart() + measureHeader2.getLength() : 1000L;
        TimeSignature timeSignature = measureHeader2 != null ? (TimeSignature)measureHeader2.getTimeSignature().clone() : new TimeSignature(4, new Duration(4));
        Tempo tempo = measureHeader2 != null ? (Tempo)measureHeader2.getTempo().clone() : new Tempo(120);
        int n2 = 1;
        MeasureHeader measureHeader3 = new MeasureHeader(n, l2, timeSignature, tempo, null, n2, false, 0);
        this.headers.add(measureHeader3);
        if (measureHeader3.getStart() + measureHeader3.getLength() <= l) {
            return measureHeader3;
        }
        return this.getHeader(l);
    }

    protected MeasureHeader getLastHeader() {
        if (this.headers != null && !this.headers.isEmpty()) {
            return (MeasureHeader)this.headers.get(this.headers.size() - 1);
        }
        return null;
    }

    protected Measure getMeasure(SongTrack songTrack, long l) {
        for (Measure measure : songTrack.getMeasures()) {
            if (l + 50L < measure.getStart() || l + 50L >= measure.getStart() + measure.getLength()) continue;
            return measure;
        }
        this.getHeader(l);
        for (int i = 0; i < this.headers.size(); ++i) {
            boolean bl = false;
            MeasureHeader measureHeader = (MeasureHeader)this.headers.get(i);
            for (int j = 0; j < songTrack.getMeasures().size(); ++j) {
                Measure measure = (Measure)songTrack.getMeasures().get(j);
                if (!measure.getHeader().equals(measureHeader)) continue;
                bl = true;
            }
            if (bl) continue;
            songTrack.getMeasures().add(new Measure(measureHeader, new ArrayList(), new ArrayList(), 1, 0));
        }
        return this.getMeasure(songTrack, l);
    }

    protected void makeTrackChannels(int n, int n2, List list) {
        for (GuitarInHelper guitarInHelper : list) {
            for (int i = 0; i < this.trackInfos.size(); ++i) {
                TrackInfo trackInfo = (TrackInfo)this.trackInfos.get(i);
                if (trackInfo.getTrackInfoNumber() != guitarInHelper.getTrackInfo() || trackInfo.getType() != n2) continue;
                SongTrack songTrack = this.getTrack(guitarInHelper.staff + n, n2);
                songTrack.setName(trackInfo.getName());
                songTrack.setStrings(trackInfo.getStrings());
                songTrack.getChannel().setInstrument(trackInfo.getChannel().getInstrument());
                songTrack.getChannel().setVolume(trackInfo.getChannel().getVolume());
                songTrack.getChannel().setBalance(trackInfo.getChannel().getBalance());
            }
        }
    }

    protected void makeSectionNotes(long l, List list, List list2, List list3) {
        for (int i = 0; i < list.size(); ++i) {
            TrackHelper trackHelper = (TrackHelper)list.get(i);
            this.makeTrackNotes(l, trackHelper, list2, list3);
        }
    }

    private void makeTrackNotes(long l, TrackHelper trackHelper, List list, List list2) {
        int n;
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < list.size(); ++n2) {
            BeatHelper beatHelper;
            int n4;
            BarHelper barHelper = (BarHelper)list.get(n2);
            n = 0;
            int n5 = 0;
            this.makeTempoMarker(barHelper.getPosition(), l, trackHelper.getTrackNumber(), list2);
            for (n4 = 0; n4 < trackHelper.getVoice1().size(); ++n4) {
                beatHelper = (BeatHelper)trackHelper.getVoice1().get(n4);
                this.makeTempoMarker(beatHelper.getPosition(), l + (long)n, trackHelper.getTrackNumber(), list2);
                n = (int)((long)n + this.makeBeatNotes(l + (long)n, trackHelper, beatHelper, n3, barHelper.getPosition()));
            }
            for (n4 = 0; n4 < trackHelper.getVoice2().size(); ++n4) {
                beatHelper = (BeatHelper)trackHelper.getVoice2().get(n4);
                this.makeTempoMarker(beatHelper.getPosition(), l + (long)n5, trackHelper.getTrackNumber(), list2);
                n5 = (int)((long)n5 + this.makeBeatNotes(l + (long)n5, trackHelper, beatHelper, n3, barHelper.getPosition()));
            }
            n3 = barHelper.getPosition();
            l += (long)Math.max(n, n5);
        }
        n2 = 0;
        int n6 = 0;
        for (n = 0; n < trackHelper.getVoice1().size(); ++n) {
            BeatHelper beatHelper = (BeatHelper)trackHelper.getVoice1().get(n);
            this.makeTempoMarker(beatHelper.getPosition(), l + (long)n2, trackHelper.getTrackNumber(), list2);
            n2 = (int)((long)n2 + this.makeBeatNotes(l + (long)n2, trackHelper, beatHelper, n3, -1));
        }
        for (n = 0; n < trackHelper.getVoice2().size(); ++n) {
            BeatHelper beatHelper = (BeatHelper)trackHelper.getVoice2().get(n);
            this.makeTempoMarker(beatHelper.getPosition(), l + (long)n6, trackHelper.getTrackNumber(), list2);
            n6 = (int)((long)n6 + this.makeBeatNotes(l + (long)n6, trackHelper, beatHelper, n3, -1));
        }
    }

    private long makeBeatNotes(long l, TrackHelper trackHelper, BeatHelper beatHelper, int n, int n2) {
        if (!(beatHelper.isAcciaccatura() || beatHelper.getPosition() <= n || beatHelper.getPosition() >= n2 && n2 >= 0)) {
            Measure measure = this.getMeasure(this.getTrack(trackHelper.getTrackNumber(), trackHelper.getTrackType()), l);
            int n3 = (int)(measure.getStart() > l ? measure.getStart() - l : 0L);
            for (int i = 0; i < beatHelper.getNotes().size(); ++i) {
                NoteHelper noteHelper = (NoteHelper)beatHelper.getNotes().get(i);
                int n4 = noteHelper.getValue();
                int n5 = noteHelper.getString();
                int n6 = 64;
                boolean bl = noteHelper.isTied();
                Duration duration = (Duration)beatHelper.getDuration().clone();
                NoteEffect noteEffect = new NoteEffect();
                noteEffect.setVibrato(beatHelper.isVibrato());
                noteEffect.setDeadNote(noteHelper.isDead());
                noteEffect.setHammer(noteHelper.isHammer());
                noteEffect.setSlide(noteHelper.isSlide());
                noteEffect.setBend(!bl && noteHelper.getBend() > 0 && noteHelper.getBend() < DEFAULT_BENDS.length ? (BendEffect)DEFAULT_BENDS[noteHelper.getBend() - 1].clone() : null);
                this.addNote(measure, new Note(n4, l + (long)n3, duration, n6, n5, bl, noteEffect));
            }
            return beatHelper.getDuration().getTime() + (long)n3;
        }
        return 0L;
    }

    private void addNote(Measure measure, Note note) {
        for (Note note2 : measure.getNotes()) {
            if (note2.getStart() < note.getStart() && note2.getStart() + 50L > note.getStart()) {
                note.setStart(note2.getStart());
                continue;
            }
            if (note2.getStart() <= note.getStart() || note2.getStart() - 50L >= note.getStart()) continue;
            note.setStart(note2.getStart());
        }
        measure.addNote(note);
    }

    private void makeTempoMarker(int n, long l, int n2, List list) {
        if (n2 == 1) {
            for (TempoHelper tempoHelper : list) {
                if (tempoHelper.getPosition() != n) continue;
                MeasureHeader measureHeader = this.getHeader(l);
                measureHeader.getTempo().setValue(tempoHelper.getTempo());
                measureHeader.setTripletFeel(tempoHelper.getTripletFeel());
            }
        }
    }

    protected Song checkSong(Song song) throws IOException {
        return new SongAdjuster().process(song);
    }

    private static BendEffect[] makeDefaultBends() {
        BendEffect[] bendEffectArray = new BendEffect[8];
        bendEffectArray[0] = new BendEffect();
        bendEffectArray[0].addPoint(0, 0);
        bendEffectArray[0].addPoint(6, 8);
        bendEffectArray[0].addPoint(12, 8);
        bendEffectArray[1] = new BendEffect();
        bendEffectArray[1].addPoint(0, 0);
        bendEffectArray[1].addPoint(3, 8);
        bendEffectArray[1].addPoint(6, 8);
        bendEffectArray[1].addPoint(9, 0);
        bendEffectArray[1].addPoint(12, 0);
        bendEffectArray[2] = new BendEffect();
        bendEffectArray[2].addPoint(0, 0);
        bendEffectArray[2].addPoint(6, 8);
        bendEffectArray[2].addPoint(12, 8);
        bendEffectArray[3] = new BendEffect();
        bendEffectArray[3].addPoint(0, 8);
        bendEffectArray[3].addPoint(12, 8);
        bendEffectArray[4] = new BendEffect();
        bendEffectArray[4].addPoint(0, 8);
        bendEffectArray[4].addPoint(4, 8);
        bendEffectArray[4].addPoint(8, 0);
        bendEffectArray[4].addPoint(12, 0);
        bendEffectArray[5] = new BendEffect();
        bendEffectArray[5].addPoint(0, 8);
        bendEffectArray[5].addPoint(12, 8);
        bendEffectArray[6] = new BendEffect();
        bendEffectArray[6].addPoint(0, 8);
        bendEffectArray[6].addPoint(4, 8);
        bendEffectArray[6].addPoint(8, 0);
        bendEffectArray[6].addPoint(12, 0);
        bendEffectArray[7] = new BendEffect();
        bendEffectArray[7].addPoint(0, 8);
        bendEffectArray[7].addPoint(4, 8);
        bendEffectArray[7].addPoint(8, 0);
        bendEffectArray[7].addPoint(12, 0);
        return bendEffectArray;
    }

    protected int readByte() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    protected String readString(int n) {
        try {
            byte[] byArray = new byte[n];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = this.dataInputStream.readByte();
            }
            return new String(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    protected String readString() {
        try {
            int n = this.dataInputStream.read();
            return this.readString(n < 255 ? n : this.readUInt());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    protected int readUCType() {
        return this.readByte();
    }

    protected boolean readUChar() {
        try {
            return this.dataInputStream.readBoolean();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected int readUInt() {
        try {
            byte[] byArray = new byte[]{0, 0};
            this.dataInputStream.read(byArray);
            return (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    protected int readULong() {
        try {
            byte[] byArray = new byte[4];
            this.dataInputStream.read(byArray);
            return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    protected void debug(int n) {
        System.out.println(n);
    }

    protected void debug(String string) {
        System.out.println(string);
    }

    private class SongAdjuster {
        public Song process(Song song) throws IOException {
            this.completeMeasures(song);
            this.adjustDurations(song);
            return song;
        }

        public void completeMeasures(Song song) throws IOException {
            int n = song.getMeasureHeaders().size();
            for (int i = 0; i < song.getTracks().size(); ++i) {
                SongTrack songTrack = (SongTrack)song.getTracks().get(i);
                while (songTrack.getMeasures().size() < n) {
                    long l = 1000L;
                    Measure measure = !songTrack.getMeasures().isEmpty() ? songTrack.getMeasures().get(songTrack.getMeasures().size() - 1) : null;
                    if (measure != null) {
                        l = measure.getStart() + measure.getLength();
                    }
                    songTrack.getMeasures().add(new Measure(PTBInputStream.this.getHeader(l), new ArrayList(), new ArrayList(), 1, 0));
                }
            }
            if (song.getMeasureHeaders().isEmpty() || song.getTracks().isEmpty()) {
                throw new IOException("Empty Song");
            }
        }

        public void adjustDurations(Song song) {
            for (int i = 0; i < song.getTracks().size(); ++i) {
                SongTrack songTrack = (SongTrack)song.getTracks().get(i);
                for (int j = 0; j < songTrack.getMeasures().size(); ++j) {
                    long l;
                    Measure measure = (Measure)songTrack.getMeasures().get(j);
                    if (measure.getNotes().isEmpty()) continue;
                    this.orderNotes(measure);
                    long l2 = measure.getStart();
                    long l3 = measure.getLength();
                    for (long k = ((Note)measure.getNotes().get(0)).getStart(); k < l2 + l3; k += l) {
                        List list = this.getNotesAtBeat(measure, k);
                        l = this.getMaxLength(measure, k);
                        this.normalizeNotes(list, l);
                    }
                }
            }
        }

        private void normalizeNotes(List list, long l) {
            Duration duration = null;
            for (Note note : list) {
                long l2 = note.getDuration().getTime();
                if (l2 > l || duration != null && l2 <= duration.getTime()) continue;
                duration = note.getDuration();
            }
            if (duration == null) {
                duration = Duration.fromTime(l);
            }
            if (duration != null) {
                for (Note note : list) {
                    note.setDuration((Duration)duration.clone());
                }
            }
        }

        private List getNotesAtBeat(Measure measure, long l) {
            ArrayList<Note> arrayList = new ArrayList<Note>();
            for (Note note : measure.getNotes()) {
                if (note.getStart() != l) continue;
                arrayList.add(note);
            }
            return arrayList;
        }

        private long getMaxLength(Measure measure, long l) {
            long l2 = -1L;
            for (Note note : measure.getNotes()) {
                if (note.getStart() <= l || l2 >= 0L && note.getStart() >= l2) continue;
                l2 = note.getStart();
            }
            if (l2 < 0L) {
                l2 = measure.getStart() + measure.getLength();
            }
            return l2 - l;
        }

        private void orderNotes(Measure measure) {
            int n = measure.getNotes().size();
            for (int i = 0; i < n; ++i) {
                Note note = null;
                for (int j = i; j < n; ++j) {
                    Note note2 = (Note)measure.getNotes().get(j);
                    if (note == null) {
                        note = note2;
                        continue;
                    }
                    if (note2.getStart() < note.getStart()) {
                        note = note2;
                        continue;
                    }
                    if (note2.getStart() != note.getStart() || note2.getString() >= note.getString()) continue;
                    note = note2;
                }
                measure.getNotes().remove(note);
                measure.getNotes().add(i, note);
            }
        }
    }

    protected class SongInfo {
        private String name;
        private String interpret;
        private String album;
        private String author;

        public String getAlbum() {
            return this.album;
        }

        public void setAlbum(String string) {
            this.album = string;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String string) {
            this.author = string;
        }

        public String getInterpret() {
            return this.interpret;
        }

        public void setInterpret(String string) {
            this.interpret = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    protected class GuitarInHelper {
        private int staff;
        private int trackInfo;

        public GuitarInHelper(int n, int n2) {
            this.staff = n;
            this.trackInfo = n2;
        }

        public int getStaff() {
            return this.staff;
        }

        public int getTrackInfo() {
            return this.trackInfo;
        }
    }

    protected class TrackInfo {
        private int type;
        private int trackInfoNumber;
        private SongChannel channel;
        private List strings;
        private String name;

        public SongChannel getChannel() {
            return this.channel;
        }

        public void setChannel(SongChannel songChannel) {
            this.channel = songChannel;
        }

        public List getStrings() {
            return this.strings;
        }

        public void setStrings(List list) {
            this.strings = list;
        }

        public int getTrackInfoNumber() {
            return this.trackInfoNumber;
        }

        public void setTrackInfoNumber(int n) {
            this.trackInfoNumber = n;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    protected class TempoHelper {
        int position;
        int tempo;
        int tripletFeel;

        public TempoHelper(int n, int n2, int n3) {
            this.position = n;
            this.tempo = n2;
            this.tripletFeel = n3;
        }

        public int getPosition() {
            return this.position;
        }

        public int getTempo() {
            return this.tempo;
        }

        public int getTripletFeel() {
            return this.tripletFeel;
        }
    }

    protected class BarHelper {
        private int position;

        public BarHelper(int n) {
            this.position = n;
        }

        public int getPosition() {
            return this.position;
        }
    }

    protected class NoteHelper {
        private int value;
        private int string;
        private boolean tied;
        private boolean dead;
        private boolean hammer;
        private boolean slide;
        private int bend;

        public int getString() {
            return this.string;
        }

        public void setString(int n) {
            this.string = n;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public boolean isDead() {
            return this.dead;
        }

        public void setDead(boolean bl) {
            this.dead = bl;
        }

        public boolean isTied() {
            return this.tied;
        }

        public void setTied(boolean bl) {
            this.tied = bl;
        }

        public int getBend() {
            return this.bend;
        }

        public void setBend(int n) {
            this.bend = n;
        }

        public boolean isHammer() {
            return this.hammer;
        }

        public void setHammer(boolean bl) {
            this.hammer = bl;
        }

        public boolean isSlide() {
            return this.slide;
        }

        public void setSlide(boolean bl) {
            this.slide = bl;
        }
    }

    protected class BeatHelper {
        private int position;
        private Duration duration;
        private List notes = new ArrayList();
        private boolean acciaccatura;
        private boolean vibrato;

        public Duration getDuration() {
            return this.duration;
        }

        public void setDuration(Duration duration) {
            this.duration = duration;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int n) {
            this.position = n;
        }

        public void addNote(NoteHelper noteHelper) {
            this.notes.add(noteHelper);
        }

        public List getNotes() {
            return this.notes;
        }

        public boolean isAcciaccatura() {
            return this.acciaccatura;
        }

        public void setAcciaccatura(boolean bl) {
            this.acciaccatura = bl;
        }

        public boolean isVibrato() {
            return this.vibrato;
        }

        public void setVibrato(boolean bl) {
            this.vibrato = bl;
        }
    }

    protected class TrackHelper {
        private int trackNumber;
        private int trackType;
        private List voice1 = new ArrayList();
        private List voice2 = new ArrayList();

        public TrackHelper(int n, int n2) {
            this.trackNumber = n;
            this.trackType = n2;
            this.voice1 = new ArrayList();
            this.voice2 = new ArrayList();
        }

        public int getTrackNumber() {
            return this.trackNumber;
        }

        public int getTrackType() {
            return this.trackType;
        }

        public List getVoice1() {
            return this.voice1;
        }

        public List getVoice2() {
            return this.voice2;
        }
    }
}

