/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ImageUtils {
    public static void writeImage(ImageData imageData, OutputStream outputStream, int n) {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.save(outputStream, n);
    }

    public static byte[] imageToByteArray(ImageData imageData, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageUtils.writeImage(imageData, byteArrayOutputStream, n);
        return byteArrayOutputStream.toByteArray();
    }

    public static BufferedImage convertToAWT(ImageData imageData) {
        Object object;
        ColorModel colorModel = null;
        PaletteData paletteData = imageData.palette;
        if (paletteData.isDirect) {
            colorModel = new DirectColorModel(imageData.depth, paletteData.redMask, paletteData.greenMask, paletteData.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(imageData.width, imageData.height), false, null);
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[3];
            for (int i = 0; i < imageData.height; ++i) {
                for (int j = 0; j < imageData.width; ++j) {
                    int n = imageData.getPixel(j, i);
                    RGB rGB = paletteData.getRGB(n);
                    nArray[0] = rGB.red;
                    nArray[1] = rGB.green;
                    nArray[2] = rGB.blue;
                    writableRaster.setPixels(j, i, 1, 1, nArray);
                }
            }
            return bufferedImage;
        }
        RGB[] rGBArray = paletteData.getRGBs();
        byte[] byArray = new byte[rGBArray.length];
        byte[] byArray2 = new byte[rGBArray.length];
        byte[] byArray3 = new byte[rGBArray.length];
        for (int i = 0; i < rGBArray.length; ++i) {
            object = rGBArray[i];
            byArray[i] = (byte)((RGB)object).red;
            byArray2[i] = (byte)((RGB)object).green;
            byArray3[i] = (byte)((RGB)object).blue;
        }
        colorModel = imageData.transparentPixel != -1 ? new IndexColorModel(imageData.depth, rGBArray.length, byArray, byArray2, byArray3, imageData.transparentPixel) : new IndexColorModel(imageData.depth, rGBArray.length, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(imageData.width, imageData.height), false, null);
        object = bufferedImage.getRaster();
        int[] nArray = new int[1];
        for (int i = 0; i < imageData.height; ++i) {
            for (int j = 0; j < imageData.width; ++j) {
                int n;
                nArray[0] = n = imageData.getPixel(j, i);
                ((WritableRaster)object).setPixel(j, i, nArray);
            }
        }
        return bufferedImage;
    }

    public static Image convertToIText(ImageData imageData) {
        try {
            PaletteData paletteData = imageData.palette;
            int n = imageData.width;
            int n2 = imageData.height;
            byte[] byArray = new byte[n * n2 * 3];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    RGB rGB = paletteData.getRGB(imageData.getPixel(j, i));
                    byArray[i * (n * 3) + j * 3] = (byte)rGB.red;
                    byArray[i * (n * 3) + j * 3 + 1] = (byte)rGB.green;
                    byArray[i * (n * 3) + j * 3 + 2] = (byte)rGB.blue;
                }
            }
            return Image.getInstance(n, n2, 3, 8, byArray);
        }
        catch (BadElementException badElementException) {
            badElementException.printStackTrace();
            return null;
        }
    }
}

