/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.helpers.TracksMeasures;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableRemoveMeasure
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long p1;
    private long p2;
    private TracksMeasures tracksMeasures;
    private UndoMarkers undoMarkers;

    public UndoableRemoveMeasure(long l, long l2) {
        Caret caret = UndoableRemoveMeasure.getCaret();
        this.doAction = 1;
        this.undoCaret = new UndoableCaretHelper();
        this.p1 = l;
        this.p2 = l2;
        this.tracksMeasures = TuxGuitar.instance().getSongManager().copyMeasures(l, l2);
        this.undoMarkers = new UndoMarkers();
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().removeMeasures(this.p1, this.p2);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        int n = 0;
        SongManager songManager = TuxGuitar.instance().getSongManager();
        Measure measure = songManager.getTrackManager().getMeasureAt(songManager.getFirstTrack(), this.p1);
        n = measure == null ? songManager.getTrackManager().getLastMeasure(songManager.getFirstTrack()).getNumber() + 1 : measure.getNumber();
        songManager.insertMeasures((TracksMeasures)this.tracksMeasures.clone(), n, 0L);
        TuxGuitar.instance().fireUpdate();
        this.undoMarkers.undo();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    public UndoableRemoveMeasure endUndo() {
        this.redoCaret = new UndoableCaretHelper();
        return this;
    }

    private class UndoMarkers {
        private List markers = new ArrayList();

        public UndoMarkers() {
            Iterator iterator = TuxGuitar.instance().getSongManager().getMarkers().iterator();
            while (iterator.hasNext()) {
                this.markers.add(((Marker)iterator.next()).clone());
            }
        }

        public void undo() {
            TuxGuitar.instance().getSongManager().removeAllMarkers();
            for (Marker marker : this.markers) {
                TuxGuitar.instance().getSongManager().updateMarker((Marker)marker.clone());
            }
        }
    }
}

