/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.table;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.herac.tuxguitar.gui.TablatureEditor;

public class SongTable
extends Composite {
    private TablatureEditor editor;
    private SashForm form;
    private SongTableColumn[] columns;

    public SongTable(Composite composite, int n, TablatureEditor tablatureEditor) {
        super(composite, 0);
        this.editor = tablatureEditor;
        this.setLayout(this.makeLayout());
        this.setLayoutData(new GridData(4, 128, true, false, 0, 0));
        this.form = new SashForm(this, 256);
        this.form.setLayoutData(new GridData(4, 128, true, false, 0, 0));
        this.form.SASH_WIDTH = 1;
        this.makeColumns(n);
    }

    private GridLayout makeLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        return gridLayout;
    }

    public void makeColumns(int n) {
        this.columns = new SongTableColumn[n];
        for (int i = 0; i < n; ++i) {
            this.columns[i] = new SongTableColumn(this.form);
        }
    }

    public SongTableColumn getColumn(int n) {
        return this.columns[n];
    }

    public void clearColumnsAfter(int n) {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].clearAfter(n);
        }
    }

    public void layout() {
        super.layout();
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].layout();
        }
        this.form.layout();
    }

    public void setWeights(int[] nArray) {
        this.form.setWeights(nArray);
    }

    public class SongTableColumn
    extends Composite {
        private Button header;

        public SongTableColumn(Composite composite) {
            super(composite, 0);
            this.setLayout(this.makeLayout());
            this.header = new Button(this, 16384);
            this.header.setLayoutData(new GridData(4, 128, true, false, 0, 0));
        }

        private GridLayout makeLayout() {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginTop = 0;
            gridLayout.marginBottom = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginRight = 0;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            return gridLayout;
        }

        public void setName(String string) {
            this.header.setText(string);
        }

        public int getItemCount() {
            return this.getChildren().length - 1;
        }

        public int getItemHeight() {
            Control[] controlArray = this.getChildren();
            return controlArray[1].getBounds().height;
        }

        public Control getItem(int n) {
            Control[] controlArray = this.getChildren();
            return controlArray[n + 1];
        }

        public int getHeaderHeight() {
            return this.header.getBounds().height;
        }

        public boolean isEmpty() {
            return this.getChildren().length <= 1;
        }

        public void clearAfter(int n) {
            Control[] controlArray = this.getChildren();
            for (int i = n + 1; i < controlArray.length; ++i) {
                controlArray[i].dispose();
            }
        }
    }
}

