/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongCoords {
    private Tablature tablature;
    private SongManager songManager;
    private List tracksCoords;

    public SongCoords(Tablature tablature, SongManager songManager) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.init();
    }

    public void init() {
        this.tracksCoords = new ArrayList();
    }

    public SongTrackCoords getTrackAt(int n, int n2) {
        int n3 = this.tablature.getViewLayout().getTrackNumberAt(this.tracksCoords, n, n2);
        if (n3 >= 0) {
            return this.getTrack(n3);
        }
        return null;
    }

    public SongTrackCoords getTrack(long l) {
        SongTrackCoords songTrackCoords = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(i);
            if (songTrackCoords2.getTrack().getNumber() != l) continue;
            songTrackCoords = songTrackCoords2;
            break;
        }
        return songTrackCoords;
    }

    public SongTrackCoords getNextTrack(SongTrackCoords songTrackCoords) {
        SongTrackCoords songTrackCoords2 = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords3 = (SongTrackCoords)this.tracksCoords.get(i);
            if (!songTrackCoords3.equals(songTrackCoords)) continue;
            int n = i + 1;
            if (n >= this.tracksCoords.size()) break;
            songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(n);
            break;
        }
        return songTrackCoords2;
    }

    public SongTrackCoords getPrevTrack(SongTrackCoords songTrackCoords) {
        SongTrackCoords songTrackCoords2 = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords3 = (SongTrackCoords)this.tracksCoords.get(i);
            if (!songTrackCoords3.equals(songTrackCoords)) continue;
            int n = i - 1;
            if (n < 0) break;
            songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(n);
            break;
        }
        return songTrackCoords2;
    }

    public SongTrackCoords getTrack(SongTrack songTrack) {
        SongTrackCoords songTrackCoords = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(i);
            if (!songTrackCoords2.getTrack().equals(songTrack)) continue;
            songTrackCoords = songTrackCoords2;
            break;
        }
        return songTrackCoords;
    }

    public SongTrackCoords getFirstTrack() {
        SongTrackCoords songTrackCoords = null;
        if (!this.tracksCoords.isEmpty()) {
            songTrackCoords = (SongTrackCoords)this.tracksCoords.get(0);
        }
        return songTrackCoords;
    }

    public SongTrackCoords getLastTrack() {
        SongTrackCoords songTrackCoords = null;
        if (!this.tracksCoords.isEmpty()) {
            songTrackCoords = (SongTrackCoords)this.tracksCoords.get(this.tracksCoords.size() - 1);
        }
        return songTrackCoords;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public List getTrackCoords() {
        return this.tracksCoords;
    }
}

