/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.tab.ScoreBeatHelper;
import org.herac.tuxguitar.gui.tab.SilenceCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.TablatureUtil;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.TimeSignature;

public class MeasureCoords {
    public static final int[] SCORE_KEY_OFFSETS = new int[]{32, 20, 24, 26};
    private static final int[] SCORE_NATURAL_POSITIONS = new int[]{7, 7, 6, 6, 5, 4, 4, 3, 3, 2, 2, 1};
    public static final int DEFAULT_LEFT_SPAN = 15;
    public static final int DEFAULT_RIGHT_SPAN = 15;
    public static final int DEFAULT_TIME_SIGNATURE_SPAN = 40;
    public static final int DEFAULT_CLEF_SPAN = 40;
    public static final int DEFAULT_QUARTER_SPAN = 30;
    private Tablature tablature;
    private int posX;
    private int posY;
    private int lastFromX;
    private int lastFromY;
    private int width;
    private int tabHeight;
    private int quarterSpan;
    private long beatLength;
    private boolean paintTimeSignature;
    private boolean paintTempo;
    private boolean paintTripletFeel;
    private boolean paintClef = true;
    private boolean paintKeySignature = true;
    private List measureComponents;
    private Measure measure;
    private Measure prevMeasure;
    private SongTrackCoords trackCoords;
    private SongManager songManager;
    private boolean outOfBounds;
    private boolean firstOfLine;
    private Caret caret;
    private Rectangle clefSrcBounds;
    private Rectangle clefDstBounds;
    private int span;
    private int scoreSpan;
    private int maxY;
    private int minY;

    public MeasureCoords(SongManager songManager, Tablature tablature, Measure measure, SongTrackCoords songTrackCoords) {
        this.measure = measure;
        this.trackCoords = songTrackCoords;
        this.tablature = tablature;
        this.songManager = songManager;
        this.measureComponents = new ArrayList();
    }

    public void create(ViewLayout viewLayout) {
        this.measureComponents.clear();
        this.beatLength = TablatureUtil.getBeatLength(this.getMeasure().getTimeSignature());
        this.autoCompleteSilences();
        this.calculateQuarterSpan(viewLayout);
    }

    public void update(ViewLayout viewLayout) {
        this.orderNotes();
        this.calculateMeasureChanges(viewLayout);
        this.calculateWidth();
        this.calculateTabHeight(viewLayout);
        this.calculateClefBounds(viewLayout);
        this.calcuateComponents(viewLayout);
        this.updateComponents(viewLayout);
        this.orderComponents();
    }

    private void calculateQuarterSpan(ViewLayout viewLayout) {
        if (this.measure.getNotes().isEmpty() && this.measure.getSilences().isEmpty()) {
            this.quarterSpan = 30;
        } else {
            Component component;
            int n;
            Component component2;
            Duration duration = null;
            if (!this.measure.getNotes().isEmpty()) {
                component2 = null;
                for (n = 0; n < this.measure.getNotes().size(); ++n) {
                    component = (Note)this.measure.getNotes().get(n);
                    if (component2 != null && ((Note)component).getDuration().getTime() > ((Note)component2).getDuration().getTime()) continue;
                    component2 = component;
                }
                duration = ((Note)component2).getDuration();
            }
            if (!this.measure.getSilences().isEmpty()) {
                component2 = null;
                for (n = 0; n < this.measure.getSilences().size(); ++n) {
                    component = (Silence)this.measure.getSilences().get(n);
                    if (component2 != null && ((Silence)component).getDuration().getTime() > ((Silence)component2).getDuration().getTime()) continue;
                    component2 = component;
                }
                if (duration == null || ((Silence)component2).getDuration().getTime() <= duration.getTime()) {
                    duration = ((Silence)component2).getDuration();
                }
            }
            this.quarterSpan = viewLayout.getSpanForQuarter(duration);
        }
    }

    public void calculateMeasureChanges(ViewLayout viewLayout) {
        this.paintTempo = false;
        this.paintTripletFeel = false;
        this.paintClef = false;
        this.paintKeySignature = false;
        this.paintTimeSignature = false;
        MeasureCoords measureCoords = this.trackCoords.getPrevMeasure(this);
        if (measureCoords != null) {
            this.prevMeasure = measureCoords.getMeasure();
        }
        if (this.prevMeasure == null) {
            this.paintTempo = true;
            this.paintTripletFeel = this.getMeasure().getTripletFeel() != 1;
            this.paintTimeSignature = true;
            if (viewLayout.isScoreEnabled()) {
                this.paintClef = true;
                this.paintKeySignature = true;
            }
        } else {
            if (this.getMeasure().getTempo().getValue() != this.prevMeasure.getTempo().getValue()) {
                this.paintTempo = true;
            }
            if (this.getMeasure().getTripletFeel() != this.prevMeasure.getTripletFeel()) {
                this.paintTripletFeel = true;
            }
            int n = this.getMeasure().getTimeSignature().getNumerator();
            int n2 = this.getMeasure().getTimeSignature().getDenominator().getValue();
            int n3 = this.prevMeasure.getTimeSignature().getNumerator();
            int n4 = this.prevMeasure.getTimeSignature().getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                this.paintTimeSignature = true;
            }
            if (viewLayout.isScoreEnabled()) {
                if (this.getMeasure().getClef() != this.prevMeasure.getClef()) {
                    this.paintClef = true;
                }
                if (this.getMeasure().getKeySignature() != this.prevMeasure.getKeySignature()) {
                    this.paintKeySignature = true;
                }
            }
        }
    }

    private void calculateClefBounds(ViewLayout viewLayout) {
        if (this.paintClef) {
            if (this.measure.getClef() == 1) {
                this.clefSrcBounds = SystemImages.CLEF_TREBLE.getBounds();
            } else if (this.measure.getClef() == 2) {
                this.clefSrcBounds = SystemImages.CLEF_BASS.getBounds();
            } else if (this.measure.getClef() == 3) {
                this.clefSrcBounds = SystemImages.CLEF_TENOR.getBounds();
            } else if (this.measure.getClef() == 4) {
                this.clefSrcBounds = SystemImages.CLEF_ALTO.getBounds();
            }
            this.clefDstBounds = new Rectangle(this.clefSrcBounds.x, this.clefSrcBounds.y, this.clefSrcBounds.width, viewLayout.getScoreLineSpan() * this.clefSrcBounds.height / 10);
        }
    }

    private void calcuateComponents(ViewLayout viewLayout) {
        this.measureComponents.clear();
        this.calculateComponentsCoords(viewLayout);
    }

    private void calculateComponentsCoords(ViewLayout viewLayout) {
        Component component;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getFirstNoteSpan();
        for (n = 0; n < this.measure.getNotes().size(); ++n) {
            component = (Note)this.measure.getNotes().get(n);
            n3 = ((Note)component).getString() * viewLayout.getStringSpan();
            n2 = TablatureUtil.getStartPosition(this.measure, ((Note)component).getStart(), this.quarterSpan) + 10;
            this.measureComponents.add(new NoteCoords(this.tablature, this.trackCoords, this, (Note)component, n2 + n4, n3));
        }
        for (n = 0; n < this.measure.getSilences().size(); ++n) {
            component = (Silence)this.measure.getSilences().get(n);
            n2 = TablatureUtil.getStartPosition(this.measure, ((Silence)component).getStart(), this.quarterSpan) + 5;
            this.measureComponents.add(new SilenceCoords(this.tablature, this, (Silence)component, n2 + n4));
        }
    }

    private void autoCompleteSilences() {
        this.songManager.getMeasureManager().autoCompleteSilences(this.measure);
    }

    private void updateComponents(ViewLayout viewLayout) {
        ScoreBeatHelper scoreBeatHelper = null;
        NoteCoords noteCoords = null;
        this.maxY = 0;
        this.minY = 100;
        for (MeasureComponent measureComponent : this.measureComponents) {
            if (measureComponent instanceof NoteCoords) {
                NoteCoords noteCoords2 = (NoteCoords)measureComponent;
                if (noteCoords == null || !this.areInSameBeat(noteCoords, measureComponent)) {
                    scoreBeatHelper = new ScoreBeatHelper();
                }
                scoreBeatHelper.check(noteCoords2, this.getMeasure().getClef());
                noteCoords2.setScoreBeatHelper(scoreBeatHelper);
                noteCoords = noteCoords2;
            }
            measureComponent.update(viewLayout);
            if (!ViewLayout.AUTO_SPACING_ENABLED) continue;
            this.checkValue(measureComponent);
        }
    }

    private void checkValue(MeasureComponent measureComponent) {
        if (measureComponent instanceof NoteCoords) {
            NoteCoords noteCoords = (NoteCoords)measureComponent;
            int n = noteCoords.getScorePosY();
            int n2 = n = n > 0 && !noteCoords.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO) ? n + 10 : n;
            if (n > this.maxY) {
                this.maxY = n;
            }
            if (n < this.minY) {
                this.minY = n;
            }
        }
    }

    public void calculateWidth() {
        TimeSignature timeSignature = this.getMeasure().getTimeSignature();
        double d = 1.0 / (double)timeSignature.getDenominator().getValue() * 4.0 * (double)timeSignature.getNumerator();
        this.width = (int)((double)this.quarterSpan * d);
        this.width += this.getFirstNoteSpan();
        this.width += 15;
        this.width += 15;
    }

    public void calculateTabHeight(ViewLayout viewLayout) {
        this.tabHeight = this.trackCoords.getTrack().getStrings().size() * viewLayout.getStringSpan();
    }

    private void orderNotes() {
        this.songManager.getMeasureManager().orderNotes(this.measure);
    }

    private void orderComponents() {
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent = null;
            for (int j = i; j < this.measureComponents.size(); ++j) {
                MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(j);
                if (measureComponent != null && measureComponent2.getStart() >= measureComponent.getStart()) continue;
                measureComponent = measureComponent2;
            }
            this.measureComponents.remove(measureComponent);
            this.measureComponents.add(i, measureComponent);
        }
    }

    public void paintMeasure(ViewLayout viewLayout, GC gC, int n, int n2, Rectangle rectangle, int n3) {
        this.setOutOfBounds(false);
        viewLayout.setDefaultStyle(gC);
        this.paintTempo(viewLayout, gC, n, n2);
        this.paintTripletFeel(viewLayout, gC, n, n2);
        this.paintTimeSignature(viewLayout, gC, n, n2);
        this.paintComponents(viewLayout, gC, n, n2, rectangle);
        this.paintDivisions(viewLayout, gC, n, n2);
        this.paintClef(viewLayout, gC, n, n2);
        this.paintKeySignature(viewLayout, gC, n, n2);
        this.paintCaret(viewLayout, gC, n, n2);
        this.paintPlayMode(viewLayout, gC, n, n2);
        this.lastFromX = n;
        this.lastFromY = n2;
    }

    public void paintMeasure(ViewLayout viewLayout, GC gC, int n, int n2, Rectangle rectangle) {
        this.paintMeasure(viewLayout, gC, n, n2, rectangle, 0);
    }

    public void paintComponents(ViewLayout viewLayout, GC gC, int n, int n2, Rectangle rectangle) {
        viewLayout.setNoteStyle(gC);
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent = (MeasureComponent)this.measureComponents.get(i);
            measureComponent.paint(viewLayout, gC, n + 15, n2);
        }
        viewLayout.setDefaultStyle(gC);
        gC.setForeground(this.tablature.getDisplay().getSystemColor(2));
    }

    public void paintCaret(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (viewLayout.isCaretVisible() && this.hasCaret()) {
            int n3 = 15 + this.getFirstNoteSpan();
            if (viewLayout.isScoreEnabled()) {
                n2 += viewLayout.getScoreSpan();
            }
            this.caret.paintCaret(gC, n + n3, n2);
        }
    }

    private void paintDivisions(ViewLayout viewLayout, GC gC, int n, int n2) {
        int n3;
        int n4;
        if (viewLayout.isScoreEnabled()) {
            n4 = n2 + viewLayout.getScoreLineSpan();
            int n5 = n3 = n2 + viewLayout.getScoreLineSpan() * 5;
            if (this.isFirstMeasure() || this.isFirstOfLine()) {
                n5 = n4 + viewLayout.getScoreSpan() + viewLayout.getStringSpan();
            }
            if (this.measure.isRepeatStart()) {
                gC.setLineWidth(3);
                gC.drawLine(n, n4, n, n5);
                gC.drawOval(n + 7, n4 + (n3 - n4) / 2 - 7, 1, 2);
                gC.drawOval(n + 7, n4 + (n3 - n4) / 2 + 7, 1, 2);
                gC.setLineWidth(1);
                gC.drawLine(n + 3, n4, n + 3, n5);
            } else if (this.isFirstMeasure()) {
                gC.setLineWidth(3);
                gC.drawLine(n, n4, n, n5);
                gC.setLineWidth(1);
                gC.drawLine(n + 3, n4, n + 3, n5);
            } else {
                gC.drawLine(n, n4, n, n5);
            }
            if (this.measure.getNumberOfRepetitions() > 0) {
                gC.setLineWidth(3);
                gC.drawLine(n + this.getWidth() + this.getSpan(), n4, n + this.getWidth() + this.getSpan(), n3);
                gC.drawOval(n + this.getWidth() - 8 + this.getSpan(), n4 + (n3 - n4) / 2 - 7, 2, 2);
                gC.drawOval(n + this.getWidth() - 8 + this.getSpan(), n4 + (n3 - n4) / 2 + 7, 2, 2);
                gC.setLineWidth(1);
                gC.drawLine(n + this.getWidth() - 3 + this.getSpan(), n4, n + this.getWidth() - 3 + this.getSpan(), n3);
                gC.drawString("x" + Integer.toString(this.measure.getNumberOfRepetitions()), n + this.getWidth() - 10 + this.getSpan(), n2 - 5);
            } else if (this.isLastMeasure()) {
                gC.setLineWidth(3);
                gC.drawLine(n + this.getWidth() + this.getSpan(), n4, n + this.getWidth() + this.getSpan(), n3);
                gC.setLineWidth(1);
                gC.drawLine(n + this.getWidth() - 3 + this.getSpan(), n4, n + this.getWidth() - 3 + this.getSpan(), n3);
            } else {
                gC.drawLine(n + this.getWidth() + this.getSpan(), n4, n + this.getWidth() + this.getSpan(), n3);
            }
            n2 += viewLayout.getScoreSpan();
        }
        n4 = n2 + viewLayout.getStringSpan();
        n3 = n2 + this.trackCoords.getTrack().getStrings().size() * viewLayout.getStringSpan();
        if (this.measure.isRepeatStart()) {
            gC.setLineWidth(3);
            gC.drawLine(n, n4, n, n3);
            gC.drawOval(n + 7, n4 + (n3 - n4) / 2 - 7, 1, 2);
            gC.drawOval(n + 7, n4 + (n3 - n4) / 2 + 7, 1, 2);
            gC.setLineWidth(1);
            gC.drawLine(n + 3, n4, n + 3, n3);
        } else if (this.isFirstMeasure()) {
            gC.setLineWidth(3);
            gC.drawLine(n, n4, n, n3);
            gC.setLineWidth(1);
            gC.drawLine(n + 3, n4, n + 3, n3);
        } else {
            gC.drawLine(n, n4, n, n3);
        }
        if (this.measure.getNumberOfRepetitions() > 0) {
            gC.setLineWidth(3);
            gC.drawLine(n + this.getWidth() + this.getSpan(), n4, n + this.getWidth() + this.getSpan(), n3);
            gC.drawOval(n + this.getWidth() - 8 + this.getSpan(), n4 + (n3 - n4) / 2 - 7, 2, 2);
            gC.drawOval(n + this.getWidth() - 8 + this.getSpan(), n4 + (n3 - n4) / 2 + 7, 2, 2);
            gC.setLineWidth(1);
            gC.drawLine(n + this.getWidth() - 3 + this.getSpan(), n4, n + this.getWidth() - 3 + this.getSpan(), n3);
            gC.drawString("x" + Integer.toString(this.measure.getNumberOfRepetitions()), n + this.getWidth() - 10 + this.getSpan(), n2 - 5);
        } else if (this.isLastMeasure()) {
            gC.setLineWidth(3);
            gC.drawLine(n + this.getWidth() + this.getSpan(), n4, n + this.getWidth() + this.getSpan(), n3);
            gC.setLineWidth(1);
            gC.drawLine(n + this.getWidth() - 3 + this.getSpan(), n4, n + this.getWidth() - 3 + this.getSpan(), n3);
        } else {
            gC.drawLine(n + this.getWidth() + this.getSpan(), n4, n + this.getWidth() + this.getSpan(), n3);
        }
    }

    private void paintClef(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (viewLayout.isScoreEnabled() && this.paintClef) {
            if (this.measure.getClef() == 1) {
                gC.drawImage(SystemImages.CLEF_TREBLE, 0, 0, this.clefSrcBounds.width, this.clefSrcBounds.height, n + 14, n2, this.clefDstBounds.width, this.clefDstBounds.height);
            } else if (this.measure.getClef() == 2) {
                gC.drawImage(SystemImages.CLEF_BASS, 0, 0, this.clefSrcBounds.width, this.clefSrcBounds.height, n + 14, n2 + 6, this.clefDstBounds.width, this.clefDstBounds.height);
            } else if (this.measure.getClef() == 3) {
                gC.drawImage(SystemImages.CLEF_TENOR, 0, 0, this.clefSrcBounds.width, this.clefSrcBounds.height, n + 14, n2 - 2, this.clefDstBounds.width, this.clefDstBounds.height);
            } else if (this.measure.getClef() == 4) {
                gC.drawImage(SystemImages.CLEF_ALTO, 0, 0, this.clefSrcBounds.width, this.clefSrcBounds.height, n + 14, n2 + 8, this.clefDstBounds.width, this.clefDstBounds.height);
            }
        }
    }

    private void paintKeySignature(ViewLayout viewLayout, GC gC, int n, int n2) {
        n += this.getClefSpan();
        if (viewLayout.isScoreEnabled() && this.paintKeySignature) {
            int n3 = n + 10;
            double d = viewLayout.getScoreLineSpan() / 2;
            double d2 = (double)n2 - d;
            double d3 = 0.0;
            switch (this.measure.getClef()) {
                case 1: {
                    d3 = 0.0;
                    break;
                }
                case 2: {
                    d3 = 2.0;
                    break;
                }
                case 3: {
                    d3 = -1.0;
                    break;
                }
                case 4: {
                    d3 = 1.0;
                }
            }
            if (this.measure.getKeySignature() >= 1 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n3 += 6, n2, d, 1 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 1 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 1 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 2 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n3 += 6, n2, d, 4 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 2 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 4 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 3 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n3 += 6, n2, d, 0 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 3 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 0 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 4 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n3 += 6, n2, d, 3 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 4 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 3 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 5 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n3 += 6, n2, d, 6 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 5 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 6 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 6 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n3 += 6, n2, d, 2 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 6 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 2 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 7 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n3 += 6, n2, d, 5 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 7 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 5 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 8) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n3 += 6, n2, d, 5 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 8) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 5 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 9) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n3 += 6, n2, d, 2 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 9) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 2 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 10) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n3 += 6, n2, d, 6 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 10) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 6 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 11) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n3 += 6, n2, d, 3 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 11) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 3 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 12) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n3 += 6, n2, d, 0 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 12) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 0 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 13) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n3 += 6, n2, d, 4 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 13) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 4 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 14) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n3 += 6, n2, d, 1 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 14) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n3 += 6, n2, d, 1 + (int)d3, d2, 9);
            }
        }
    }

    private void paintKeySignatureImage(GC gC, Image image, int n, int n2, double d, int n3, double d2, int n4) {
        int n5 = (int)((double)n2 + d + d * (double)n3 - (double)n4);
        n5 = (int)(n3 < 0 ? (double)n5 + d * 7.0 : (double)n5);
        gC.drawImage(image, n, n5);
    }

    private void paintTimeSignature(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (this.paintTimeSignature) {
            viewLayout.setTimeSignatureStyle(gC);
            n += this.getClefSpan();
            n += this.getKeySignatureSpan();
            if (viewLayout.isScoreEnabled()) {
                int n3 = viewLayout.getScoreLineSpan() * 5 / 2;
                int n4 = n + 15 + 10;
                int n5 = n2 + (n3 - 14);
                int n6 = n2 + (n3 + 5);
                gC.drawString(Integer.toString(this.getMeasure().getTimeSignature().getNumerator()), n4, n5);
                gC.drawString(Integer.toString(this.getMeasure().getTimeSignature().getDenominator().getValue()), n4, n6);
                n2 += viewLayout.getScoreSpan();
            } else {
                int n7 = this.trackCoords.getTrack().getStrings().size() * viewLayout.getStringSpan();
                int n8 = n7 / 2;
                int n9 = n + 15 + 10;
                int n10 = n2 + (n8 - 12);
                int n11 = n2 + (n8 + 5);
                gC.drawString(Integer.toString(this.getMeasure().getTimeSignature().getNumerator()), n9, n10);
                gC.drawString(Integer.toString(this.getMeasure().getTimeSignature().getDenominator().getValue()), n9, n11);
            }
            viewLayout.setDefaultStyle(gC);
        }
    }

    private void paintTempo(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (this.paintTempo) {
            int n3 = n;
            int n4 = n2 - 10;
            gC.drawImage(SystemImages.TEMPO_IMAGE, n3 - 5, n4 - 10);
            gC.drawString(" = " + this.getMeasure().getTempo().getValue(), n3 + 10, n4 - 3);
        }
    }

    private void paintTripletFeel(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (this.paintTripletFeel) {
            int n3 = n + this.getTempoSpan();
            int n4 = n2 - 10;
            gC.drawImage(SystemImages.getTripletFeel(this.getMeasure().getTripletFeel()), n3 + 15, n4 - 13);
        }
    }

    private void paintPlayMode(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (viewLayout.isPlayModeEnabled() && this.isPlaying()) {
            gC.setLineStyle(2);
            gC.drawRectangle(n + 5, n2, this.getWidth() + this.getSpan() - 10, this.getTabHeight() + this.getScoreSpan() + 10);
            gC.setLineStyle(1);
        }
    }

    public boolean isPlaying() {
        long l;
        return this.songManager.getPlayer().isRunning() && this.getTrackCoords().hasCaret() && (l = this.songManager.getPlayer().getTickPosition()) >= this.getMeasure().getStart() && l < this.getMeasure().getStart() + this.getMeasure().getLength();
    }

    public int getSpanForComponent(MeasureComponent measureComponent) {
        return (int)((measureComponent.getStart() - this.getMeasure().getStart()) * (long)this.getSpan() / this.getMeasure().getLength());
    }

    public boolean hasTrack(int n) {
        return this.trackCoords.getTrack().getNumber() == (long)n;
    }

    public int getWidth() {
        return this.width;
    }

    public int getTabHeight() {
        return this.tabHeight;
    }

    public int getTimeSignatureSpan() {
        int n = 0;
        if (this.paintTimeSignature) {
            n = 40;
        }
        return n;
    }

    public int getClefSpan() {
        int n = 0;
        if (this.paintClef) {
            n = 40;
        }
        return n;
    }

    public int getKeySignatureSpan() {
        int n = 0;
        if (this.paintKeySignature) {
            n = this.measure.getKeySignature() <= 7 ? (n += 6 * this.measure.getKeySignature()) : (n += 6 * (this.measure.getKeySignature() - 7));
            if (this.prevMeasure != null) {
                n = this.prevMeasure.getKeySignature() <= 7 ? (n += 6 * this.prevMeasure.getKeySignature()) : (n += 6 * (this.prevMeasure.getKeySignature() - 7));
            }
        }
        return n;
    }

    public int getTempoSpan() {
        int n = 0;
        if (this.paintTempo) {
            n += 40;
        }
        return n;
    }

    public int getTripletFeelSpan() {
        int n = 0;
        if (this.paintTripletFeel) {
            n += 50;
        }
        return n;
    }

    public int getFirstNoteSpan() {
        boolean bl = false;
        int n = this.getTempoSpan() + this.getTripletFeelSpan();
        int n2 = this.getClefSpan() + this.getKeySignatureSpan() + this.getTimeSignatureSpan();
        return Math.max(n, n2);
    }

    public MeasureComponent getPreviousComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent3.getStart() >= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() > measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getFirstComponent() {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent != null && measureComponent2.getStart() >= measureComponent.getStart()) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public MeasureComponent getLastComponent() {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent != null && measureComponent.getStart() >= measureComponent2.getStart()) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public MeasureComponent getComponent(long l) {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent2.getStart() > l || measureComponent2.getStart() + measureComponent2.getDuration().getTime() <= l) continue;
            measureComponent = measureComponent2;
            break;
        }
        return measureComponent;
    }

    public List getComponents(long l) {
        ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
        for (MeasureComponent measureComponent : this.measureComponents) {
            if (measureComponent.getStart() != l) continue;
            arrayList.add(measureComponent);
        }
        return arrayList;
    }

    public List getComponentsBetween(long l) {
        ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
        for (MeasureComponent measureComponent : this.measureComponents) {
            if (measureComponent.getStart() > l || measureComponent.getStart() + measureComponent.getDuration().getTime() <= l) continue;
            arrayList.add(measureComponent);
        }
        return arrayList;
    }

    public MeasureComponent getComponent(long l, int n) {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            NoteCoords noteCoords;
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent2 instanceof NoteCoords) || (noteCoords = (NoteCoords)measureComponent2).getStart() > l || noteCoords.getStart() + noteCoords.getDuration().getTime() <= l || noteCoords.getNote().getString() != n) continue;
            measureComponent = measureComponent2;
            break;
        }
        return measureComponent;
    }

    public MeasureComponent getComponentOrSilence(long l, int n) {
        MeasureComponent measureComponent = this.getComponent(l, n);
        if (measureComponent == null && !((measureComponent = this.getComponent(l)) instanceof SilenceCoords)) {
            measureComponent = null;
        }
        return measureComponent;
    }

    public List getComponentsBeforeEnd(long l) {
        ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
        for (MeasureComponent measureComponent : this.measureComponents) {
            if (measureComponent.getStart() < l) continue;
            arrayList.add(measureComponent);
        }
        return arrayList;
    }

    public List getComponents() {
        return this.measureComponents;
    }

    public MeasureComponent getNextNoteComponent(MeasureComponent measureComponent, int n) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            Note note;
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof NoteCoords) || (note = ((NoteCoords)measureComponent3).getNote()).getString() != n || note.getStart() <= measureComponent.getStart() || measureComponent2 != null && note.getStart() >= measureComponent2.getStart()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextNoteComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof NoteCoords) || measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextSilenceComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof SilenceCoords) || measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getComponentAt(int n) {
        MeasureComponent measureComponent = null;
        for (MeasureComponent measureComponent2 : this.measureComponents) {
            if (measureComponent == null) {
                measureComponent = measureComponent2;
                continue;
            }
            int n2 = Math.abs(n - measureComponent.getPointX());
            int n3 = Math.abs(n - measureComponent2.getPointX());
            if (n3 >= n2) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public InstrumentString getStringAt(int n) {
        InstrumentString instrumentString = null;
        int n2 = this.tablature.getViewLayout().getStringSpan();
        int n3 = 0;
        int n4 = this.lastFromY;
        n4 += this.getScoreSpan();
        for (InstrumentString instrumentString2 : this.trackCoords.getTrack().getStrings()) {
            int n5 = Math.abs(n - (instrumentString2.getNumber() * n2 + n4));
            if (instrumentString != null && n5 >= n3) continue;
            instrumentString = instrumentString2;
            n3 = n5;
        }
        return instrumentString;
    }

    public long getBeatLength() {
        return this.beatLength;
    }

    public boolean areInSameBeat(MeasureComponent measureComponent, MeasureComponent measureComponent2) {
        return this.songManager.getMeasureManager().areInSameBeat(this.measure, measureComponent.getComponent(), measureComponent2.getComponent());
    }

    public boolean isFirstMeasure() {
        return this.songManager.getTrackManager().isFirstMeasure(this.measure);
    }

    public boolean isLastMeasure() {
        return this.songManager.getTrackManager().isLastMeasure(this.trackCoords.getTrack(), this.measure);
    }

    public void playBeat(long l) {
        if (!this.songManager.getPlayer().isRunning()) {
            List list = this.songManager.getMeasureManager().getNotes(this.measure, l);
            this.songManager.getPlayer().playBeat(this.getTrackCoords().getTrack(), list);
        }
    }

    public boolean hasCaret() {
        return this.caret != null;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        this.caret = caret;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    public int getLastFromX() {
        return this.lastFromX;
    }

    public int getLastFromY() {
        return this.lastFromY;
    }

    public void setQuarterSpan(int n) {
        this.quarterSpan = n;
    }

    public int getQuarterSpan() {
        return this.quarterSpan;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int n) {
        this.span = n;
    }

    public boolean isOutOfBounds() {
        return this.outOfBounds;
    }

    public void setOutOfBounds(boolean bl) {
        this.outOfBounds = bl;
    }

    public boolean isFirstOfLine() {
        return this.firstOfLine;
    }

    public void setFirstOfLine(boolean bl) {
        this.firstOfLine = bl;
    }

    public SongTrackCoords getTrackCoords() {
        return this.trackCoords;
    }

    public int getScoreSpan() {
        return this.scoreSpan;
    }

    public void setScoreSpan(int n) {
        this.scoreSpan = n;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMinY() {
        return this.minY;
    }
}

