/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.plugins.JarClassLoader;
import org.herac.tuxguitar.gui.plugins.TGPlugin;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class PluginManager {
    public static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    public static final String PROPERTY_PLUGIN_CLASS = "plugin.class";
    private static final String LANGUAGE_FOLDER = "lang";
    private List plugins = new ArrayList();
    private List pluginItems = new ArrayList();

    public PluginManager() {
        this.loadPlugins();
    }

    public List getPlugins() {
        return this.plugins;
    }

    public List getPluginItems() {
        return this.pluginItems;
    }

    private void loadPlugins() {
        File file;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.indexOf("plugin_") != -1 && string.indexOf(".properties") != -1;
            }
        };
        String string = TuxGuitarFileUtils.PLUGINS_PREFIX;
        if (string != null && (file = new File(string)) != null) {
            String[] stringArray = file.list(filenameFilter);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    this.loadPLugin(string + File.separator + stringArray[i]);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
        }
    }

    private void loadPLugin(String string) throws FileNotFoundException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(string));
            String string2 = properties.getProperty(PROPERTY_PLUGIN_PATH, new String());
            String string3 = properties.getProperty(PROPERTY_PLUGIN_CLASS, new String());
            File file = new File(string2);
            if (file != null && file.exists()) {
                Object obj;
                Class<?> clazz;
                ClassLoader classLoader = null;
                if (file.isDirectory()) {
                    classLoader = new URLClassLoader(new URL[]{new File(string2).toURL()}, this.getClass().getClassLoader());
                } else if (file.getName().endsWith(".jar")) {
                    classLoader = new JarClassLoader(new JarFile(string2));
                }
                if (classLoader != null && (clazz = classLoader.loadClass(string3)) != null && (obj = clazz.newInstance()) instanceof TGPlugin) {
                    TGPlugin tGPlugin = (TGPlugin)obj;
                    this.plugins.add(tGPlugin);
                    if (tGPlugin.getItem().isEnabled()) {
                        this.pluginItems.add(tGPlugin);
                    }
                }
            }
        }
        catch (Exception exception) {
            TuxGuitar.instance().showErrorMessage(exception);
        }
        catch (Error error) {
            TuxGuitar.instance().showErrorMessage(error);
        }
    }

    public void initPLugins() {
        for (TGPlugin tGPlugin : this.plugins) {
            tGPlugin.init(TuxGuitar.instance());
        }
    }

    public void closePLugins() {
        for (TGPlugin tGPlugin : this.plugins) {
            tGPlugin.close();
        }
    }

    private void showErrorMessage() {
    }
}

