/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.marker;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.undoables.JoinedUndoable;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeMarker;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.RGBColor;

public class MarkerEditor {
    public static final int STATUS_NEW = 1;
    public static final int STATUS_EDIT = 2;
    private int status;
    private Marker marker;
    private Shell dialog;
    private Spinner measureSpinner;
    private Text titleText;
    private Button colorButton;

    public MarkerEditor(Marker marker) {
        this(marker, 1);
    }

    public MarkerEditor(Marker marker, int n) {
        this.marker = (Marker)marker.clone();
        this.status = n;
    }

    public void show(Shell shell) {
        this.dialog = new Shell(shell, 67680);
        this.dialog.setLayout(new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("marker.editor"));
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout(4, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        final int n = TuxGuitar.instance().getSongManager().countMeasures();
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label.setText(TuxGuitar.getProperty("measure"));
        GridData gridData = new GridData();
        gridData.widthHint = 26;
        gridData.verticalAlignment = 0x1000000;
        gridData.grabExcessVerticalSpace = true;
        this.measureSpinner = new Spinner(composite, 2048);
        this.measureSpinner.setLayoutData(gridData);
        this.measureSpinner.setMinimum(1);
        this.measureSpinner.setMaximum(n);
        this.measureSpinner.setSelection(this.marker.getMeasure());
        this.measureSpinner.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n2 = MarkerEditor.this.measureSpinner.getSelection();
                if (n2 < 1) {
                    MarkerEditor.this.measureSpinner.setSelection(1);
                } else if (n2 > n) {
                    MarkerEditor.this.measureSpinner.setSelection(n);
                }
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label2.setText(TuxGuitar.getProperty("color"));
        this.colorButton = new Button(composite, 8);
        this.setButtonColor(this.colorButton, new Color(this.dialog.getDisplay(), this.marker.getColor().getR(), this.marker.getColor().getG(), this.marker.getColor().getB()));
        this.colorButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(MarkerEditor.this.dialog);
                colorDialog.setRGB(MarkerEditor.this.dialog.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    MarkerEditor.this.setButtonColor(MarkerEditor.this.colorButton, new Color(MarkerEditor.this.dialog.getDisplay(), rGB));
                }
            }
        });
        Label label3 = new Label(composite, 0);
        label3.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label3.setText(TuxGuitar.getProperty("title"));
        this.titleText = new Text(composite, 2048);
        this.titleText.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.titleText.setText(this.marker.getTitle());
        Composite composite2 = new Composite(this.dialog, 0);
        composite2.setLayout(new GridLayout(2, false));
        composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.minimumWidth = 80;
        gridData2.minimumHeight = 25;
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(gridData2);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerEditor.this.updateMarker();
                MarkerEditor.this.dialog.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData(gridData2);
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerEditor.this.dialog.dispose();
            }
        });
        this.dialog.pack();
        this.dialog.open();
        int n2 = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n3 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n2, n3);
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
    }

    private void setButtonColor(Button button, Color color) {
        Image image = new Image((Device)this.dialog.getDisplay(), 25, 25);
        GC gC = new GC(image);
        gC.setBackground(color);
        gC.fillRectangle(0, 0, 25, 25);
        gC.dispose();
        button.setImage(image);
        this.marker.setColor(new RGBColor(color.getRed(), color.getGreen(), color.getBlue()));
    }

    private void updateMarker() {
        UndoableChangeMarker undoableChangeMarker;
        int n = this.marker.getMeasure();
        this.marker.setMeasure(this.measureSpinner.getSelection());
        this.marker.setTitle(this.titleText.getText());
        this.marker = (Marker)this.marker.clone();
        SongManager songManager = TuxGuitar.instance().getSongManager();
        JoinedUndoable joinedUndoable = new JoinedUndoable();
        if (this.status == 2 && n != this.marker.getMeasure()) {
            undoableChangeMarker = UndoableChangeMarker.startUndo(songManager.getMarker(n));
            TuxGuitar.instance().getSongManager().removeMarker(n);
            joinedUndoable.addUndoableEdit(undoableChangeMarker.endUndo(null));
        }
        undoableChangeMarker = UndoableChangeMarker.startUndo(songManager.getMarker(this.marker.getMeasure()));
        TuxGuitar.instance().getSongManager().updateMarker(this.marker);
        joinedUndoable.addUndoableEdit(undoableChangeMarker.endUndo(this.marker));
        TuxGuitar.instance().getTablatureEditor().getUndoManager().addEdit(joinedUndoable.endUndo());
    }
}

