/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;

public class MeasureMenuItem
implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private MenuItem measureMenuItem;
    private Menu menu;
    private MenuItem first;
    private MenuItem last;
    private MenuItem next;
    private MenuItem previous;
    private MenuItem addMeasure;
    private MenuItem removeMeasure;
    private MenuItem copyMeasure;
    private MenuItem pasteMeasure;

    public MeasureMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.measureMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.first = new MenuItem(this.menu, 8);
        this.first.addSelectionListener(TuxGuitar.instance().getAction("GO_FIRST_MEASURE"));
        this.previous = new MenuItem(this.menu, 8);
        this.previous.addSelectionListener(TuxGuitar.instance().getAction("GO_PREVIOUS_MEASURE"));
        this.next = new MenuItem(this.menu, 8);
        this.next.addSelectionListener(TuxGuitar.instance().getAction("GO_NEXT_MEASURE"));
        this.last = new MenuItem(this.menu, 8);
        this.last.addSelectionListener(TuxGuitar.instance().getAction("GO_LAST_MEASURE"));
        new MenuItem(this.menu, 2);
        this.addMeasure = new MenuItem(this.menu, 8);
        this.addMeasure.addSelectionListener(TuxGuitar.instance().getAction("ADD_MEASURE"));
        this.removeMeasure = new MenuItem(this.menu, 8);
        this.removeMeasure.addSelectionListener(TuxGuitar.instance().getAction("REMOVE_MEASURE"));
        new MenuItem(this.menu, 2);
        this.copyMeasure = new MenuItem(this.menu, 8);
        this.copyMeasure.addSelectionListener(TuxGuitar.instance().getAction("COPY_MEASURE"));
        this.pasteMeasure = new MenuItem(this.menu, 8);
        this.pasteMeasure.addSelectionListener(TuxGuitar.instance().getAction("PASTE_MEASURE"));
        this.measureMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
        Caret caret = this.tablatureEditor.getTablature().getCaret();
        SongTrackCoords songTrackCoords = caret.getSongTrackCoords();
        MeasureCoords measureCoords = caret.getMeasureCoords();
        this.previous.setEnabled(measureCoords.getMeasure().getNumber() > 1);
        this.next.setEnabled(measureCoords.getMeasure().getNumber() < songTrackCoords.getTrack().getMeasures().size());
        this.pasteMeasure.setEnabled(!this.tablatureEditor.getClipBoard().isEmpty());
    }

    public void loadProperties() {
        this.measureMenuItem.setText(TuxGuitar.getProperty("measure"));
        this.first.setText(TuxGuitar.getProperty("measure.first"));
        this.last.setText(TuxGuitar.getProperty("measure.last"));
        this.previous.setText(TuxGuitar.getProperty("measure.previous"));
        this.next.setText(TuxGuitar.getProperty("measure.next"));
        this.addMeasure.setText(TuxGuitar.getProperty("measure.add"));
        this.removeMeasure.setText(TuxGuitar.getProperty("measure.remove"));
        this.copyMeasure.setText(TuxGuitar.getProperty("measure.copy"));
        this.pasteMeasure.setText(TuxGuitar.getProperty("measure.paste"));
    }
}

