/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.chord;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.gui.chord.ChordEditor;
import org.herac.tuxguitar.song.models.Chord;

public class ChordList
extends Composite {
    private ChordEditor editor;
    private List graphicChords;
    private int height;
    private int selectedChord;

    public ChordList(Composite composite) {
        super(composite, 2560);
        this.setLayout(new GridLayout());
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.graphicChords = new ArrayList();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                ChordList.this.paintChords(paintEvent.gc);
                paintEvent.gc.dispose();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                ChordList.this.showChord(ChordList.this.getChord(mouseEvent.x, mouseEvent.y, true));
                ChordList.this.redraw();
            }
        });
        final Point point = new Point(0, 0);
        final ScrollBar scrollBar = this.getVerticalBar();
        scrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = scrollBar.getSelection();
                int n2 = -n - point.y;
                Rectangle rectangle = ChordList.this.getBounds();
                ChordList.this.getShell().scroll(0, n2, 0, 0, rectangle.width, rectangle.height, false);
                point.y = -n;
                ChordList.this.redraw();
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 170;
        this.setLayoutData(gridData);
    }

    private void paintChords(GC gC) {
        int n = 20;
        int n2 = 20;
        int n3 = this.getVerticalBar().getSelection();
        for (GraphicChord graphicChord : this.graphicChords) {
            if (n + graphicChord.getWidth() >= this.getBounds().x + this.getBounds().width - 30) {
                n = 20;
                n2 += graphicChord.getHeigth() + 20;
            }
            graphicChord.paintChord(gC, n, n2 - n3, this.selectedChord);
            n += graphicChord.getWidth() + 30;
        }
        this.height = n2 + 50;
        this.updateScroll();
    }

    public void updateScroll() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getClientArea();
        ScrollBar scrollBar = this.getVerticalBar();
        scrollBar.setMaximum(this.height + 20);
        scrollBar.setThumb(Math.min(rectangle.height, rectangle2.height));
    }

    private Chord getChord(int n, int n2, boolean bl) {
        for (GraphicChord graphicChord : this.graphicChords) {
            int n3 = graphicChord.getX();
            int n4 = n3 + graphicChord.getWidth();
            int n5 = graphicChord.getY();
            int n6 = n5 + graphicChord.getHeigth();
            if (n <= n3 || n >= n4 || n2 <= n5 || n2 >= n6) continue;
            if (bl) {
                this.selectedChord = graphicChord.getId();
            }
            return graphicChord.getChord();
        }
        return null;
    }

    private void showChord(Chord chord) {
        if (chord != null) {
            int n;
            int n2;
            int n3 = -1;
            for (n2 = 0; n2 < chord.getStrings().length; ++n2) {
                n = chord.getFretValue(n2);
                if (n3 >= 0 && (n >= n3 || n < 0)) continue;
                n3 = n;
            }
            this.editor.setFret((short)(n3 <= 0 ? 1 : n3));
            for (n2 = 0; n2 < chord.getStrings().length; ++n2) {
                n = chord.getFretValue(n2);
                this.editor.addValue(n, n2 + 1);
            }
            this.editor.redraw();
        }
    }

    public void setEditor(ChordEditor chordEditor) {
        this.editor = chordEditor;
    }

    public void setChords(List list) {
        int n = 0;
        this.graphicChords.clear();
        this.selectedChord = 0;
        for (Chord chord : list) {
            this.graphicChords.add(new GraphicChord(chord, ++n));
        }
    }

    private class GraphicChord {
        private static final int STRING_SPAN = 8;
        private static final int FRET_SPAN = 10;
        private Chord chord;
        private int id;
        private int firstFret;
        private int x;
        private int y;
        private int width = 100;
        private int heigth = 100;

        public GraphicChord(Chord chord, int n) {
            this.chord = chord;
            this.id = n;
            this.width = 8 * this.getChord().getStrings().length - 8;
            this.heigth = 50;
            this.firstFret = -1;
            for (int i = 0; i < chord.getStrings().length; ++i) {
                int n2 = chord.getFretValue(i);
                if (this.firstFret >= 0 && (n2 >= this.firstFret || n2 < 0)) continue;
                this.firstFret = n2;
            }
            this.firstFret = this.firstFret <= 0 ? 1 : this.firstFret;
        }

        private void paintChord(GC gC, int n, int n2, int n3) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.getId() == n3) {
                gC.setForeground(ChordList.this.getDisplay().getSystemColor(9));
            } else {
                gC.setForeground(ChordList.this.getDisplay().getSystemColor(2));
            }
            this.x = n;
            this.y = n2;
            for (n8 = 0; n8 < this.getChord().getStrings().length; ++n8) {
                n7 = this.x + n8 * 8;
                n6 = this.x + n8 * 8;
                n5 = this.y;
                n4 = this.y + this.heigth;
                gC.drawLine(n7, n5, n6, n4);
            }
            for (n8 = 0; n8 < 6; ++n8) {
                n7 = this.x;
                n6 = this.x + this.width;
                n5 = this.y + n8 * 10;
                n4 = this.y + n8 * 10;
                gC.drawLine(n7, n5, n6, n4);
            }
            for (n8 = 0; n8 < this.getChord().getStrings().length; ++n8) {
                n7 = this.getChord().getFretValue(n8);
                if (n7 <= 0) continue;
                n6 = this.x + (this.width - 8 * n8) - 4;
                n5 = this.y + (10 * (n7 -= this.firstFret - 1) - 10) + 5;
                gC.setLineWidth(5);
                gC.drawOval(n6 + 4, n5, 1, 1);
                gC.setLineWidth(1);
            }
        }

        public Chord getChord() {
            return this.chord;
        }

        public void setChord(Chord chord) {
            this.chord = chord;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int n) {
            this.id = n;
        }

        public int getHeigth() {
            return this.heigth;
        }

        public void setHeigth(int n) {
            this.heigth = n;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.x = n;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.y = n;
        }
    }
}

