/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.bend;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.song.models.BendEffect;

public class BendEditor
extends Composite {
    public static final int X_SPAN = 30;
    public static final int Y_SPAN = 15;
    private static final int X_LENGTH = 13;
    private static final int Y_LENGTH = 9;
    private int[] x;
    private int[] y;
    private int width;
    private int height;
    private List points;

    public BendEditor(Composite composite, int n) {
        super(composite, n);
        this.init();
        this.setBackground(new Color(this.getDisplay(), 255, 255, 255));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                BendEditor.this.paintEditor(paintEvent.gc);
                paintEvent.gc.dispose();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                BendEditor.this.checkPoint(mouseEvent.x, mouseEvent.y);
                BendEditor.this.redraw();
            }
        });
    }

    private void init() {
        int n;
        this.x = new int[13];
        this.y = new int[9];
        this.width = 360;
        this.height = 120;
        this.points = new ArrayList();
        for (n = 0; n < this.x.length; ++n) {
            this.x[n] = (n + 1) * 30;
        }
        for (n = 0; n < this.y.length; ++n) {
            this.y[n] = (n + 1) * 15;
        }
    }

    private void paintEditor(GC gC) {
        int n;
        for (n = 0; n < this.x.length; ++n) {
            this.setStyleX(gC, n);
            gC.drawLine(this.x[n], 15, this.x[n], 15 + this.height);
        }
        for (n = 0; n < this.y.length; ++n) {
            this.setStyleY(gC, n);
            gC.drawLine(30, this.y[n], 30 + this.width, this.y[n]);
        }
        Iterator iterator = null;
        Point point = null;
        gC.setLineStyle(1);
        gC.setLineWidth(2);
        gC.setForeground(this.getDisplay().getSystemColor(15));
        for (Point point2 : this.points) {
            if (point != null) {
                gC.drawLine(point.x, point.y, point2.x, point2.y);
            }
            point = point2;
        }
        gC.setLineWidth(5);
        gC.setForeground(this.getDisplay().getSystemColor(2));
        for (Point point2 : this.points) {
            gC.drawRectangle(point2.x - 2, point2.y - 2, 5, 5);
        }
        gC.setLineWidth(1);
    }

    private void setStyleX(GC gC, int n) {
        gC.setLineStyle(1);
        if (n == 0 || n == 12) {
            gC.setForeground(this.getDisplay().getSystemColor(2));
        } else {
            gC.setForeground(this.getDisplay().getSystemColor(9));
            if (n % 3 > 0) {
                gC.setLineStyle(3);
            }
        }
    }

    private void setStyleY(GC gC, int n) {
        gC.setLineStyle(1);
        if (n == 0 || n == 8) {
            gC.setForeground(this.getDisplay().getSystemColor(2));
        } else {
            gC.setForeground(this.getDisplay().getSystemColor(3));
            if (n % 2 > 0) {
                gC.setLineStyle(3);
                gC.setForeground(this.getDisplay().getSystemColor(15));
            } else if (n % 4 > 0) {
                gC.setLineStyle(3);
            }
        }
    }

    private void checkPoint(int n, int n2) {
        Point point = new Point(this.getX(n), this.getY(n2));
        if (!this.removePoint(point)) {
            this.removePointsAtXLine(point.x);
            this.addPoint(point);
            this.orderPoints();
        }
    }

    private boolean removePoint(Point point) {
        for (Point point2 : this.points) {
            if (point2.x != point.x || point2.y != point.y) continue;
            this.points.remove(point);
            return true;
        }
        return false;
    }

    private void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = null;
            for (int j = i; j < this.points.size(); ++j) {
                Point point2 = (Point)this.points.get(j);
                if (point != null && point2.x >= point.x) continue;
                point = point2;
            }
            this.points.remove(point);
            this.points.add(i, point);
        }
    }

    private void removePointsAtXLine(int n) {
        for (Point point : this.points) {
            if (point.x != n) continue;
            this.points.remove(point);
            break;
        }
    }

    private void addPoint(Point point) {
        this.points.add(point);
    }

    private int getX(int n) {
        int n2 = -1;
        for (int i = 0; i < this.x.length; ++i) {
            if (n2 < 0) {
                n2 = this.x[i];
                continue;
            }
            int n3 = Math.abs(n - n2);
            int n4 = Math.abs(n - this.x[i]);
            if (n4 >= n3) continue;
            n2 = this.x[i];
        }
        return n2;
    }

    private int getY(int n) {
        int n2 = -1;
        for (int i = 0; i < this.y.length; ++i) {
            if (n2 < 0) {
                n2 = this.y[i];
                continue;
            }
            int n3 = Math.abs(n - n2);
            int n4 = Math.abs(n - this.y[i]);
            if (n4 >= n3) continue;
            n2 = this.y[i];
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public void addBendPoints(BendEffect bendEffect) {
        for (Point point : this.points) {
            this.addBendPoint(bendEffect, point);
        }
    }

    private void addBendPoint(BendEffect bendEffect, Point point) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.x.length; ++n) {
            if (point.x != this.x[n]) continue;
            n2 = n;
        }
        for (n = 0; n < this.y.length; ++n) {
            if (point.y != this.y[n]) continue;
            n3 = this.y.length - n - 1;
        }
        bendEffect.addPoint(n2, n3);
    }

    public void setBend(BendEffect bendEffect) {
        this.points.clear();
        for (BendEffect.BendPoint bendPoint : bendEffect.getPoints()) {
            this.makePoint(bendPoint);
        }
    }

    private void makePoint(BendEffect.BendPoint bendPoint) {
        Point point = new Point(0, 0);
        point.x = this.x[bendPoint.getPosition()];
        point.y = this.y[this.y.length - bendPoint.getValue() - 1];
        this.points.add(point);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

