/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.settings;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.config.SystemConfigManager;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class EditConfigAction
extends Action {
    public static final String NAME = "EDIT_CONFIG";
    private SystemConfigManager config = TuxGuitar.instance().getConfig();
    private Shell dialog;
    private Option[] options;

    public EditConfigAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        this.dialog = new Shell(shell, 67680);
        this.dialog.setLayout(new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("settings.config"));
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout(2, false));
        this.createComposites(composite);
        Composite composite2 = new Composite(this.dialog, 0);
        composite2.setLayout(new GridLayout(2, true));
        composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
        Button button = new Button(composite2, 8);
        button.setLayoutData(this.makeGridData(80, 25));
        button.setText(TuxGuitar.getProperty("ok"));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditConfigAction.this.updateOptions();
                if (new ConfirmDialog(EditConfigAction.this.dialog, TuxGuitar.getProperty("settings.config.apply-changes-question")).confirm()) {
                    TuxGuitar.instance().reloadConfig();
                    TuxGuitar.instance().fireUpdate();
                    TuxGuitar.instance().redraw();
                }
                EditConfigAction.this.dialog.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setLayoutData(this.makeGridData(80, 25));
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditConfigAction.this.dialog.dispose();
            }
        });
        this.dialog.pack();
        this.dialog.open();
        int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n, n2);
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
    }

    private void createComposites(Composite composite) {
        ToolBar toolBar = new ToolBar(composite, 2560);
        toolBar.setLayoutData(this.makeGridData(60, 350));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new FormLayout());
        composite2.setLayoutData(this.makeGridData(250, 350));
        this.initOptions(toolBar, composite2);
        this.select(this.options[0]);
    }

    protected GridData makeGridData(int n, int n2) {
        return this.makeGridData(0, 0, n, n2);
    }

    protected GridData makeGridData(int n, int n2, int n3, int n4) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n3;
        gridData.minimumHeight = n4;
        if (n > 0) {
            gridData.widthHint = n;
        } else {
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
        }
        if (n2 > 0) {
            gridData.heightHint = n;
        } else {
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
        }
        return gridData;
    }

    private void initOptions(ToolBar toolBar, Composite composite) {
        this.options = new Option[4];
        this.options[0] = new ViewOption(this.config, toolBar, composite);
        this.options[1] = new StylesOption(this.config, toolBar, composite);
        this.options[2] = new SoundOption(this.config, toolBar, composite);
        this.options[3] = new LanguageOption(this.config, toolBar, composite);
        for (int i = 0; i < this.options.length; ++i) {
            this.options[i].createOption();
        }
    }

    private void select(Option option) {
        this.hideAll();
        option.setVisible(true);
        this.dialog.layout();
    }

    private void hideAll() {
        for (int i = 0; i < this.options.length; ++i) {
            this.options[i].setVisible(false);
            this.options[i].setVisible(false);
        }
    }

    private void updateOptions() {
        this.config.clear();
        for (int i = 0; i < this.options.length; ++i) {
            this.options[i].updateConfig();
        }
        this.config.save();
    }

    private class SoundOption
    extends Option {
        private Button useDefaultSoundbank;
        private Button useCustomSoundbank;
        private Text fileText;
        private Button fileButton;

        public SoundOption(SystemConfigManager systemConfigManager, ToolBar toolBar, Composite composite) {
            super(systemConfigManager, toolBar, composite, TuxGuitar.getProperty("settings.config.sound"));
        }

        public void createOption() {
            this.getToolItem().setText(TuxGuitar.getProperty("settings.config.sound"));
            this.getToolItem().setImage(SystemImages.OPTION_SOUND);
            this.getToolItem().addSelectionListener(this);
            Label label = new Label(this.getComposite(), 0);
            label.setText(TuxGuitar.getProperty("settings.config.sound.soundbank"));
            this.useDefaultSoundbank = new Button(this.getComposite(), 16);
            this.useDefaultSoundbank.setLayoutData(this.getTabbedData());
            this.useDefaultSoundbank.setText(TuxGuitar.getProperty("settings.config.sound.default-soundbank"));
            this.useCustomSoundbank = new Button(this.getComposite(), 16);
            this.useCustomSoundbank.setLayoutData(this.getTabbedData());
            this.useCustomSoundbank.setText(TuxGuitar.getProperty("settings.config.sound.custom-soundbank"));
            Composite composite = new Composite(this.getComposite(), 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(this.getTabbedData(20));
            this.fileText = new Text(composite, 2048);
            this.fileText.setLayoutData(EditConfigAction.this.makeGridData(150, 0, 0, 0));
            this.fileButton = new Button(composite, 8);
            this.fileButton.setLayoutData(EditConfigAction.this.makeGridData(80, 25));
            this.fileButton.setText(TuxGuitar.getProperty("choose"));
            this.fileButton.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = FileChooser.instance().open(EditConfigAction.this.dialog, FileChooser.ALL_FORMAT, null);
                    if (string != null) {
                        SoundOption.this.fileText.setText(string);
                        SoundOption.this.showRestartMessage();
                    }
                }
            });
            this.useDefaultSoundbank.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (SoundOption.this.useDefaultSoundbank.getSelection()) {
                        SoundOption.this.fileText.setEnabled(false);
                        SoundOption.this.fileButton.setEnabled(false);
                        SoundOption.this.showRestartMessage();
                    }
                }
            });
            this.useCustomSoundbank.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (SoundOption.this.useCustomSoundbank.getSelection()) {
                        SoundOption.this.fileText.setEnabled(true);
                        SoundOption.this.fileButton.setEnabled(true);
                    }
                }
            });
            boolean bl = this.getConfig().getBooleanConfigValue("SOUNDBANK_CUSTOM");
            this.useDefaultSoundbank.setSelection(!bl);
            this.useCustomSoundbank.setSelection(bl);
            this.fileText.setEnabled(bl);
            this.fileButton.setEnabled(bl);
            if (bl) {
                this.fileText.setText(this.getConfig().getStringConfigValue("SOUNDBANK_CUSTOM_PATH"));
            }
        }

        private void showRestartMessage() {
            String string = TuxGuitar.getProperty("warning");
            String string2 = TuxGuitar.getProperty("settings.config.sound.soundbank-restart-message");
            new MessageDialog(string, string2, 2).show(EditConfigAction.this.dialog);
        }

        public void updateConfig() {
            boolean bl = this.useCustomSoundbank.getSelection();
            this.getConfig().setProperty("SOUNDBANK_CUSTOM", bl);
            if (bl) {
                this.getConfig().setProperty("SOUNDBANK_CUSTOM_PATH", this.fileText.getText());
            } else {
                this.getConfig().removeProperty("SOUNDBANK_CUSTOM_PATH");
            }
        }
    }

    private class StylesOption
    extends Option {
        private FontData defaultFontData;
        private FontData noteFontData;
        private FontData timeSignatureFontData;
        private FontData printerDefaultFontData;
        private FontData printerNoteFontData;
        private FontData printerTimeSignatureFontData;
        private RGB scoreNoteRGB;
        private RGB tabNoteRGB;
        private RGB playNoteRGB;

        public StylesOption(SystemConfigManager systemConfigManager, ToolBar toolBar, Composite composite) {
            super(systemConfigManager, toolBar, composite, TuxGuitar.getProperty("settings.config.styles"));
            this.defaultFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("FONT_DEFAULT");
            this.noteFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("FONT_NOTE");
            this.timeSignatureFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("FONT_TIME_SIGNATURE");
            this.printerDefaultFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("FONT_PRINTER_DEFAULT");
            this.printerNoteFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("FONT_PRINTER_NOTE");
            this.printerTimeSignatureFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("FONT_PRINTER_TIME_SIGNATURE");
            this.scoreNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue("COLOR_SCORE_NOTE");
            this.tabNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue("COLOR_TAB_NOTE");
            this.playNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue("COLOR_PLAY_NOTE");
            if (this.scoreNoteRGB == null) {
                this.scoreNoteRGB = TuxGuitar.instance().getTablatureEditor().getTablature().getScoreNoteColor().getRGB();
            }
            if (this.tabNoteRGB == null) {
                this.tabNoteRGB = TuxGuitar.instance().getTablatureEditor().getTablature().getTabNoteColor().getRGB();
            }
            if (this.playNoteRGB == null) {
                this.playNoteRGB = TuxGuitar.instance().getTablatureEditor().getTablature().getPlayNoteColor().getRGB();
            }
        }

        public void createOption() {
            this.getToolItem().setText(TuxGuitar.getProperty("settings.config.styles"));
            this.getToolItem().setImage(SystemImages.OPTION_STYLE);
            this.getToolItem().addSelectionListener(this);
            Composite composite = new Composite(this.getComposite(), 0);
            composite.setLayout(new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText(TuxGuitar.getProperty("settings.config.styles.font.default"));
            Button button = new Button(composite, 8);
            button.setLayoutData(EditConfigAction.this.makeGridData(80, 25));
            button.setText(TuxGuitar.getProperty("choose"));
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Object object;
                    FontData[] fontDataArray = null;
                    if (StylesOption.this.defaultFontData != null) {
                        object = new Font((Device)EditConfigAction.this.dialog.getDisplay(), StylesOption.this.defaultFontData);
                        fontDataArray = ((Font)object).getFontData();
                        ((Font)object).dispose();
                    }
                    if (fontDataArray == null) {
                        fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getDefaultFont().getFontData();
                    }
                    object = new FontDialog(EditConfigAction.this.dialog);
                    ((FontDialog)object).setFontList(fontDataArray);
                    FontData fontData = ((FontDialog)object).open();
                    if (fontData != null) {
                        StylesOption.this.defaultFontData = fontData;
                    }
                }
            });
            Label label2 = new Label(composite, 0);
            label2.setText(TuxGuitar.getProperty("settings.config.styles.font.note"));
            Button button2 = new Button(composite, 8);
            button2.setLayoutData(EditConfigAction.this.makeGridData(80, 25));
            button2.setText(TuxGuitar.getProperty("choose"));
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Object object;
                    FontData[] fontDataArray = null;
                    if (StylesOption.this.noteFontData != null) {
                        object = new Font((Device)EditConfigAction.this.dialog.getDisplay(), StylesOption.this.noteFontData);
                        fontDataArray = ((Font)object).getFontData();
                        ((Font)object).dispose();
                    }
                    if (fontDataArray == null) {
                        fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getNoteFont().getFontData();
                    }
                    object = new FontDialog(EditConfigAction.this.dialog);
                    ((FontDialog)object).setFontList(fontDataArray);
                    FontData fontData = ((FontDialog)object).open();
                    if (fontData != null) {
                        StylesOption.this.noteFontData = fontData;
                    }
                }
            });
            Label label3 = new Label(composite, 0);
            label3.setText(TuxGuitar.getProperty("settings.config.styles.font.time-signature"));
            Button button3 = new Button(composite, 8);
            button3.setLayoutData(EditConfigAction.this.makeGridData(80, 25));
            button3.setText(TuxGuitar.getProperty("choose"));
            button3.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Object object;
                    FontData[] fontDataArray = null;
                    if (StylesOption.this.timeSignatureFontData != null) {
                        object = new Font((Device)EditConfigAction.this.dialog.getDisplay(), StylesOption.this.timeSignatureFontData);
                        fontDataArray = ((Font)object).getFontData();
                        ((Font)object).dispose();
                    }
                    if (fontDataArray == null) {
                        fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getTimeSignatureFont().getFontData();
                    }
                    object = new FontDialog(EditConfigAction.this.dialog);
                    ((FontDialog)object).setFontList(fontDataArray);
                    FontData fontData = ((FontDialog)object).open();
                    if (fontData != null) {
                        StylesOption.this.timeSignatureFontData = fontData;
                    }
                }
            });
            Label label4 = new Label(composite, 0);
            label4.setText(TuxGuitar.getProperty("settings.config.styles.font.printer-default"));
            Button button4 = new Button(composite, 8);
            button4.setLayoutData(EditConfigAction.this.makeGridData(80, 25));
            button4.setText(TuxGuitar.getProperty("choose"));
            button4.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Object object;
                    FontData[] fontDataArray = null;
                    if (StylesOption.this.printerDefaultFontData != null) {
                        object = new Font((Device)EditConfigAction.this.dialog.getDisplay(), StylesOption.this.printerDefaultFontData);
                        fontDataArray = ((Font)object).getFontData();
                        ((Font)object).dispose();
                    }
                    if (fontDataArray == null) {
                        fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterDefaultFont().getFontData();
                    }
                    object = new FontDialog(EditConfigAction.this.dialog);
                    ((FontDialog)object).setFontList(fontDataArray);
                    FontData fontData = ((FontDialog)object).open();
                    if (fontData != null) {
                        StylesOption.this.printerDefaultFontData = fontData;
                    }
                }
            });
            Label label5 = new Label(composite, 0);
            label5.setText(TuxGuitar.getProperty("settings.config.styles.font.printer-note"));
            Button button5 = new Button(composite, 8);
            button5.setLayoutData(EditConfigAction.this.makeGridData(80, 25));
            button5.setText(TuxGuitar.getProperty("choose"));
            button5.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Object object;
                    FontData[] fontDataArray = null;
                    if (StylesOption.this.printerNoteFontData != null) {
                        object = new Font((Device)EditConfigAction.this.dialog.getDisplay(), StylesOption.this.printerNoteFontData);
                        fontDataArray = ((Font)object).getFontData();
                        ((Font)object).dispose();
                    }
                    if (fontDataArray == null) {
                        fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterNoteFont().getFontData();
                    }
                    object = new FontDialog(EditConfigAction.this.dialog);
                    ((FontDialog)object).setFontList(fontDataArray);
                    FontData fontData = ((FontDialog)object).open();
                    if (fontData != null) {
                        StylesOption.this.printerNoteFontData = fontData;
                    }
                }
            });
            Label label6 = new Label(composite, 0);
            label6.setText(TuxGuitar.getProperty("settings.config.styles.font.printer-time-signature"));
            Button button6 = new Button(composite, 8);
            button6.setLayoutData(EditConfigAction.this.makeGridData(80, 25));
            button6.setText(TuxGuitar.getProperty("choose"));
            button6.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Object object;
                    FontData[] fontDataArray = null;
                    if (StylesOption.this.printerTimeSignatureFontData != null) {
                        object = new Font((Device)EditConfigAction.this.dialog.getDisplay(), StylesOption.this.printerTimeSignatureFontData);
                        fontDataArray = ((Font)object).getFontData();
                        ((Font)object).dispose();
                    }
                    if (fontDataArray == null) {
                        fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterTimeSignatureFont().getFontData();
                    }
                    object = new FontDialog(EditConfigAction.this.dialog);
                    ((FontDialog)object).setFontList(fontDataArray);
                    FontData fontData = ((FontDialog)object).open();
                    if (fontData != null) {
                        StylesOption.this.printerTimeSignatureFontData = fontData;
                    }
                }
            });
            Label label7 = new Label(composite, 0);
            label7.setText(TuxGuitar.getProperty("settings.config.styles.color.score-note"));
            final Button button7 = new Button(composite, 8);
            button7.setLayoutData(EditConfigAction.this.makeGridData(80, 25));
            this.setButtonColor(button7, this.scoreNoteRGB);
            button7.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColorDialog colorDialog = new ColorDialog(EditConfigAction.this.dialog);
                    colorDialog.setRGB(EditConfigAction.this.dialog.getDisplay().getSystemColor(2).getRGB());
                    colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                    RGB rGB = colorDialog.open();
                    if (rGB != null) {
                        StylesOption.this.scoreNoteRGB = new RGB(rGB.red, rGB.green, rGB.blue);
                        StylesOption.this.setButtonColor(button7, rGB);
                    }
                }
            });
            Label label8 = new Label(composite, 0);
            label8.setText(TuxGuitar.getProperty("settings.config.styles.color.tab-note"));
            final Button button8 = new Button(composite, 8);
            button8.setLayoutData(EditConfigAction.this.makeGridData(80, 25));
            this.setButtonColor(button8, this.tabNoteRGB);
            button8.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColorDialog colorDialog = new ColorDialog(EditConfigAction.this.dialog);
                    colorDialog.setRGB(EditConfigAction.this.dialog.getDisplay().getSystemColor(2).getRGB());
                    colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                    RGB rGB = colorDialog.open();
                    if (rGB != null) {
                        StylesOption.this.tabNoteRGB = new RGB(rGB.red, rGB.green, rGB.blue);
                        StylesOption.this.setButtonColor(button8, rGB);
                    }
                }
            });
            Label label9 = new Label(composite, 0);
            label9.setText(TuxGuitar.getProperty("settings.config.styles.color.play-note"));
            final Button button9 = new Button(composite, 8);
            button9.setLayoutData(EditConfigAction.this.makeGridData(80, 25));
            this.setButtonColor(button9, this.playNoteRGB);
            button9.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColorDialog colorDialog = new ColorDialog(EditConfigAction.this.dialog);
                    colorDialog.setRGB(EditConfigAction.this.dialog.getDisplay().getSystemColor(2).getRGB());
                    colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                    RGB rGB = colorDialog.open();
                    if (rGB != null) {
                        StylesOption.this.playNoteRGB = new RGB(rGB.red, rGB.green, rGB.blue);
                        StylesOption.this.setButtonColor(button9, rGB);
                    }
                }
            });
        }

        private void setButtonColor(Button button, RGB rGB) {
            Color color = new Color(EditConfigAction.this.dialog.getDisplay(), rGB);
            Image image = new Image((Device)EditConfigAction.this.dialog.getDisplay(), 80, 15);
            GC gC = new GC(image);
            gC.setBackground(color);
            gC.fillRectangle(0, 0, 80, 15);
            gC.dispose();
            button.setImage(image);
        }

        public void updateConfig() {
            if (this.defaultFontData != null) {
                this.getConfig().setProperty("FONT_DEFAULT", this.defaultFontData.getName() + "," + this.defaultFontData.getHeight() + "," + this.defaultFontData.getStyle());
            }
            if (this.noteFontData != null) {
                this.getConfig().setProperty("FONT_NOTE", this.noteFontData.getName() + "," + this.noteFontData.getHeight() + "," + this.noteFontData.getStyle());
            }
            if (this.timeSignatureFontData != null) {
                this.getConfig().setProperty("FONT_TIME_SIGNATURE", this.timeSignatureFontData.getName() + "," + this.timeSignatureFontData.getHeight() + "," + this.timeSignatureFontData.getStyle());
            }
            if (this.printerDefaultFontData != null) {
                this.getConfig().setProperty("FONT_PRINTER_DEFAULT", this.printerDefaultFontData.getName() + "," + this.printerDefaultFontData.getHeight() + "," + this.printerDefaultFontData.getStyle());
            }
            if (this.printerNoteFontData != null) {
                this.getConfig().setProperty("FONT_PRINTER_NOTE", this.printerNoteFontData.getName() + "," + this.printerNoteFontData.getHeight() + "," + this.printerNoteFontData.getStyle());
            }
            if (this.printerTimeSignatureFontData != null) {
                this.getConfig().setProperty("FONT_PRINTER_TIME_SIGNATURE", this.printerTimeSignatureFontData.getName() + "," + this.printerTimeSignatureFontData.getHeight() + "," + this.printerTimeSignatureFontData.getStyle());
            }
            if (this.scoreNoteRGB != null) {
                this.getConfig().setProperty("COLOR_SCORE_NOTE", this.scoreNoteRGB.red + "," + this.scoreNoteRGB.green + "," + this.scoreNoteRGB.blue);
            }
            if (this.tabNoteRGB != null) {
                this.getConfig().setProperty("COLOR_TAB_NOTE", this.tabNoteRGB.red + "," + this.tabNoteRGB.green + "," + this.tabNoteRGB.blue);
            }
            if (this.playNoteRGB != null) {
                this.getConfig().setProperty("COLOR_PLAY_NOTE", this.playNoteRGB.red + "," + this.playNoteRGB.green + "," + this.playNoteRGB.blue);
            }
        }
    }

    private class LanguageOption
    extends Option {
        private Button[] languages;

        public LanguageOption(SystemConfigManager systemConfigManager, ToolBar toolBar, Composite composite) {
            super(systemConfigManager, toolBar, composite, TuxGuitar.getProperty("settings.config.language"));
        }

        public void createOption() {
            this.getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));
            this.getToolItem().setImage(SystemImages.OPTION_LANGUAGE);
            this.getToolItem().addSelectionListener(this);
            Label label = new Label(this.getComposite(), 0);
            label.setText(TuxGuitar.getProperty("settings.config.language.choose"));
            String string = this.getConfig().getStringConfigValue("LANGUAGE");
            String[] stringArray = TuxGuitar.instance().getLanguageManager().getLanguages();
            if (stringArray != null) {
                this.languages = new Button[stringArray.length];
                for (int i = 0; i < this.languages.length; ++i) {
                    this.languages[i] = new Button(this.getComposite(), 16);
                    this.languages[i].setData(stringArray[i]);
                    this.languages[i].setLayoutData(this.getTabbedData());
                    this.languages[i].setText(TuxGuitar.getProperty(stringArray[i]));
                    if (!stringArray[i].equals(string)) continue;
                    this.languages[i].setSelection(true);
                }
            }
        }

        public void updateConfig() {
            String string = "";
            for (int i = 0; i < this.languages.length; ++i) {
                if (!this.languages[i].getSelection()) continue;
                string = (String)this.languages[i].getData();
            }
            this.getConfig().setProperty("LANGUAGE", string);
        }
    }

    private class ViewOption
    extends Option {
        private static final int MIN_WIDHT = 640;
        private static final int MIN_HEIGHT = 480;
        private Button mixer;
        private Button transport;
        private Button fretBoard;
        private Button maximized;
        private Button multitrack;
        private Button scoreEnabled;
        private Button[] layoutModes;
        private Spinner width;
        private Spinner height;

        public ViewOption(SystemConfigManager systemConfigManager, ToolBar toolBar, Composite composite) {
            super(systemConfigManager, toolBar, composite, TuxGuitar.getProperty("settings.config.view"));
        }

        public void createOption() {
            this.getToolItem().setText(TuxGuitar.getProperty("settings.config.view"));
            this.getToolItem().setImage(SystemImages.OPTION_VIEW);
            this.getToolItem().addSelectionListener(this);
            Label label = new Label(this.getComposite(), 0);
            label.setText(TuxGuitar.getProperty("settings.config.view.mode"));
            this.mixer = new Button(this.getComposite(), 32);
            this.mixer.setText(TuxGuitar.getProperty("show-mixer"));
            this.mixer.setLayoutData(this.getTabbedData());
            this.mixer.setSelection(this.getConfig().getBooleanConfigValue("SHOW_MIXER"));
            this.transport = new Button(this.getComposite(), 32);
            this.transport.setText(TuxGuitar.getProperty("show-transport"));
            this.transport.setLayoutData(this.getTabbedData());
            this.transport.setSelection(this.getConfig().getBooleanConfigValue("SHOW_TRANSPORT"));
            this.fretBoard = new Button(this.getComposite(), 32);
            this.fretBoard.setText(TuxGuitar.getProperty("show-fretboard"));
            this.fretBoard.setLayoutData(this.getTabbedData());
            this.fretBoard.setSelection(this.getConfig().getBooleanConfigValue("SHOW_FRETBOARD"));
            this.scoreEnabled = new Button(this.getComposite(), 32);
            this.scoreEnabled.setText(TuxGuitar.getProperty("layout.score-enabled"));
            this.scoreEnabled.setLayoutData(this.getTabbedData());
            this.scoreEnabled.setSelection(this.getConfig().getBooleanConfigValue("SHOW_SCORE"));
            this.multitrack = new Button(this.getComposite(), 32);
            this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
            this.multitrack.setLayoutData(this.getTabbedData());
            this.multitrack.setSelection(this.getConfig().getBooleanConfigValue("SHOW_MULTITRACK"));
            this.layoutModes = new Button[2];
            this.layoutModes[0] = new Button(this.getComposite(), 16);
            this.layoutModes[0].setText(TuxGuitar.getProperty("layout.page"));
            this.layoutModes[0].setLayoutData(this.getTabbedData());
            this.layoutModes[1] = new Button(this.getComposite(), 16);
            this.layoutModes[1].setText(TuxGuitar.getProperty("layout.linear"));
            this.layoutModes[1].setLayoutData(this.getTabbedData());
            int n = this.getConfig().getIntConfigValue("LAYOUT_MODE");
            switch (n) {
                case 1: {
                    this.layoutModes[0].setSelection(true);
                    break;
                }
                case 2: {
                    this.layoutModes[1].setSelection(true);
                }
            }
            label = new Label(this.getComposite(), 0);
            label.setText(TuxGuitar.getProperty("settings.config.view.size"));
            this.maximized = new Button(this.getComposite(), 32);
            this.maximized.setText(TuxGuitar.getProperty("settings.config.view.size.maximized"));
            this.maximized.setLayoutData(this.getTabbedData());
            this.maximized.setSelection(this.getConfig().getBooleanConfigValue("MAXIMIZED"));
            Composite composite = new Composite(this.getComposite(), 0);
            composite.setLayout(new GridLayout(2, true));
            Label label2 = new Label(composite, 0);
            label2.setText(TuxGuitar.getProperty("settings.config.view.size.width"));
            label2.setLayoutData(this.getTabbedData());
            this.width = new Spinner(composite, 2048);
            this.width.setMinimum(640);
            this.width.setMaximum(((EditConfigAction)EditConfigAction.this).getEditor().getTablature().getDisplay().getBounds().width);
            this.width.setSelection(this.getConfig().getIntConfigValue("WIDTH"));
            this.width.setLayoutData(this.getTabbedData());
            Label label3 = new Label(composite, 0);
            label3.setText(TuxGuitar.getProperty("settings.config.view.size.height"));
            label3.setLayoutData(this.getTabbedData());
            this.height = new Spinner(composite, 2048);
            this.height.setMinimum(480);
            this.height.setMaximum(((EditConfigAction)EditConfigAction.this).getEditor().getTablature().getDisplay().getBounds().height);
            this.height.setSelection(this.getConfig().getIntConfigValue("HEIGHT"));
            this.height.setLayoutData(this.getTabbedData());
            this.width.setEnabled(!this.maximized.getSelection());
            this.height.setEnabled(!this.maximized.getSelection());
            this.maximized.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ViewOption.this.width.setEnabled(!ViewOption.this.maximized.getSelection());
                    ViewOption.this.height.setEnabled(!ViewOption.this.maximized.getSelection());
                }
            });
        }

        public void updateConfig() {
            for (int i = 0; i < this.layoutModes.length; ++i) {
                if (!this.layoutModes[i].getSelection()) continue;
                this.getConfig().setProperty("LAYOUT_MODE", i + 1);
            }
            this.getConfig().setProperty("SHOW_SCORE", this.scoreEnabled.getSelection());
            this.getConfig().setProperty("SHOW_MULTITRACK", this.multitrack.getSelection());
            this.getConfig().setProperty("SHOW_MIXER", this.mixer.getSelection());
            this.getConfig().setProperty("SHOW_TRANSPORT", this.transport.getSelection());
            this.getConfig().setProperty("SHOW_FRETBOARD", this.fretBoard.getSelection());
            this.getConfig().setProperty("MAXIMIZED", this.maximized.getSelection());
            this.getConfig().setProperty("WIDTH", this.width.getSelection());
            this.getConfig().setProperty("HEIGHT", this.height.getSelection());
        }
    }

    private abstract class Option
    extends SelectionAdapter {
        private SystemConfigManager config;
        private ToolBar toolBar;
        private Composite parent;
        private Group group;
        private Composite composite;
        private ToolItem toolItem;

        public Option(SystemConfigManager systemConfigManager, ToolBar toolBar, Composite composite, String string) {
            this.config = systemConfigManager;
            this.toolBar = toolBar;
            this.parent = composite;
            this.toolItem = new ToolItem(toolBar, 16);
            this.group = new Group(composite, 16);
            this.group.setLayout(new GridLayout());
            this.group.setLayoutData(this.getGroupData());
            this.group.setText(string);
            this.composite = new Composite(this.group, 16);
            this.composite.setLayout(new GridLayout());
        }

        public abstract void createOption();

        public abstract void updateConfig();

        public void setVisible(boolean bl) {
            this.toolItem.setSelection(bl);
            this.group.setVisible(bl);
        }

        protected FormData getGroupData() {
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            return formData;
        }

        protected GridData getTabbedData() {
            return this.getTabbedData(20);
        }

        protected GridData getTabbedData(int n) {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalIndent = n;
            return gridData;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            EditConfigAction.this.select(this);
        }

        public SystemConfigManager getConfig() {
            return this.config;
        }

        public Composite getComposite() {
            return this.composite;
        }

        public ToolItem getToolItem() {
            return this.toolItem;
        }
    }
}

