/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.insert;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.chord.ChordEditor;
import org.herac.tuxguitar.gui.chord.ChordList;
import org.herac.tuxguitar.gui.chord.ChordSelector;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.component.UndoableComponentGeneric;
import org.herac.tuxguitar.song.models.Chord;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

public class InsertChordAction
extends Action {
    public static final String NAME = "INSERT_CHORD";
    private ChordEditor editor;
    private ChordSelector selector;
    private ChordList list;

    public InsertChordAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showInsertDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }

    public void showInsertDialog(Shell shell) {
        Caret caret = this.getEditor().getTablature().getCaret();
        final SongTrackCoords songTrackCoords = caret.getSongTrackCoords();
        final MeasureCoords measureCoords = caret.getMeasureCoords();
        final MeasureComponent measureComponent = caret.getSelectedComponent();
        if (songTrackCoords != null && measureCoords != null && measureComponent != null) {
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("chord.editor"));
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(new GridData(4, 4, true, true));
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout(new GridLayout());
            composite2.setLayoutData(new GridData(4, 4, true, true));
            this.selector = new ChordSelector(composite2, 0);
            Composite composite3 = new Composite(composite, 0);
            composite3.setLayout(new GridLayout());
            composite3.setLayoutData(new GridData(4, 4, true, true));
            this.editor = new ChordEditor(composite3, 2048, (short)caret.getSongTrackCoords().getTrack().getStrings().size());
            this.editor.setLayoutData(new GridData(this.editor.getWidth() + 60, this.editor.getHeight() + 60));
            Composite composite4 = new Composite(shell2, 0);
            composite4.setLayout(new GridLayout(2, false));
            composite4.setLayoutData(new GridData(4, 4, true, true));
            this.list = new ChordList(composite4);
            this.selector.setEditor(this.editor);
            this.selector.setList(this.list);
            this.selector.setTunning(this.getTunning(songTrackCoords));
            this.list.setEditor(this.editor);
            Composite composite5 = new Composite(shell2, 0);
            composite5.setLayout(new GridLayout(2, false));
            composite5.setLayoutData(new GridData(0x1000008, 4, true, true));
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 80;
            gridData.minimumHeight = 25;
            Button button = new Button(composite5, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData(gridData);
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    InsertChordAction.this.insertChord(InsertChordAction.this.editor, songTrackCoords, measureCoords, measureComponent);
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite5, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.setLayoutData(gridData);
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            this.setCurrentChord();
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }
    }

    private int[] getTunning(SongTrackCoords songTrackCoords) {
        int[] nArray = new int[songTrackCoords.getTrack().getStrings().size()];
        for (InstrumentString instrumentString : songTrackCoords.getTrack().getStrings()) {
            nArray[nArray.length - instrumentString.getNumber()] = instrumentString.getValue();
        }
        return nArray;
    }

    private void insertChord(ChordEditor chordEditor, SongTrackCoords songTrackCoords, MeasureCoords measureCoords, MeasureComponent measureComponent) {
        UndoableComponentGeneric undoableComponentGeneric = UndoableComponentGeneric.startUndo();
        this.getSongManager().getMeasureManager().removeAllComponentsAt(measureCoords.getMeasure(), measureComponent.getStart());
        for (InstrumentString instrumentString : songTrackCoords.getTrack().getStrings()) {
            int n = chordEditor.getValue(instrumentString.getNumber());
            if (n < 0) continue;
            Note note = new Note(n, measureComponent.getStart(), (Duration)measureComponent.getDuration().clone(), 64, instrumentString.getNumber(), false, new NoteEffect());
            this.getSongManager().getMeasureManager().addNote(measureCoords.getMeasure(), note);
        }
        this.fireUpdate(measureCoords.getMeasure().getNumber());
        this.redraw();
        this.getEditor().getUndoManager().addEdit(undoableComponentGeneric.endUndo());
    }

    private void setCurrentChord() {
        Caret caret = this.getEditor().getTablature().getCaret();
        if (caret.getSelectedComponent() instanceof NoteCoords) {
            NoteCoords noteCoords;
            int n = -1;
            int n2 = -1;
            List list = caret.getMeasureCoords().getComponents(caret.getSelectedComponent().getStart());
            for (MeasureComponent measureComponent : list) {
                if (!(measureComponent instanceof NoteCoords)) continue;
                noteCoords = (NoteCoords)measureComponent;
                if (n < 0 || n < noteCoords.getNote().getValue()) {
                    n = noteCoords.getNote().getValue();
                }
                if (n2 >= 0 && n2 <= noteCoords.getNote().getValue()) continue;
                n2 = noteCoords.getNote().getValue();
            }
            if (n > 6 && n2 >= 0) {
                this.editor.setFret((short)n2);
            }
            for (MeasureComponent measureComponent : list) {
                if (!(measureComponent instanceof NoteCoords)) continue;
                noteCoords = (NoteCoords)measureComponent;
                this.editor.addValue(noteCoords.getNote().getValue(), noteCoords.getNote().getString());
            }
        }
    }

    private List getHotChords() {
        ArrayList<Chord> arrayList = new ArrayList<Chord>();
        Chord chord = new Chord(6);
        chord.addFretValue(0, 0);
        chord.addFretValue(1, 1);
        chord.addFretValue(2, 0);
        chord.addFretValue(3, 2);
        chord.addFretValue(4, 3);
        arrayList.add(chord);
        chord = new Chord(6);
        chord.addFretValue(0, 2);
        chord.addFretValue(1, 3);
        chord.addFretValue(2, 2);
        chord.addFretValue(3, 0);
        arrayList.add(chord);
        return arrayList;
    }
}

