/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.insert;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeCloseRepeat;

public class CloseRepeatAction
extends Action {
    public static final String NAME = "CLOSE_REPEAT";

    public CloseRepeatAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = this.getEditor().getTablature().getCaret().getSongCoords();
        this.showCloseRepeatDialog(this.getEditor().getTablature().getShell(), measureCoords, songCoords);
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }

    public void showCloseRepeatDialog(Shell shell, final MeasureCoords measureCoords, final SongCoords songCoords) {
        if (measureCoords != null) {
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("repetitions"));
            int n = measureCoords.getMeasure().getNumberOfRepetitions();
            if (n < 1) {
                n = 1;
            }
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(new GridData(4, 4, true, true));
            Label label = new Label(composite, 0);
            label.setText(TuxGuitar.getProperty("repeat.number-of-repetitions"));
            final Spinner spinner = new Spinner(composite, 2048);
            spinner.setLayoutData(new GridData(50, 13));
            spinner.setMinimum(0);
            spinner.setMaximum(100);
            spinner.setSelection(n);
            spinner.setLayoutData(new GridData(0x1000008, 4, true, true));
            Composite composite2 = new Composite(shell2, 0);
            composite2.setLayout(new GridLayout(2, false));
            composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 80;
            gridData.minimumHeight = 25;
            Button button = new Button(composite2, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData(gridData);
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CloseRepeatAction.this.closeRepeat(measureCoords, songCoords, spinner.getSelection());
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite2, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.setLayoutData(gridData);
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n2 = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n3 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n2, n3);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }
    }

    private void closeRepeat(MeasureCoords measureCoords, SongCoords songCoords, int n) {
        UndoableChangeCloseRepeat undoableChangeCloseRepeat = UndoableChangeCloseRepeat.startUndo();
        n = Math.abs(n);
        this.getSongManager().changeCloseRepeat(measureCoords.getMeasure().getStart(), n);
        this.updateTablature();
        this.getEditor().getUndoManager().addEdit(undoableChangeCloseRepeat.endUndo(n));
    }
}

